#ifndef STATRECT_H
#define STATRECT_H
//========================================================================================
//		
//     File:			StatRect.h
//     Creation Date:	4/14/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef BRADORN2_H
#include <BRAdorn2.h>
#endif

//========================================================================================
//	class cStatusRect
//
// This class is a derivation of BR_CDrawRectangle which is used to make rectangles on the
// status line to print text into.
//========================================================================================

class cStatusRect : public BR_CRectangleAdorner
{
public:
						cStatusRect(BR_CRectangle& rNewBounds,
									unsigned short wNewThickness,
									BR_CColor      penColor,
									BR_CPen::PenStyle newPenStyle,
									BR_CColor      clrNewFill);
	virtual				~cStatusRect();
	virtual void		Draw(BR_CView *view, const BR_CRectangle &area);
	virtual void		SetText(BR_TString<BR_Char>& text);

private:
	BR_CCharString255	fRectText;		// The text to be displayed on the status bar
	void				DrawText(BR_CView& pane);
	
						BR_SETCLASSNAME(cStatusRect);
};

#endif
