//========================================================================================
//	
//     File:			ColorWin.cp
//     Creation Date:	4/13/93
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef COLORWIN_H
#include "ColorWin.h"
#endif

#ifndef PAINT_H
#include "Paint.h"
#endif

#ifndef COLORGRI_H
#include "ColorGri.h"
#endif

DEFINE_CLASS(cColorWindow, BR_CWindow)

//----------------------------------------------------------------------------------------
// cColorWindow::cColorWindow
//----------------------------------------------------------------------------------------

cColorWindow::cColorWindow(BR_CView* enclosure,
						   BR_CBureaucrat* supervisor,
						   cDrawState* State) :
	BR_CWindow(enclosure, supervisor, kFloatingWindow | kHasCaption)
{
	// Get size of the color grid inside of the window
	BR_CPoint Size(cColorGrid::eColumnWidth * cColorGrid::eNumColumns, cColorGrid::eRowHeight * cColorGrid::eNumRows);
	SetInteriorSize(Size);
	Place(300, 100, FALSE);
	BR_CCharString32 Title("Colors");
	SetText(Title);

	// Create the color grid
	new cColorGrid(this, this, State);
	Show();
}

//----------------------------------------------------------------------------------------
// cColorWindow::~cColorWindow
//----------------------------------------------------------------------------------------

cColorWindow::~cColorWindow()
{
}
