#ifndef MYDRWOBJ_H
#define MYDRWOBJ_H

//========================================================================================
//
//     File:			myDrwObj.h
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   BRGRHELP_H
#include <BRGrHelp.h>
#endif

#ifndef   BROBJECT_H
#include <BRObject.h>
#endif

#ifndef   BRPEN_H
#include <BRPen.h>
#endif

#ifndef   BRRECT_H
#include <BRRect.h>
#endif

#ifndef   BRSTDDEF_H
#include <BRStdDef.h>
#endif

//========================================================================================
// Forward class declarations
//========================================================================================

class CMyDrawView;

//========================================================================================
//	CLASS CMyDrawObject
//========================================================================================

class CMyDrawObject : public BR_CObject
{
public:

	// Constructor/Destructor
	CMyDrawObject(const BR_CPen& itsPen, BR_Boolean select = TRUE);
	virtual ~CMyDrawObject();

	// Drawing
	virtual void Draw(CMyDrawView* theView) = 0;
	virtual void HighlightIfSelected(CMyDrawView* theView);
	virtual void Refresh(CMyDrawView* theView);
	
	// Accessors
	BR_Boolean GetSelect();
    virtual BR_Boolean IsPointInShape(const BR_CPoint& ptMouse);

	// Mutators
	virtual void SetSelect(BR_Boolean value);
	virtual void SetSelectAndDraw(BR_Boolean value, CMyDrawView* itsView);
	
	// Static Data Member
	static BR_Distance	fLeaway;
	
protected:

	// Drawing
	virtual void DrawAKnob(CMyDrawView* theView, const BR_CPoint& atPoint);
	virtual void DrawKnobs(CMyDrawView* theView) = 0;

	// Data Members
	BR_CRectangle		fExtent;			// fully encloses the object's image
	BR_CDeferredPen		fPen;

private:

	// Data Members
	BR_Boolean			fSelected;

};

//----------------------------------------------------------------------------------------
// CMyDrawObject::IsPointInShape
//----------------------------------------------------------------------------------------

BR_Boolean CMyDrawObject::GetSelect() 
{
	return (fSelected);
}

//========================================================================================
//	CLASS CMyDrawLine
//========================================================================================

class CMyDrawLine : public CMyDrawObject
{
public:

	// Constructor/Destructor
	CMyDrawLine(const BR_CPoint& point1, const BR_CPoint& point2,
		const BR_CPen& itsPen, BR_Boolean select = TRUE);

	virtual ~CMyDrawLine();

	// Drawing
	virtual void Draw(CMyDrawView* theView);	
	
protected:

	// Accessors
    virtual BR_Boolean IsPointInShape(const BR_CPoint& theMouse);
	
	// Drawing
	virtual void DrawKnobs(CMyDrawView* theView);

private:

	// Data Members
	BR_CPoint	fPoint1;
	BR_CPoint	fPoint2;
};

//========================================================================================
//	CLASS CMyDrawArea
//========================================================================================

class CMyDrawArea : public CMyDrawObject
{
public:
	CMyDrawArea(const BR_CRectangle& newBounds,
		const BR_CPen& itsPen, BR_Boolean select = TRUE);
	virtual ~CMyDrawArea();

protected:

	// Drawing
	virtual void DrawKnobs(CMyDrawView* theView);
};

//========================================================================================
//	CLASS CMyDrawRect
//========================================================================================

class CMyDrawRect : public CMyDrawArea
{
public:

	// Constructor/Destructor
	CMyDrawRect(const BR_CRectangle& newBounds,
		const BR_CPen& itsPen, BR_Boolean select = TRUE);

	virtual ~CMyDrawRect();

	// Drawing
	virtual void Draw(CMyDrawView* theView);

};

//========================================================================================
//	CLASS CMyDrawEllipse
//========================================================================================

class CMyDrawEllipse : public CMyDrawArea
{
public:

	// Constructor/Destructor
	CMyDrawEllipse(const BR_CRectangle& newBounds,
		const BR_CPen& itsPen, BR_Boolean select = TRUE);

	virtual ~CMyDrawEllipse();

	// Drawing
	virtual void Draw(CMyDrawView* theView);
	
};

//========================================================================================
//	CLASS CMyDrawRRect
//========================================================================================

class CMyDrawRRect : public CMyDrawArea
{
public:

	// Constructor/Destructor
	CMyDrawRRect(const BR_CRectangle& newBounds,
		const BR_Distance itsWidth, const BR_Distance itsHeight,
		const BR_CPen& itsPen, BR_Boolean select = TRUE);

	virtual ~CMyDrawRRect();

	// Drawing
	virtual void Draw(CMyDrawView* theView);
	
private:

	// Data Members
    BR_Distance	fWidth;
    BR_Distance fHeight;
};

#endif