//========================================================================================
//
//     File:			myDrwNum.cp
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Symantec Corporation, 10201 Torre Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   MYDRWNUM_H
#include "myDrwNum.h"
#endif

#ifndef   MYDRWDOC_H
#include "myDrwDoc.h"
#endif

#ifndef   BRDYNSTR_H
#include <BRDynStr.h>
#endif

//========================================================================================
// CLASS CPenSizeField
//========================================================================================

//----------------------------------------------------------------------------------------
// CPenSizeField::CPenSizeField
//----------------------------------------------------------------------------------------

CPenSizeField::CPenSizeField(BR_CView* enclosure,
		BR_CBureaucrat* supervisor,
		const BR_CModule& module,
		BR_SResource& viewResource):
	BR_CNumberField(enclosure, supervisor, module, viewResource)
{
	SetTextLimit(2);	// Assumes US-style numbers. 
						// There may be a better (but more complicated) world-wide way of determining this.
}

//----------------------------------------------------------------------------------------
// CPenSizeField::~CPenSizeField
//----------------------------------------------------------------------------------------
CPenSizeField::~CPenSizeField()
{
}

//----------------------------------------------------------------------------------------
// CPenSizeField::DoKeyDown
//----------------------------------------------------------------------------------------
BR_Boolean CPenSizeField::DoKeyDown(BR_CBureaucrat::Key theKey,
							unsigned short repeatCount,
							BR_Boolean callSupervisor)
{
	// Be sure the radio station is set correctly if user types in a value.
	DoCommand(GetViewId(), this);
    return (BR_CNumberField::DoKeyDown(theKey, repeatCount, callSupervisor));
}

//----------------------------------------------------------------------------------------
//	CPenSizeField::IsValid
//----------------------------------------------------------------------------------------

BR_Boolean CPenSizeField::IsValid()
{
	BR_CStr255 strBuffer;

	GetText(strBuffer);
	long value;
	BR_Boolean result = strBuffer.IsValidRange(1, 10, &value);
	if (result)
		fValue = BR_CPen::PenThickness(value);

	return result;
}

//----------------------------------------------------------------------------------------
// CPenSizeField::SeValue
//----------------------------------------------------------------------------------------
void CPenSizeField::SetValue(BR_CPen::PenThickness itsThickness)
{
	// This method should be called before the dialog is shown.
	fValue = itsThickness;
	BR_CStr255 value;
	value.FormatInteger(fValue);
	SetText(value, FALSE);			// don't redraw because we're not shown yet.
	SelectAll();
}
