#ifndef EDEDTEXT_H
#define EDEDTEXT_H
//===================================================================================
//
//     File:			EdEdText.h
//     Release Version:	$Revision$
//
//     COPYRIGHT 1993 SYMANTEC CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT
//     NOTICE IS PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE CONTAINS PROPRIETARY AND CONFIDENTIAL INFORMATION OF SYMANTEC
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF SYMANTEC CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions
//     as set forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and
//     Computer Software clause at DFARS 252.227-7013.
//     Symantec Corporation, 10201 Torre Avenue, Cupertino, CA 95014.
//
//===================================================================================

#ifndef BREDITTX_H
#include <BREditTx.h>
#endif

//-----------------------------------------------------------------------------------
// class cEdEditText
//
// The text editor class which is derived from BR_CEditText and has some additional 
// functionality.
//-----------------------------------------------------------------------------------

class cEdEditText : public BR_CEditText
{
public:
							cEdEditText(BR_CView			*enclosure,
										BR_CBureaucrat		*supervisor,
										BR_Distance			width,
										BR_Distance			height,
										BR_Coordinate		x,
										BR_Coordinate		y,
										ViewSizing			horzSizing,
										ViewSizing			vertSizing,
										ViewUnits			viewUnit,
										const BR_CRectangle	&boundsRect);
	virtual					~cEdEditText();

	virtual void			DoSelectAll();
	virtual	void 			DoFind();
	virtual	void 			DoFindAgain();
	virtual	void 			DoReplace();
	virtual	void 			DoReplaceAgain();
	virtual	void 			DoGoToLine();
	virtual	void			DoFont();
			BR_Boolean		SearchText(const BR_TString<BR_Char> &searchString,
									   BR_Boolean fromStart);
			void			ReplaceText(BR_Boolean fromStart);
	
	// Overridden methods
	virtual void			UpdateMenus(BR_CMenuBar &menuBar,
										BR_Boolean fCallSupervisor);
	virtual BR_Boolean		DoCommand(CommandId cmdId, 
									  BR_CObject *notifier,
									  BR_Boolean fCallSupervisor);
									  	
private:
		BR_CDynamicCharString	fFindText;			// The text to find when using the
													// find or find again option.
		BR_CDynamicCharString	fReplaceFindText;	// The text to find when using the
													// replace or replace again option.
		BR_CDynamicCharString	fReplacementText;	// The text to insert when using the 
													// replace or replace again option.
											
							BR_SETCLASSNAME(cEdEditText);
};

#endif
