//========================================================================================
//
//     File:		QTMVDoc.cp
//     Release Version:	$Revision$
//
//     Original Author:	Lou Infeld/Craig Hansen-Sturm
//     Creation Date:	March 18, 1993
//
//     COPYRIGHT 1993 APPLE COMPUTER CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF APPLE COMPUTER
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF APPLE COMPUTER CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Apple Computer Corporation, 20525 Mariani Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef QTMVDOC_H
#include <QTMVDoc.h>
#endif

#ifndef  WCAPP_H
#include <wcapp.h>
#endif

#ifndef WCWINDOW_H
#include <wcdocwin.h>
#endif

//========================================================================================
// RunTime type information
//========================================================================================

DEFINE_CLASS(QT_CMovieDocument, cDocument)

QT_CMovieDocument::QT_CMovieDocument() :
	cDocument(*cApplication::GetCurrentApplication(), TRUE, TRUE)
{
	fMovie     = 0;
	fMovieView = 0;
	fMovieDoc  = 0;	
}


QT_CMovieDocument::~QT_CMovieDocument()
{
	this->Finalize();
}

BOOL QT_CMovieDocument::Quit()
{
	fMovieDoc->Close();
	
	this->Finalize();
	
	return TRUE;
}

void QT_CMovieDocument::Finalize()
{
	if ( fMovieView ) 
	{ 
		delete fMovieView;
		fMovieView = 0;
	}
	if ( fMovieDoc )
	{
		delete fMovieDoc;
		fMovieDoc  = 0;
	}
	if ( fMovie ) 
	{
		delete fMovie;	
		fMovie = 0;
	}	
}

BOOL QT_CMovieDocument::OpenFile(cFileSpec& /*theFileSpec*/)
{
	// create a new movie, then prompt the user for a file
	fMovie = new QT_CMovie(this);

	// now create the window and the pane which contains the movie
	this->NewWindow();
	
	return TRUE;
}

void QT_CMovieDocument::NewWindow()
{
	cMDIAppDesktop * appDesktop = (cMDIAppDesktop *)&cApplication::GetCurrentApplication()->GetAppDesktop();

	// Create a document window.
	fMovieDoc = new cDocWindow(*appDesktop, *this, 0);

	// Create the Movie View with its associated Playback Controller
	fMovieView = new QT_CMovieStandardPlaybackView(fMovieDoc, this, fMovie);

	// Show the window
	fMovieDoc->Show();

}
