//========================================================================================
//
//     File:		QTMVApp.cp
//     Release Version:	$Revision$
//
//     Original Author:	Lou Infeld
//     Creation Date:	March 18, 1993
//
//     COPYRIGHT 1993 APPLE COMPUTER CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF APPLE COMPUTER
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF APPLE COMPUTER CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Apple Computer Corporation, 20525 Mariani Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef QTMVAPP_H
#include <QTMVApp.h>
#endif

#ifndef QTMVDOC_H
#include <QTMVDoc.h>
#endif

#ifndef BCL_H
#include <bcl.h>
#endif

//========================================================================================
// RunTime type information
//========================================================================================

DEFINE_CLASS(QT_CMovieApplication, cApplication)

QT_CMovieApplication::QT_CMovieApplication(cSystem& system, cModule& module, USHORT resId) :
		cApplication(system, module, resId)
{
}

QT_CMovieApplication::~QT_CMovieApplication()
{
}

cDocument& QT_CMovieApplication::CreateDocument()
{
	// Create a Movie document

	QT_CMovieDocument *movieDoc = new QT_CMovieDocument();
	
	// Create a Movie file (not really, just a Movie)
	
	movieDoc->NewFile();
	
	return *movieDoc;
}

cDocument& QT_CMovieApplication::OpenDocument(cFileSpec& fileSpec)
{
	// Create a Movie document

	QT_CMovieDocument *movieDoc = new QT_CMovieDocument();
	
	// Open the Movie file
	
	movieDoc->OpenFile(fileSpec);
	
	return *movieDoc;
}

BOOL QT_CMovieApplication::DoCommand(	unsigned short commandId,
																			 			cObject* notifier,
																			 			BOOL callSupervisor )
{
	cFileSpec __fileSpec;		// dummy
	
	if ( commandId == cmdOpen )
	{
			OpenDocument(__fileSpec);
			return TRUE;
	}
	else return cApplication::DoCommand(commandId, notifier, callSupervisor);
}
