//========================================================================================
//
//     File:		QTMovie.h
//     Release Version:	$Revision$
//
//     Original Author:	 Lou Infeld
//     Windows Version:  Craig Hansen-Sturm
//     Creation Date:	 March 16, 1993
//
//     COPYRIGHT 1993 APPLE COMPUTER CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF APPLE COMPUTER
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF APPLE COMPUTER CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Apple Computer Corporation, 20525 Mariani Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef QTMOVIE_H
#define QTMOVIE_H

#ifndef WCOBJECT_H
#include <wcobject.h>
#endif

#ifndef WCFILSPC_H
#include <wcfilspc.h>
#endif

#ifndef GCRECT_H
#include <gcrect.h>
#endif

#ifndef GCDYNSTR_H
#include <gcdynstr.h>
#endif

#ifndef QTMVFILE_H
#include <QTMVFile.h>
#endif

#ifdef  BUILD_WIN
#ifndef __QTW_H__
#include "<QTW.H>"
#endif // __QTW_H__
#endif // BUILD_WIN

#ifdef  BUILD_MAC
#ifndef __MOVIES__
#include <Movies.h>
#endif
#endif // BUILD_MAC

#ifdef DEBUG
extern cStr32 gErrorName;
#endif


//========================================================================================
// Forward Class Declarations
//========================================================================================

class cBureaucrat;

//========================================================================================
// CLASS QT_CMovie
//
//		Provides a user interface into the Movie Toolbox both at a low level
//		and at a simplified higher level
//
//========================================================================================

class QT_CMovie : public cObject
{
	public:
	
		// Constructors
		
									QT_CMovie(cBureaucrat * aSupervisor = NULL);
									QT_CMovie(Movie movie);
#ifdef BUILD_MAC
									QT_CMovie(	Handle h, short newMovieFlags = newMovieActive, 
												BOOL *wereDataRefsChanged = 0);
#endif
									operator Movie();

		// Destructor

		virtual					~QT_CMovie();
		
		// General Methods
		
					void			AskUserForMovie(cBureaucrat * aSupervisor = NULL);
					void			SaveMovieToFile();
					void			SaveMovieToFile(const cFileSpec& fileSpec);
					BOOL			AskUserForFile();
					Movie			GetMovieFromFile(short newMovieFlags = newMovieActive, BOOL *wereDataRefsChanged = 0);
					void			OpenFile();
					void			CreateFile(Movie *newMovie = 0);
					void			CloseFile();
					void			DeleteFile();
					Movie			NewMovieFromFile(
											short newMovieFlags = newMovieActive, 
											BOOL *wereDataRefsChanged = 0);
		
					size_t		GetSize() const;
					TimeValue	GetDuration() const;
					Movie			GetMovie() const;
					void			SetMovie(Movie movie);
					cStr255		GetName() const;
					BOOL			HasMovieChanged() const;
				
#ifdef BUILD_MAC	
					void			BedMacNewMovie(short newMovieFlags = newMovieActive);
					void			BedMacSetCreator(OSType creator);
					void			BedMacSetScriptTag(ScriptCode scriptTag);
					void			BedMacSetCreateFileFlags(long flags);
					void			BedMacSetMovieFlattenFlags(long flags);
					void			BedMacAddMovieToFile();
					void			BedMacRemoveMovieFromFile();
					void			BedMacUpdateMovieInFile();
					void			BedMacConvertMovieToFile();					
#endif	 // BUILD_MAC

	private:
	
#ifdef BUILD_MAC					
			pascal static	void			
										ErrorHandler(OSErr err, long refcon);
#endif // BUILD_MAC
#ifdef BUILD_WIN
					void			ErrorHandler(OSErr err);
#endif // BUILD_WIN
	
					void			Init();
					TimeValue	CalculateDuration() const;
		
					Movie 					 fMovie;
					QT_CMovieFile *	 fMovieFile;
		
 				  SETCLASSNAME(QT_CMovie);
};

//========================================================================================
//	INLINE METHODS
//========================================================================================

inline void QT_CMovie::SaveMovieToFile()
{
	fMovieFile->SaveMovieToFile(fMovie);
}
inline void QT_CMovie::SaveMovieToFile(const cFileSpec& fileSpec)
{
	fMovieFile->SaveMovieToFile(fMovie, (cFileSpec *)&fileSpec);
}
inline size_t QT_CMovie::GetSize() const
{
	return fMovieFile->GetSize();
}
inline TimeValue QT_CMovie::GetDuration() const
{
	return this->CalculateDuration();
}
inline Movie QT_CMovie::GetMovie() const
{
	return fMovie;
}
inline cStr255 QT_CMovie::GetName() const
{
	return fMovieFile->GetName();
}
inline BOOL QT_CMovie::HasMovieChanged() const
{
#ifdef  BUILD_MAC	
	return ::HasMovieChanged(fMovie);
#endif  // BUILD_MAC

#ifdef  BUILD_WIN
	return FALSE;
#endif  // BUILD_MAC
}
inline void QT_CMovie::SetMovie(Movie movie)
{
	fMovie = movie;
}
inline BOOL QT_CMovie::AskUserForFile()
{
	return fMovieFile->AskUserForFile();
}
inline Movie QT_CMovie::GetMovieFromFile(short newMovieFlags, BOOL *wereDataRefsChanged)
{
	return fMovieFile->GetMovieFromFile(newMovieFlags, wereDataRefsChanged);
}
inline void QT_CMovie::OpenFile()
{
	fMovieFile->Open();
}
inline void QT_CMovie::CreateFile(Movie *newMovie)
{
	fMovieFile->Create(newMovie);
}
inline void QT_CMovie::CloseFile()
{
	fMovieFile->Close();
}
inline void QT_CMovie::DeleteFile()
{
	fMovieFile->Delete();
}
inline Movie QT_CMovie::NewMovieFromFile(short newMovieFlags, BOOL *wereDataRefsChanged)
{
	return fMovieFile->NewMovieFromFile(newMovieFlags, wereDataRefsChanged);
}
#ifdef BUILD_MAC
inline void QT_CMovie::BedMacSetCreator(OSType creator)
{
	fMovieFile->SetCreator(creator);
}
inline void QT_CMovie::BedMacSetScriptTag(ScriptCode scriptTag)
{
	fMovieFile->SetScriptTag(scriptTag);
}
inline void QT_CMovie::BedMacSetCreateFileFlags(long flags)
{
	fMovieFile->SetCreateFileFlags(flags);
}
inline void QT_CMovie::BedMacSetMovieFlattenFlags(long flags)
{
	fMovieFile->SetMovieFlattenFlags(flags);
}
inline void QT_CMovie::BedMacAddMovieToFile()
{
	fMovieFile->BedMacAddMovieToFile(fMovie);
}
inline void QT_CMovie::BedMacRemoveMovieFromFile()
{
	fMovieFile->BedMacRemoveMovieFromFile();
}
inline void QT_CMovie::BedMacUpdateMovieInFile()
{
	fMovieFile->BedMacUpdateMovieInFile(fMovie);
}
inline void QT_CMovie::BedMacConvertMovieToFile()
{
	fMovieFile->BedMacConvertMovieToFile(fMovie);
}
#endif  // BUILD_MAC

#endif // QTMOVIE_H
