//========================================================================================
//
//     File:		QTContrl.h
//     Release Version:	$Revision$
//
//     Original Author:	Craig Hansen-Sturm
//     Creation Date:	March 16, 1993
//
//     COPYRIGHT 1993 APPLE COMPUTER CORPORATION. ALL RIGHTS RESERVED. UNPUBLISHED -- RIGHTS
//     RESERVED UNDER THE COPYRIGHT LAWS OF THE UNITED STATES. USE OF COPYRIGHT NOTICE IS
//     PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION OR DISCLOSURE.
//
//     THIS SOFTWARE Contains PROPRIETARY AND CONFIDENTIAL INFORMATION OF APPLE COMPUTER
//     CORPORATION. USE, DISCLOSURE, OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
//     EXPRESS WRITTEN PERMISSION OF APPLE COMPUTER CORPORATION.
//
//     RESTRICTED RIGHTS LEGEND
//     Use, duplication, or disclosure by the Government is subject to restrictions as Set
//     forth in subparagraph (c)(l)(ii) of the Rights in Technical Data and Computer
//     Software clause at DFARS 252.227-7013. Apple Computer Corporation, 20525 Mariani Avenue,
//     Cupertino, CA 95014.
//
//========================================================================================

#ifndef   QTCONTRL_H
#define   QTCONTRL_H
 
#ifndef   QTCOMPNT_H
#include "QTCompnt.h"
#endif

#ifndef   QTMOVIE_H
#include "QTMovie.h"
#endif

#ifndef   WCPANE_H
#include "wcpane.h"
#endif

#ifndef   WCCHORE_H
#include "wcchore.h"
#endif

//========================================================================================
//	Forward class declaration
//========================================================================================

class QT_CMoviePlaybackController;
class QT_CMovieScreenPlaybackView;
class QT_CMovieControlBarPlaybackView;

//========================================================================================
// CLASS QT_CMoviePlaybackControllerBackgroundChore
//========================================================================================
class QT_CMoviePlaybackControllerBackgroundChore : public cTimerChore
{
public:	
														QT_CMoviePlaybackControllerBackgroundChore(
															QT_CMoviePlaybackController* aPlaybackController, 
															cPane* aPane, 
															USHORT aTimeInterval);
		virtual								~QT_CMoviePlaybackControllerBackgroundChore();
		virtual BOOL 		Do();
	
private:
	QT_CMoviePlaybackController *fMyPlaybackController;
};

//========================================================================================
// CLASS QT_CMoviePlaybackControllerForegroundChore
//========================================================================================

class QT_CMoviePlaybackControllerForegroundChore : public cTimerChore
{
public:
														QT_CMoviePlaybackControllerForegroundChore(
																	QT_CMoviePlaybackController* aPlaybackController, 
																	cPane* aPane,
				  										   	USHORT aTimeInterval);
	virtual									~QT_CMoviePlaybackControllerForegroundChore();
	virtual BOOL 			Do();
	
private:
	QT_CMoviePlaybackController *fMyPlaybackController;
	
};

//========================================================================================
// CLASS QT_CMoviePlaybackControllerEnvelope
//========================================================================================

class QT_CMoviePlaybackControllerEnvelope
{
public:
			typedef signed short AmplitudeValue;
			typedef signed short StepValue;
			 
			// MC action commands
			virtual void 					Play() ;                    
			virtual void 					Stop() ;
			virtual void 					Rewind(TimeRecord *aTime = 0) ;       
			virtual void 					FastForward(TimeRecord *aTime = 0) ; 
			virtual void 					GoTo(TimeRecord *aTime = 0) ;
			
		  virtual void 					EnablePlayEveryFrame() ;
			virtual void 					DisablePlayEveryFrame() ;
			virtual BOOL 					IsPlayEveryFrameEnabled() const ;
			
			virtual void 					EnableBadge() ;
			virtual void 					DisableBadge() ;
			virtual BOOL 					IsBadgeEnabled() const ;
			
			virtual void 					EnableKeys() ;
			virtual void 					DisableKeys() ;
			virtual BOOL 					AreKeysEnabled() const ;
			
			virtual void 					EnableLooping() ;
			virtual void 					DisableLooping() ;
			virtual BOOL 					IsLoopingEnabled() const ;
			
			virtual void 					EnablePalindromeLooping() ;
			virtual void 					DisablePalindromeLooping() ;
			virtual BOOL 					IsPalindromeLoopingEnabled() const ;
			
			virtual void 					EnablePlaySelection() ;
			virtual void 					DisablePlaySelection() ;
			virtual BOOL 					IsPlaySelectionEnabled() const ;
			
			virtual void 					SetVolume(AmplitudeValue aVolume = 0) ;
			virtual AmplitudeValue GetVolume() const ;
			
			virtual void 					SetPlayRate(TimeValue aRate = 0) ;
			virtual TimeValue 			GetPlayRate() const ;
			
			virtual void 					SetStepValue(StepValue aStepValue = 1) ;
			virtual StepValue 			GetStepValue() const ;
			
			virtual void 					SetSelectionStartTime(TimeRecord *aStartTime = 0) ;
			virtual TimeRecord *		GetSelectionStartTime() const ;

			virtual void  					SetSelectionDuration(TimeRecord *aDuration = 0) ;
			virtual TimeRecord *		GetSelectionDuration() const ;
			
			virtual void 					SetPosterTime(TimeRecord *aTime = 0) ;
			virtual TimeRecord *		GetPosterTime() const ;

protected:

			// constructors/destructors
															QT_CMoviePlaybackControllerEnvelope();
			virtual 								~QT_CMoviePlaybackControllerEnvelope();

		  unsigned 							AttachView(QT_CMovieScreenPlaybackView *);
		  unsigned 							AttachView(QT_CMovieControlBarPlaybackView *);

		  unsigned								DetachView(QT_CMovieScreenPlaybackView *);
			unsigned								DetachView(QT_CMovieControlBarPlaybackView *);
			
			unsigned	char  				fAttachedControlBarViewCount;		
			unsigned char					fAttachedScreenViewCount;
};


//========================================================================================
// CLASS QT_CMoviePlaybackController
//========================================================================================

class QT_CMoviePlaybackController : public QT_CControllerComponent, public QT_CMoviePlaybackControllerEnvelope
{
public:
		  // constructors/destructors
															QT_CMoviePlaybackController(cView *aView);
															QT_CMoviePlaybackController(cView *aView, QT_CMovie *aMovie); 															
															QT_CMoviePlaybackController(QT_CMoviePlaybackController &aPlaybackController);
			virtual 								~QT_CMoviePlaybackController();

			// operators
															operator MovieController() const;
	
			void 										SetMovie(QT_CMovie *aMovie);
			QT_CMovie * 						GetMovie() const;
			
protected:

			// generic component interface
			void	 									OpenComponent(cView *aView, ComponentType aType = kPlaybackControllerComponent);  
			void  									CloseComponent();  // override of cComponent::CloseComponent()

			// interface to the chore processing
			void										OpenForegroundChore(cView *aView);
			void										CloseForegroundChore();
			
			void										OpenBackgroundChore(cView *aView);
			void										CloseBackgroundChore();

			// interface to the movie 
			void										OpenMovie();
			void										CloseMovie();
	
			QT_CMovie				 								 						* fMyMovie;
			
			QT_CMoviePlaybackControllerForegroundChore 	* fMyForegroundChore;
			QT_CMoviePlaybackControllerBackgroundChore 	* fMyBackgroundChore;
			
			BOOL							fDontCloseMovie;
	
//	SETCLASSNAME(QT_CMoviePlaybackController);
};

//========================================================================================
//	INLINE METHODS
//========================================================================================

inline void QT_CMoviePlaybackController::SetMovie(QT_CMovie *aMovie)
{
	fMyMovie = aMovie;
}

inline QT_CMovie * QT_CMoviePlaybackController::GetMovie() const
{
	return fMyMovie;
}

inline QT_CMoviePlaybackController::operator MovieController() const
{
	return MovieController(fMyComponent);
}

inline void QT_CMoviePlaybackController::CloseComponent()
{
#ifdef DEBUG
	gErrorName = "CloseComponent";
#endif

#ifdef BUILD_MAC
	::CloseComponent( *this );
#endif
#ifdef BUILD_WIN
	::DisposeMovieController( *this );
#endif
}
inline void QT_CMoviePlaybackController::OpenBackgroundChore(cView *aView)
{
	fMyBackgroundChore = new QT_CMoviePlaybackControllerBackgroundChore(this, (cPane *)aView, 1000);
}

inline void QT_CMoviePlaybackController::CloseBackgroundChore()
{
	if(fMyBackgroundChore)
		delete fMyBackgroundChore;
}

inline void QT_CMoviePlaybackController::OpenForegroundChore(cView *aView)
{
	fMyForegroundChore = new QT_CMoviePlaybackControllerForegroundChore(this, (cPane *)aView, 50);
}

inline void QT_CMoviePlaybackController::CloseForegroundChore()
{
	if(fMyForegroundChore)
		delete fMyForegroundChore;
}
inline void QT_CMoviePlaybackController::CloseMovie()
{
	if( fMyMovie )
		delete fMyMovie;
}

inline unsigned QT_CMoviePlaybackControllerEnvelope::AttachView(QT_CMovieScreenPlaybackView *)
{
	return ++fAttachedScreenViewCount;
}

inline unsigned QT_CMoviePlaybackControllerEnvelope::AttachView(QT_CMovieControlBarPlaybackView *)
{	
	return ++fAttachedControlBarViewCount;
}

inline unsigned QT_CMoviePlaybackControllerEnvelope::DetachView(QT_CMovieScreenPlaybackView *)
{
	return --fAttachedScreenViewCount;
}

inline unsigned QT_CMoviePlaybackControllerEnvelope::DetachView(QT_CMovieControlBarPlaybackView *)
{
	return --fAttachedControlBarViewCount;
}

#endif // QTCONTRL_H
