/*
	AD GRAPHICS MODULE
	MODULE ROUTING/HANDLING ROUTINES

     *** DO NOT MODIFY THIS SOURCE CODE!!! IT IS FOR VIEWING ONLY.  ***
     *** CHANGE THE MODULE-SPECIFIC .C FILE FOR EACH MODULE         ***

	BY BILL STEWART

	UPDATED FOR AFTER DARK 2.0 FEB 18/92
*/

#include "module.h"
#include <string.h>
#include <time.h>

/*
*   SYSTEM GLOBALS
*/

HANDLE  hLibInst;   // HANDLE TO THIS MODULE (DLL)

HDC  hDC;           // MODULE DISPLAY CONTEXT

HANDLE  hSystem;    //  HANDLE TO AD SYSTEM PARAM BLOCK
LPSYSTEM lpSystem;  //  POINTER TO AD SYSTEM PARAM BLOCK
LPMODULE lpModule;  //  POINTER TO MODULE'S PARAMETERS

/*
*    SYSTEM ROUTINES
		 - LibMain
		 - WEP

		 - Module
*/

/*
*    ENTRY CODE FOR LIBRARY
*/
int FAR PASCAL LibMain (hInstance, wDataSeg, wHeapSize, lpCmdLine)
HANDLE  hInstance;
WORD    wDataSeg, wHeapSize;
LPSTR   lpCmdLine;
{
	 if (wHeapSize == 0)
		return 0;

	 hLibInst = hInstance;
		return 1;
}

/*
*   WINDOWS EXIT PROC FOR DLL
*/
int FAR PASCAL WEP (bSystemExit)
int  bSystemExit;
{
	return (1);
}


/*
*      MASTER ROUTER FOR MODULE
*/
int FAR PASCAL  Module (iMessage, hDrawDC, hADSystem)
int     iMessage;
HDC     hDrawDC;
HANDLE  hADSystem;
{
	static  long  lTime;
	int   iError;
 	int   i;

	hDC = hDrawDC;
	hSystem = hADSystem;

	if ((lpSystem = (LPSYSTEM) GlobalLock (hSystem)) != NULL)
	{
		if ((lpModule = (LPMODULE) GlobalLock (lpSystem->hModuleInfo)) != NULL)
		{
			switch (iMessage)
			{
				case PREINITIALIZE:
					iError = DoPreInitialize ();
					break;

				case INITIALIZE:
					// SEED RANDOM GENERATOR RANDOMLY
					time (&lTime);
					srand ((unsigned)lTime);

					iError = DoInitialize ();
					break;

				case BLANK:
					iError = DoBlank ();
					break;

				case DRAWFRAME:
					iError = DoDrawFrame ();
					break;

				case CLOSE:
					iError = DoClose ();
					break;

				case MODULESELECTED:
					lpModule->hModule = hLibInst;
					for (i=0; i<4; i++)
						lpModule->iControlID[i] = i+1;

					iError = DoSelected ();
					break;

				case ABOUT:
					iError = DoAbout ();
					break;

				case BUTTONMESSAGE:
				case BUTTONMESSAGE+1:
				case BUTTONMESSAGE+2:
				case BUTTONMESSAGE+3:
					iError = DoButtonMessage (iMessage-BUTTONMESSAGE);
					break;

				default:
					break;
			}
			GlobalUnlock (lpSystem->hModuleInfo);
		}
		GlobalUnlock (hSystem);
	}
	return iError;
}
