#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <fcntl.h>
#include "wdcapi.h"
#include "sql.h"
#include "sqlext.h"
#include "message.h"

#define BLOCKSIZE   0x00007f00
#define SQL_NoMoreData	    -1
#define SQL_StillExecuting  -2
#define SQL_OutOfMemory	    -3
#define SQL_SynchronizeError	-4
#define SQL_CAPIError	    -5

/************************************************************************
*
*	Define Structure
*
************************************************************************/
#if 0
typedef struct __WCB {
    int cArgs;
    WDOPR    woprReturn;
    WDOPR    woprArgs[MaxArgs];
}WCB;
#endif

struct _SQLERROR {
	UCHAR				sql_state[7];
	SDWORD				N_code;
	UCHAR				error_msg[257];
	struct _SQLERROR	*next;
};
typedef struct _SQLERROR SQLERROR;

typedef struct _DBCOL {
    LPSTR   item;
    struct _DBCOL * next;
} DBCOL;

#ifndef HGLOBAL
#define HGLOBAL HANDLE
#endif
#ifndef HINSTANCE
#define HINSTANCE HANDLE
#endif

typedef struct _DBROW {
    HGLOBAL hGlobal;
    SWORD   offset;
//    DBCOL * lpCol;
    struct _DBROW * next;
} DBROW;

typedef struct _DBLIST {
    SWORD   nrows;
    SWORD   ncols;
    HGLOBAL hCurrLock;
    SWORD   currOffset;
    LPSTR   lpCurrLock;
    DBROW * lpRow;
} DBLIST;

struct _ODBCHNDL {
	HDBC				hdbc;
	HSTMT				hstmt;
	SWORD				connect_id;
	SWORD				synchronize_flag;
	LPSTR				lpSynBuf;
	LPSTR				lpSynPtr;
	SWORD				synNum;
	SDWORD				synLength;
	SWORD				j;
	HSTMT				hSynStmt;
	DBLIST				*lpDBList;
	DBCOL				*lpSchemaTable;
	struct _ODBCHNDL	*next;
};
typedef struct _ODBCHNDL ODBCHNDL;

struct _DLLLIST {
	ODBCHNDL			*hODBC;
	HANDLE				hInst;
	SWORD				synFlag;
	UCHAR				error_flag;
	SQLERROR			*sqlerror;
	struct _DLLLIST			*next;
};
typedef struct _DLLLIST DLLLIST;

/************************************************************************
*
*	Subroutine describe
*
************************************************************************/
void		wdFreeAll();
HINSTANCE	wdGetCurrInst();

SWORD		wdAllocHandle(ODBCHNDL **, HDBC);

void		wdFreeError(SQLERROR *);
void		wdSQLError(HENV, HDBC, HSTMT);

void		wdFreeDBList(DBLIST *);
void		wdFreeSchemaTable(DBCOL *);
void		wdFreeSyn(ODBCHNDL *);

DLLLIST *	wdGetVBlock(BOOL);
void		wdMessageBox(SWORD);
LPSTR		wdGetResString(SWORD);
ODBCHNDL *	wdCheckConnect(ODBCHNDL *,SWORD);
SWORD		wdPeekMessage(void);
LPSTR		wdNullString();

SWORD		wdGetDBList(ODBCHNDL *, SWORD, SWORD);
LPSTR		wdGetSpace(DBLIST *, DBROW *, SWORD);

SWORD		wdGetTables(ODBCHNDL *, LPSTR, LPSTR, SWORD, SWORD);
SWORD		wdGetInfo(ODBCHNDL *, UWORD, LPSTR);
SWORD		wdGetSchemaString(DBCOL * *, DBCOL * *, LPSTR);
SWORD		wdDeleteSameName(ODBCHNDL *);
SWORD		wdCheckTypeText(LPSTR);

void		InitWcbFields(WCB far *, short);
void		AddShortField(WCB far *, short, short);
void		AddStringField (WCB far *, LPSTR, short);

/************************************************************************
*
*	Extern Varialbes
*
************************************************************************/
extern	HANDLE		hInst;
extern	DLLLIST		*dll_list;
extern	HENV		henv;
extern	UWORD		driver_completion[4];
extern	SQLERROR	*pFirstError;
extern	SWORD		firstErrorFlag;
extern	UCHAR		szResource[];
extern	SWORD		matchType[];

/* end of file */
