/*************************************************************************
*
*	wdobdc.c	    6/10/93
*
*	This file is about main routine for WinWord ODBC
*
*************************************************************************/

#include "wdodbc.h"
#include "wdcmds.h"
#include "wdfid.h"

HANDLE		hInst;
DLLLIST		*dll_list;
HENV		henv;
SQLERROR	*pFirstError;
SWORD		firstErrorFlag;
UCHAR		szResource[256];
SWORD		matchType[TOTALTYPE] = {SQL_BIGINT,SQL_BINARY,SQL_BIT,
    SQL_CHAR,SQL_DATE,SQL_DECIMAL,SQL_DOUBLE,SQL_FLOAT,SQL_INTEGER,
    SQL_LONGVARBINARY,SQL_LONGVARCHAR,SQL_NUMERIC,SQL_REAL,SQL_SMALLINT,
    SQL_TIME,SQL_TIMESTAMP,SQL_TINYINT,SQL_VARBINARY,SQL_VARCHAR};

/******************************************************************
*
*	LibMain -- entrice of dll
*
*******************************************************************/
SWORD FAR PASCAL LibMain(HANDLE h, SWORD w, SWORD c, LPSTR l)
{

    if (c != 0)
	UnlockData(0);
//    MessageBox(NULL,"LibMain","TEST",MB_OK);
    hInst = h;
    pFirstError = NULL;
    dll_list = NULL;
    henv = NULL;
    return 1;
}/* LibMain() */

/******************************************************************
*
*	WEP -- DLL needs
*
*******************************************************************/
SWORD FAR PASCAL WEP (SWORD b)
{
	return 1;
} /* WEP() */

/*
* wdAutoOpen -- called when user load this WLL to WinWord
*/
void FAR PASCAL wdAutoOpen(short docID)
{
//    WCB wcb;

//    MessageBox(NULL,"AutoOpen","TEST",MB_OK);
//    wsprintf(szResource, "docID=%d", docID);
//    MessageBox(NULL,szResource,"TEST",MB_OK);
    // Register sql_error in T3
//    InitWcbFields(&wcb, TypeShort);
//    AddShortField(&wcb, docID, elkNil);
//    AddStringField(&wcb, "sql_error", elkNil);
//    WordCAPI(fciMstCAPIAddCommand, 0, wcb.cArgs, wcb.woprArgs, lpwoprNil);
//    InitWcbFields(&wcb, TypeShort);
//    AddShortField(&wcb, docID, elkNil);
//    AddStringField(&wcb, "sql_open", elkNil);
//    WordCAPI(fciMstCAPIAddCommand, 0, wcb.cArgs, wcb.woprArgs, lpwoprNil);
}

/*
* wdAutoOpen -- called when user load this WLL to WinWord
*/
void FAR PASCAL wdAutoRemove()
{
//    MessageBox(NULL,"AutoRemove","TEST",MB_OK);
    wdFreeAll();
}

void wdFreeAll()
{
    HINSTANCE	hCurrInst;
    ODBCHNDL	*hODBC, *hTemp;
    DLLLIST	*pCurrItem, *pPrevItem;

    hCurrInst = wdGetCurrInst();
    pCurrItem = dll_list;
    pPrevItem = NULL;

    while(pCurrItem)
    {
	if(pCurrItem->hInst==hCurrInst)
	    break;
	pPrevItem = pCurrItem;
	pCurrItem = pCurrItem -> next;
    }
    if(pCurrItem == NULL)
	return;
    if(pPrevItem)
	pPrevItem->next = pCurrItem -> next;
    else
	dll_list = pCurrItem -> next;
    hODBC = pCurrItem -> hODBC;
    while(hODBC)
    {
	hTemp = hODBC->next;
	if(hODBC->hstmt)
	    SQLFreeStmt(hODBC->hstmt, SQL_DROP);
	wdFreeSyn(hODBC);
	SQLDisconnect(hODBC->hdbc);
	SQLFreeConnect(hODBC->hdbc);
	if(hODBC->lpDBList)
	    wdFreeDBList(hODBC->lpDBList);
	free((PTR)hODBC);
	hODBC = hTemp;
    }

    wdFreeError(pCurrItem->sqlerror);
    free((PTR)pCurrItem);

    if(dll_list == NULL)
	SQLFreeEnv(henv);

    return;
}

HINSTANCE   wdGetCurrInst()
{
//    HWND hWnd;
    WCB wcb;

    InitWcbFields(&wcb, TypeShort);
    wdCommandDispatch(wdGetInst, 0, wcb.cArgs, wcb.wdoprArgs, &(wcb.wdoprReturn));
//    WordCAPI(0x817f, 0, wcb.cArgs, wcb.woprArgs, &(wcb.woprReturn));
    return(wcb.wdoprReturn.Short);
//    wsprintf(szResource,"rinst=%d",wcb.woprReturn.Short);
//    MessageBox(NULL,szResource,"TEST",MB_OK);

    /* we may change it after the WORD CPI document ready */
//    hWnd = GetActiveWindow();
//    wsprintf(szResource,"winst=%d",GetWindowWord(hWnd, GWW_HINSTANCE));
//    MessageBox(NULL,szResource,"TEST",MB_OK);
//    if(hWnd)
//	return(GetWindowWord(hWnd, GWW_HINSTANCE));
//    return(NULL);
}

/*************************************************************************
*
*	sql_synchronize -- the entrance of SQLSynchronize function
*
*************************************************************************/
SWORD FAR PASCAL SQLSynchronize(SWORD flag)
{
    ODBCHNDL	*htemp;
    DLLLIST	*dlllist_temp;

//    MessageBox(NULL,"SQLSynchronize","TEST",MB_OK);
    dlllist_temp = wdGetVBlock(FALSE);
    if (dlllist_temp == NULL)
	if(henv)
	    return(SQL_OutOfMemory);
	else
	    return(0);

    if(flag)
    {
	if(dlllist_temp->synFlag==0)
	    return(1);
	for(htemp=dlllist_temp->hODBC; htemp; htemp=htemp->next)
	    if(htemp->synchronize_flag)
		return(SQL_SynchronizeError);
    }
    else
	dlllist_temp->synFlag = 1;
    return(1);
}
