#include <string.h>
#include "wdodbc.h"

static char buffer[256];

void InitWcbFields(WCB far *lpwcb, short retType)
{
	lpwcb->cArgs = 0;
	lpwcb->wdoprReturn.Type = retType;
	if (retType == TypeString)
	{
		lpwcb->wdoprReturn.String = buffer;
		lpwcb->wdoprReturn.BufferSize = 256;
	}
}

void AddShortField(lpwcb, ShortVal, FieldId)
WCB far *lpwcb;
short ShortVal;
short FieldId;
{
	short cArgs;

	cArgs = lpwcb->cArgs;
	lpwcb->wdoprArgs[cArgs].Short	 = ShortVal;
	lpwcb->wdoprArgs[cArgs].Type	  = TypeShort;
	lpwcb->wdoprArgs[cArgs].ForInput  = 1;
	lpwcb->wdoprArgs[cArgs].ForOutput = 0;
	lpwcb->wdoprArgs[cArgs].FieldId	 = FieldId;
	lpwcb->wdoprArgs[cArgs].BufferSize = 0;
	lpwcb->cArgs++;
}

//void AddLongField(lpwcb, LongVal, FieldId)
//WCB far *lpwcb;
//long	LongVal;
//short FieldId;
//{
//	short cArgs;
//
//	cArgs = lpwcb->cArgs;
//	lpwcb->woprArgs[cArgs].Long	 = LongVal;
//	lpwcb->woprArgs[cArgs].Type	 = TypeLong;
//	lpwcb->woprArgs[cArgs].ForInput  = 1;
//	lpwcb->woprArgs[cArgs].ForOutput = 0;
//	lpwcb->woprArgs[cArgs].FieldId	 = FieldId;
//	lpwcb->woprArgs[cArgs].BufferSize = 0;
//	lpwcb->cArgs++;
//}
//
//void AddNumField (lpwcb, DoubleVal, FieldId)
//WCB far *lpwcb;
//double DoubleVal;
//short FieldId;
//{
//	short cArgs;
//
//	cArgs = lpwcb->cArgs;
//	lpwcb->woprArgs[cArgs].Double	 = DoubleVal;
//	lpwcb->woprArgs[cArgs].Type	 = TypeDouble;
//	lpwcb->woprArgs[cArgs].ForInput  = 1;
//	lpwcb->woprArgs[cArgs].ForOutput = 0;
//	lpwcb->woprArgs[cArgs].FieldId	 = FieldId;
//	lpwcb->woprArgs[cArgs].BufferSize = 0;
//	lpwcb->cArgs++;
//}

void AddStringField (lpwcb, lpStr, FieldId)
WCB far *lpwcb;
LPSTR lpStr;
short FieldId;
{
	short cArgs;

	cArgs = lpwcb->cArgs;
	lpwcb->wdoprArgs[cArgs].String	 = lpStr;
	lpwcb->wdoprArgs[cArgs].Type	 = TypeString;
	lpwcb->wdoprArgs[cArgs].ForInput  = 1;
	lpwcb->wdoprArgs[cArgs].ForOutput = 0;
	lpwcb->wdoprArgs[cArgs].FieldId	 = FieldId;
	lpwcb->wdoprArgs[cArgs].BufferSize = lstrlen(lpStr);
	lpwcb->cArgs++;
}
