/*************************************************************************
*
*	retrieve.c		6/10/93
*
*	This file is about SQLRetrieve for WinWord ODBC
*
*************************************************************************/

#include "wdodbc.h"
#include "wdcmds.h"
#include "wdfid.h"

/*************************************************************************
*
*	sql_retrieve_rows -- the entrance of SQLRetrieveRows function
*
*************************************************************************/
SWORD FAR PASCAL SQLRetrieveRows(SWORD connection_num)
{
    ODBCHNDL	*hConnect;
    DLLLIST		*dlllist_temp;

//    MessageBox(NULL,"SQLRetrieveRows","TEST",MB_OK);
//    wsprintf(szResource,"connection_nunm=%d",connection_num);
//    MessageBox(NULL,szResource,"TEST",MB_OK);
    dlllist_temp = wdGetVBlock(TRUE);
    if (dlllist_temp == NULL)
	if(henv)
	    return(SQL_OutOfMemory);
	else
	    return(0);

    hConnect = wdCheckConnect(dlllist_temp->hODBC, connection_num);
    if(hConnect == NULL)
	return(SQL_NoMoreData);
    if(hConnect->synchronize_flag)
	return(SQL_SynchronizeError);

    if(hConnect->lpDBList)
	return(hConnect->lpDBList->nrows);
    return(SQL_NoMoreData);
}

/*************************************************************************
*
*	sql_retrieve_columns -- the entrance of SQLRetrieveColumns function
*
*************************************************************************/
SWORD FAR PASCAL SQLRetrieveColumns(SWORD connection_num)
{
    ODBCHNDL	*hConnect;
    DLLLIST		*dlllist_temp;

//    MessageBox(NULL,"SQLRetrieveColumns","TEST",MB_OK);
//    wsprintf(szResource,"connection_nunm=%d",connection_num);
//    MessageBox(NULL,szResource,"TEST",MB_OK);
    dlllist_temp = wdGetVBlock(TRUE);
    if (dlllist_temp == NULL)
	if(henv)
	    return(SQL_OutOfMemory);
	else
	    return(0);

    hConnect = wdCheckConnect(dlllist_temp->hODBC, connection_num);
    if(hConnect == NULL)
	return(SQL_NoMoreData);
    if(hConnect->synchronize_flag)
	return(SQL_SynchronizeError);

    if(hConnect->lpDBList)
	return(hConnect->lpDBList->ncols);
    return(SQL_NoMoreData);
}

/*************************************************************************
*
*	sql_retrieve_item -- the entrance of SQLRetrieveItem function
*
*************************************************************************/
LPSTR PASCAL SQLRetrieveItem$(SWORD connection_num, SWORD col, SWORD row)
{
    ODBCHNDL	*hConnect;
    DLLLIST		*dlllist_temp;
    DBROW		*lpRowCurr;
    LPSTR	lpCurr;

//    MessageBox(NULL,"SQLRetrieveItem","TEST",MB_OK);
//    wsprintf(szResource,"connection_nunm=%d",connection_num);
//    MessageBox(NULL,szResource,"TEST",MB_OK);
//    wsprintf(szResource,"col=%d",col);
//    MessageBox(NULL,szResource,"TEST",MB_OK);
//    wsprintf(szResource,"row=%d",row);
//    MessageBox(NULL,szResource,"TEST",MB_OK);
    if(row<1 || col<1)
	return(wdNullString());
    dlllist_temp = wdGetVBlock(TRUE);
    if (dlllist_temp == NULL) return(wdNullString());

    hConnect = wdCheckConnect(dlllist_temp->hODBC, connection_num);
    if(hConnect == NULL)
	return(wdNullString());
    if(hConnect->synchronize_flag)
	return(wdNullString());

    if(hConnect->lpDBList)
    {
	if(row>hConnect->lpDBList->nrows||col>hConnect->lpDBList->ncols)
	    return(wdNullString());
	lpRowCurr = hConnect->lpDBList->lpRow;
	while(--row)
	{
	    if(lpRowCurr)
		lpRowCurr = lpRowCurr->next;
	    else
		break;
	}
	if(lpRowCurr)
	{
	    if(lpRowCurr->hGlobal==NULL)
		return(wdNullString());
	    if(hConnect->lpDBList->hCurrLock!=lpRowCurr->hGlobal)
	    {
		if(hConnect->lpDBList->hCurrLock)
		    GlobalUnlock(hConnect->lpDBList->hCurrLock);
		lpCurr = GlobalLock(lpRowCurr->hGlobal);
		if(lpCurr==NULL)
		    return(wdNullString());
		hConnect->lpDBList->hCurrLock = lpRowCurr->hGlobal;
		hConnect->lpDBList->lpCurrLock = lpCurr;
	    }
	    else
		lpCurr = hConnect->lpDBList->lpCurrLock;
	    lpCurr+=lpRowCurr->offset;
	    col = *(SWORD *)(lpCurr+(col<<1)-2);
	    if(col==0)
		return(wdNullString());
	    return(lpCurr+col);
	}
    }
    return(wdNullString());
}

/*************************************************************************
*
*	sql_retrieve_flush -- the entrance of SQLRetrieveFlush function
*
*************************************************************************/
SWORD FAR PASCAL SQLRetrieveFlush(SWORD connection_num)
{
    ODBCHNDL	*hConnect;
    DLLLIST		*dlllist_temp;

//    MessageBox(NULL,"SQLRetrieveFlush","TEST",MB_OK);
//    wsprintf(szResource,"connection_num=%d",connection_num);
//    MessageBox(NULL,szResource,"TEST",MB_OK);
    dlllist_temp = wdGetVBlock(TRUE);
    if (dlllist_temp == NULL)
	if(henv)
	    return(SQL_OutOfMemory);
	else
	    return(0);

    hConnect = wdCheckConnect(dlllist_temp->hODBC, connection_num);
    if(hConnect == NULL)
	return(SQL_NoMoreData);
    if(hConnect->synchronize_flag)
	return(SQL_SynchronizeError);
    wdFreeDBList(hConnect->lpDBList);
    hConnect->lpDBList = NULL;
    return(1);
}

/*************************************************************************
*
*	sql_retrieve_to_document -- the entrance of SQLRetrieveDocument function
*
*************************************************************************/
SWORD FAR PASCAL SQLRetrieveToDocument(SWORD connection_num)
{
    ODBCHNDL	*hConnect;
    DLLLIST		*dlllist_temp;
    WCB wcb;
    SWORD   err;
    DBROW		*lpRowCurr;
    LPSTR	lpCurr;
    SWORD   col,row;

//    MessageBox(NULL,"SQLRetrieveToDocument","TEST",MB_OK);
//    wsprintf(szResource,"connection_num=%d",connection_num);
//    MessageBox(NULL,szResource,"TEST",MB_OK);
    dlllist_temp = wdGetVBlock(TRUE);
    if (dlllist_temp == NULL)
	if(henv)
	    return(SQL_OutOfMemory);
	else
	    return(0);

    hConnect = wdCheckConnect(dlllist_temp->hODBC, connection_num);
    if(hConnect == NULL)
	return(SQL_NoMoreData);
    if(hConnect->synchronize_flag)
	return(SQL_SynchronizeError);
    if(hConnect->lpDBList==NULL)
	return(SQL_NoMoreData);

    InitWcbFields(&wcb, TypeShort);
//    AddShortField(&wcb, 0, elkNil);
    AddShortField(&wcb, hConnect->lpDBList->ncols, fidNumColumns);
    AddShortField(&wcb, hConnect->lpDBList->nrows, fidNumRows);
//    AddStringField(&wcb, "Auto", elkNil);
//    AddStringField(&wcb, "0", elkNil);
//    AddStringField(&wcb, "167", elkNil);
    err = wdCommandDispatch(wdTableInsertTable, 2, wcb.cArgs, wcb.wdoprArgs, lpwdoprNil);
    if(err)
	return(SQL_CAPIError);
    for(row=0,lpRowCurr = hConnect->lpDBList->lpRow; row < hConnect->lpDBList->nrows; row++)
    {
	if(!lpRowCurr)
	    break;
	if(lpRowCurr->hGlobal==NULL)
	    break;
	if(hConnect->lpDBList->hCurrLock!=lpRowCurr->hGlobal)
	{
	    if(hConnect->lpDBList->hCurrLock)
		GlobalUnlock(hConnect->lpDBList->hCurrLock);
	    lpCurr = GlobalLock(lpRowCurr->hGlobal);
	    if(lpCurr==NULL)
		return(SQL_OutOfMemory);
	    hConnect->lpDBList->hCurrLock = lpRowCurr->hGlobal;
	    hConnect->lpDBList->lpCurrLock = lpCurr;
	}
	lpCurr=hConnect->lpDBList->lpCurrLock + lpRowCurr->offset;
	for(col=0; col < hConnect->lpDBList->ncols; col++)
	{
	    err = *(SWORD *)(lpCurr+(col<<1));
	    if(err == 0)
		break;
	    InitWcbFields(&wcb, TypeShort);
	    AddStringField(&wcb, lpCurr+err, elkNil);
	    err = wdCommandDispatch(wdInsert, 0, wcb.cArgs, wcb.wdoprArgs, lpwdoprNil);
	    if(err)
		return(SQL_CAPIError);
	    if(row!=hConnect->lpDBList->nrows-1||col!=hConnect->lpDBList->ncols-1)
	    {
		InitWcbFields(&wcb, TypeShort);
		err = wdCommandDispatch(wdNextCell, 0, wcb.cArgs, wcb.wdoprArgs, lpwdoprNil);
		if(err)
		    return(SQL_CAPIError);
	    }
	}
	lpRowCurr = lpRowCurr->next;
    }

    return(1);
}
