/*************************************************************************
*
*	exequery.c		6/10/93
*
*	This file is about SQLExecQuery for WinWord ODBC
*
*************************************************************************/

#include "wdodbc.h"

/*************************************************************************
*
*	sql_execquery -- the entrance of SQLExecQuery function
*
*************************************************************************/
SWORD FAR PASCAL SQLExecQuery(SWORD connection_num, LPSTR query_text)
{
    ODBCHNDL	*hConnect;
//    SDWORD		row;
    RETCODE		retcode;
    DLLLIST		*dlllist_temp;

//    MessageBox(NULL,"SQLExecQuery","TEST",MB_OK);
//    wsprintf(szResource,"connection_nunm=%d",connection_num);
//    MessageBox(NULL,szResource,"TEST",MB_OK);
//    MessageBox(NULL, query_text, "TEST", MB_OK);
    dlllist_temp = wdGetVBlock(TRUE);
    if (dlllist_temp == NULL)
	if(henv)
	    return(SQL_OutOfMemory);
	else
	    return(0);

    hConnect = wdCheckConnect(dlllist_temp->hODBC, connection_num);
    if(hConnect == NULL)
	return(SQL_NoMoreData);

    switch(hConnect->synchronize_flag)
    {
	case 0 : break;
	case 1 : goto syn1;
	case 2 : goto syn2;
	case 3 : goto syn3;
	case 4 :
	case 5 :
		 goto syn4;
	default : return(SQL_SynchronizeError);
    }
    if(hConnect->lpDBList)
    {
	wdFreeDBList(hConnect->lpDBList);
	hConnect->lpDBList = NULL;
    }

    if (hConnect->hstmt == 0) {
	if (SQLAllocStmt(hConnect->hdbc, &(hConnect->hstmt)) != SQL_SUCCESS) {
	    wdSQLError(henv, hConnect->hdbc, NULL);
	    return(0);
	}
    } else {
	if (SQLFreeStmt(hConnect->hstmt, SQL_CLOSE) != SQL_SUCCESS) {
	    wdSQLError(henv, hConnect->hdbc, hConnect->hstmt);
	    return(0);
	}
    }
    if(hConnect->lpSynBuf=malloc(_fstrlen(query_text)+1))
	_fstrcpy(hConnect->lpSynBuf, query_text);
    else
    {
	wdMessageBox(OUTOFMEMORY);
	return(SQL_OutOfMemory);
    }

syn1:
    while ((retcode = SQLPrepare(hConnect->hstmt, hConnect->lpSynBuf, SQL_NTS)) ==
	SQL_STILL_EXECUTING) {
	/* Do some PeekMessage */
	if(dlllist_temp->synFlag)
	{
	    hConnect->synchronize_flag=1;
	    return(SQL_StillExecuting);
	}
	if(wdPeekMessage())
	{
	    return(0);
	}
    }
    free(hConnect->lpSynBuf);
    hConnect->synchronize_flag=0;

    if (retcode != SQL_SUCCESS) {
	wdSQLError(henv, hConnect->hdbc, hConnect->hstmt);
	return(0);
    }

syn2:
    while ((retcode = SQLExecute(hConnect->hstmt)) == SQL_STILL_EXECUTING) {
	if(dlllist_temp->synFlag)
	{
	    hConnect->synchronize_flag=2;
	    hConnect->lpSynBuf = NULL;
	    return(SQL_StillExecuting);
	}
	/* Do some PeekMessage */
	if(wdPeekMessage())
	{
	    hConnect->synchronize_flag=0;
	    return(0);
	}
    }

    hConnect->synchronize_flag=0;
    if (retcode != SQL_SUCCESS) {
	wdSQLError(henv, hConnect->hdbc, hConnect->hstmt);
	return(0);
    }
syn3:
    while ((retcode = SQLNumResultCols(hConnect->hstmt, &(hConnect->synNum))) ==
	SQL_STILL_EXECUTING) {
	if(dlllist_temp->synFlag)
	{
	    hConnect->synchronize_flag=3;
	    hConnect->lpSynBuf = NULL;
	    return(SQL_StillExecuting);
	}
	/* Do some PeekMessage */
	if(wdPeekMessage())
	{
	    hConnect->synchronize_flag=0;
	    return(0);
	}
    }

    hConnect->synchronize_flag=0;
    if (retcode != SQL_SUCCESS) {
	wdSQLError(henv, hConnect->hdbc, hConnect->hstmt);
	return(0);
    }

    if (hConnect->synNum>0) {
syn4:
	if((retcode=wdGetDBList(hConnect,hConnect->synNum,dlllist_temp->synFlag))==0)
	    return(0);
	if(retcode<0)
	    return(retcode);
	return(hConnect->lpDBList->ncols);
    }
    return(1);
//    if (SQLRowCount(hConnect->hstmt, &row) != SQL_SUCCESS) {
//	wdSQLError(henv, hConnect->hdbc, hConnect->hstmt);
//	return(0);
//    }

//    return((SWORD)row);
}

/* return 0 means error, return 1 means OK */
SWORD wdGetDBList(ODBCHNDL    *hConnect, SWORD col, SWORD synFlag)
{
    RETCODE		retcode;
    DBROW   *lpRowCurr;
    LPSTR   lpCurr;
    int     len;

    switch(hConnect->synchronize_flag)
    {
	case 0 : break;
	case 4 : goto syn4;
	case 5 :
		 goto syn5;
	default : return(SQL_SynchronizeError);
    }
    if(hConnect->lpDBList=(DBLIST *)malloc(sizeof(DBLIST)))
	hConnect->lpDBList->ncols = col;
    else
    {
	wdMessageBox(OUTOFMEMORY);
	return(SQL_OutOfMemory);
    }
    hConnect->lpDBList->nrows = 0;
    hConnect->lpDBList->lpRow = NULL;
    hConnect->lpDBList->hCurrLock = NULL;
    hConnect->lpDBList->currOffset = 0;
    if(hConnect->lpSynBuf = malloc(256))
	hConnect->lpSynPtr = NULL;
    else
    {
	wdMessageBox(OUTOFMEMORY);
	return(SQL_OutOfMemory);
    }

    while(TRUE)
    {
syn4:
	while((retcode=SQLFetch(hConnect->hstmt))==SQL_STILL_EXECUTING)
	{
	    if(synFlag)
	    {
		hConnect->synchronize_flag=4;
		return(SQL_StillExecuting);
	    }
	    if(wdPeekMessage())
	    {
		hConnect->synchronize_flag=0;
		free(hConnect->lpSynBuf);
		return(0);
	    }
	}
	hConnect->synchronize_flag=0;
	if(retcode==SQL_NO_DATA_FOUND)
	{
	    free(hConnect->lpSynBuf);
	    if(hConnect->lpDBList->hCurrLock)
	    {
		GlobalUnlock(hConnect->lpDBList->hCurrLock);
		hConnect->lpDBList->hCurrLock = NULL;
	    }
	    return(1);
	}
	if(retcode != SQL_SUCCESS && retcode != SQL_SUCCESS_WITH_INFO)
	{
	    free(hConnect->lpSynBuf);
	    wdSQLError(henv, hConnect->hdbc, hConnect->hstmt);
	    return(0);
	}
	if(lpRowCurr = (DBROW *)malloc(sizeof(DBROW)))
	    lpRowCurr->hGlobal = hConnect->lpDBList->hCurrLock;
	else
	{
	    free(hConnect->lpSynBuf);
	    wdMessageBox(OUTOFMEMORY);
	    return(SQL_OutOfMemory);
	}
	lpRowCurr->next = NULL;
	lpRowCurr->offset = -1;
	if(hConnect->lpSynPtr)
	    ((DBROW *)(hConnect->lpSynPtr)) -> next = lpRowCurr;
	else
	    hConnect->lpDBList->lpRow = lpRowCurr;
	hConnect->lpSynPtr = (LPSTR)lpRowCurr;
	lpCurr = wdGetSpace(hConnect->lpDBList, lpRowCurr, (hConnect->lpDBList->ncols)<<1);
	if(lpCurr==NULL)
	{
	    free(hConnect->lpSynBuf);
	    return(SQL_OutOfMemory);
	}
	_fmemset(lpCurr, 0, (hConnect->lpDBList->ncols)<<1);
	hConnect->lpDBList->nrows ++;
	for(hConnect->synNum=1; hConnect->synNum<=hConnect->lpDBList->ncols; hConnect->synNum++)
	{
syn5:
	    while((retcode=SQLGetData(hConnect->hstmt, hConnect->synNum, (SWORD)SQL_C_CHAR, hConnect->lpSynBuf, (SDWORD)256, &(hConnect->synLength)))==SQL_STILL_EXECUTING)
	    {
		if(synFlag)
		{
		    hConnect->synchronize_flag=5;
		    return(SQL_StillExecuting);
		}
		if(wdPeekMessage())
		{
		    hConnect->synchronize_flag=0;
		    free(hConnect->lpSynBuf);
		    return(0);
		}
	    }
	    hConnect->synchronize_flag=0;
	    if(retcode == SQL_NO_DATA_FOUND)
		break;
	    if(retcode != SQL_SUCCESS && retcode != SQL_SUCCESS_WITH_INFO)
	    {
		free(hConnect->lpSynBuf);
		wdSQLError(henv, hConnect->hdbc, hConnect->hstmt);
		return(0);
	    }
	    len = _fstrlen(hConnect->lpSynBuf)+1;
	    lpCurr = wdGetSpace(hConnect->lpDBList, (DBROW *)(hConnect->lpSynPtr), len);
	    if(lpCurr==NULL)
	    {
		free(hConnect->lpSynBuf);
		return(SQL_OutOfMemory);
	    }
	    _fmemcpy(lpCurr, hConnect->lpSynBuf, len);
	    *(SWORD *)(hConnect->lpDBList->lpCurrLock+((DBROW *)(hConnect->lpSynPtr))->offset+((hConnect->synNum)<<1)-2) = hConnect->lpDBList->currOffset-len-((DBROW *)(hConnect->lpSynPtr))->offset;
	}
    }
}

LPSTR wdGetSpace(DBLIST *lpDBList, DBROW *lpRow, SWORD size)
{
    LPSTR   lpCurr;

    if(lpDBList->hCurrLock)
    {
	if(lpDBList->currOffset+(long)size <= BLOCKSIZE)
	{
	    if(lpRow->offset<0)
	    {
		lpRow->hGlobal = lpDBList->hCurrLock;
		lpRow->offset = lpDBList->currOffset;
	    }
	    lpCurr = lpDBList->lpCurrLock+lpDBList->currOffset;
	    lpDBList->currOffset += size;
	    return(lpCurr);
	}
    }
    if(lpRow->hGlobal = GlobalAlloc(GMEM_MOVEABLE,BLOCKSIZE))
	lpCurr = GlobalLock(lpRow->hGlobal);
    else
    {
	wdMessageBox(OUTOFMEMORY);
	return(NULL);
    }
    if(lpDBList->hCurrLock)
    {
	if(lpRow->offset>=0)
	{
	    size += lpDBList->currOffset - lpRow->offset;
	    _fmemcpy(lpCurr,lpDBList->lpCurrLock+lpRow->offset,lpDBList->currOffset - lpRow->offset);
	}
	GlobalUnlock(lpDBList->hCurrLock);
    }
    lpRow -> offset = 0;
    lpDBList->hCurrLock = lpRow -> hGlobal;
    lpDBList->lpCurrLock = lpCurr;
    lpDBList -> currOffset = size;
    return(lpCurr);
}
