/*-----------------------------------------------------------------------

    EXAMP.C
    C-API example

------------------------------------------------------------------------*/

#include <windows.h> 
#include <stdlib.h>
#include "wdcapi.h"       
#include "wdcmds.h"       
#include "wdfid.h"       
#include "capilib.h"       

#define ARRAYSIZE 15

uchar   vszBuffer[1024];
HANDLE  vhInst;

// This main entry point is automatically called when the WLL is loaded.
// 
short FAR PASCAL wdAutoOpen( short DocID )
{
    int err;
    
    // Register function MyTable   
    if ((err = CAPIRegister( DocID, "MyTable")) != 0)
    {
        itoa( err, vszBuffer, 10 );
        MessageBox( NULL, vszBuffer, "CAPIRegister Error", MB_OK );
        return 0;
    } 

    // Register function StringArray   
    if ((err = CAPIRegister( DocID, "StringArray")) != 0)
    {
        itoa( err, vszBuffer, 10 );
        MessageBox( NULL, vszBuffer, "CAPIRegister Error", MB_OK );
        return 0;
    } 
    
    // Register function DoubleArray   
    if ((err = CAPIRegister( DocID, "DoubleArray")) != 0)
    {
        itoa( err, vszBuffer, 10 );
        MessageBox( NULL, vszBuffer, "CAPIRegister Error", MB_OK );
        return 0;
    }
    
    // Add a custom toolbar             
    if ((err = CAPIAddToolbar( DocID, "MyToolbar" )) != 0)
    {
        itoa( err, vszBuffer, 10 );
        MessageBox( NULL, vszBuffer, "CAPIAddToolbar Error", MB_OK );
        return 0;
    }             
    
    // Add a button to the first position of the custom toolbar
    if ((err = CAPIAddButton( DocID, "MyToolbar", 1, "MyTable", "My Table" )) != 0)
    {
        itoa( err, vszBuffer, 10 );
        MessageBox( NULL, vszBuffer, "CAPIAddButton Error", MB_OK );
        return 0;
    }             
    
    // Add a menu item  
    if ((err = CAPIAddMenuItem( DocID, "File", "StringArray", "String Array Test", -1, 0)) != 0)
    {
        itoa( err, vszBuffer, 10 );
        MessageBox( NULL, vszBuffer, "CAPIAddMenuItem Error", MB_OK );
        return 0;
    } 
    
    // Assign the DoubleArray function to shortcut key... Ctrl-Shift-D
    if ((err = CAPIAddKey( DocID, 256+512+68, "DoubleArray" )) != 0)
    {
        itoa( err, vszBuffer, 10 );
        MessageBox( NULL, vszBuffer, "CAPIAddKey Error", MB_OK );
        return 0;
    } 

    // Success
    return 1;
}


// This function is called when the WLL unloadeds, 
//
void FAR PASCAL wdAutoRemove( void )
{
    WCB wcb;
    
    InitWCB( &wcb, 0, NULL, 0 );
    AddStringParam( &wcb, "The WLL is about to be unloaded" );
    AddStringParam( &wcb, "wdAutoRemove" );
    wdCommandDispatch( wdMsgBox, 0, wcb.cArgs, wcb.wdoprArgs, lpwdoprNil );
}      
      
// This function inserts a new table in Word and labels the cells     
//
void FAR PASCAL MyTable( void )
{
    WCB     wcb;
    short   err; 
    short   cCol, cRow;
    short   nCols, nRows;
    static  uchar szCols[4], szRows[4];
    uchar   szBuffer[80]; 
     
    // Insert a table            
    InitWCB( &wcb, TypeShort, NULL, 0 );
    AddStringDlgField( &wcb, szCols, fidNumColumns, OUTPUT, 4 );
    AddStringDlgField( &wcb, szRows, fidNumRows, OUTPUT, 4 );
    err = wdCommandDispatch( wdTableInsertTable, CommandAction | CommandDialog, wcb.cArgs, wcb.wdoprArgs, lpwdoprNil );
    if (err != 0 )
    {
        itoa( err, vszBuffer, 10 );
        MessageBox( NULL, vszBuffer, "TableInsertTable Error", MB_OK );
        return;
    }  
             
    // HourGlass Cursor and Turn screen updating OFF 
    InitWCB( &wcb, 0, NULL, 0 );
    AddShortParam( &wcb, 1 );
    wdCommandDispatch( wdWaitCursor, 0, wcb.cArgs, wcb.wdoprArgs, lpwdoprNil );
    InitWCB( &wcb, 0, NULL, 0 );
    AddShortParam( &wcb, 0 );
    wdCommandDispatch( wdScreenUpdating, 0, wcb.cArgs, wcb.wdoprArgs, lpwdoprNil );

    // Insert column and row information in each cell 
    nCols = atoi( szCols );
    nRows = atoi( szRows );
        
    for (cRow = 1; cRow <= nRows; cRow++)
    {
        for (cCol = 1; cCol <= nCols; cCol++)
        {
            // Insert Col and row number information in current cell 
            wsprintf( szBuffer, "Row %d, Col %d", cRow, cCol );
            InitWCB( &wcb, TypeShort, NULL, 0 );
            AddStringDlgField( &wcb, szBuffer, elkNil, INPUT, 0 );
            err = wdCommandDispatch( wdInsert, 0, wcb.cArgs, wcb.wdoprArgs, lpwdoprNil );
            if (err != 0 )
            {
                itoa( err, vszBuffer, 10 );
                MessageBox( NULL, vszBuffer, "fciMstInsert Error", MB_OK );
            }  
        
            // move IP to next cell (except at last cell)  
            if ( cRow < nRows || cCol < nCols )
            {
                InitWCB( &wcb, TypeShort, NULL, 0 );
                err = wdCommandDispatch( wdNextCell, 0, wcb.cArgs, wcb.wdoprArgs, lpwdoprNil );   
                if (err != 0 )
                {
                    itoa( err, vszBuffer, 10 );
                    MessageBox( NULL, vszBuffer, "fciMstNextCell Error", MB_OK );
                }  
            }
        }
    }
            
    // Move IP to the start of the document 
    InitWCB( &wcb, TypeShort, NULL, 0 );
    err = wdCommandDispatch( wdStartOfDocument, 0, wcb.cArgs, wcb.wdoprArgs, lpwdoprNil );
    if (err != 0 )
    {
        itoa( err, vszBuffer, 10 );
        MessageBox( NULL, vszBuffer, "fciMstStartOfDocument Error", MB_OK );
    }  

    // Turn screen updating ON and restore cursor
    InitWCB( &wcb, 0, NULL, 0 );
    AddShortParam( &wcb, 1 );
    wdCommandDispatch( wdScreenUpdating, 0, wcb.cArgs, wcb.wdoprArgs, lpwdoprNil );
    InitWCB( &wcb, 0, NULL, 0 );
    AddShortParam( &wcb, 0 );
    wdCommandDispatch( wdWaitCursor, 0, wcb.cArgs, wcb.wdoprArgs, lpwdoprNil );
}
     

// Demonstrates arrays of strings
//     
void far pascal StringArray( void )  
{
    WCB             wcb;
    short           err;
    HANDLE          hArrayDef;
    ARRAY_DEF far * ArrayDef;
    LPUCHAR         lpStrArray[ARRAYSIZE];     //array of LPSTR to be passed in the call
    uchar           strArray[ARRAYSIZE][64];   //buffers pointed by the array
    short           i;

    // Set the array definition
    if(( ArrayDef = SetArrayDef( (HANDLE far *)&hArrayDef, 1, ARRAYSIZE )) == NULL)
    {
        MessageBox( NULL, vszBuffer, "Couldn't allocate Array_Def", MB_OK );
        return;
    }
        
    // Set the array of LPSTR to point to a buffer
    for( i = 0; i < ARRAYSIZE; i++ )
    {
        lpStrArray[i] = strArray[i];
    }
        
    // Call GetAppNames
    InitWCB( &wcb, TypeShort, NULL, 0 );
    AddStringArray( &wcb, ArrayDef, lpStrArray, 64 );
    if ((err = wdCommandDispatch( wdAppGetNames, 0, wcb.cArgs, wcb.wdoprArgs, &wcb.wdoprReturn)) != 0)
    {
        itoa( err, vszBuffer, 10 );
        MessageBox( NULL, vszBuffer, "GetAppNames Error", MB_OK );
        return;
    }
    
    // Display the results
    for (i = 0; i < wcb.wdoprReturn.Short; i++)
    {
        MessageBox( NULL, wcb.wdoprArgs[0].StringArray[i], "App Names", MB_OK );
    } 

    // Free allocated ArrayDef      
    GlobalUnlock( hArrayDef );
    GlobalFree( hArrayDef );   
}        
     
 
// Demonstrates arrays of doubles
//    
void far pascal DoubleArray( void )  
{
    WCB             wcb;
    int             err;
    HANDLE          hArrayDef;
    ARRAY_DEF far * ArrayDef;
    double          array[5];
    short           i;

    // Set the array definition
    if(( ArrayDef = SetArrayDef( (HANDLE far *)&hArrayDef, 1, 5 )) == NULL)
    {
        MessageBox( NULL, vszBuffer, "Couldn't allocate Array_Def", MB_OK );
        return;
    }
        
    // Set the value of the array items
    for( i = 0; i < 5; i++ )
    {
        array[i] = 5.55 - i;
    }
        
    // Call SortArray
    InitWCB( &wcb, TypeShort, NULL, 0 );
    AddDoubleArray( &wcb, ArrayDef, array );
    if ((err = wdCommandDispatch( wdSortArray, 0, wcb.cArgs, wcb.wdoprArgs, lpwdoprNil ))!= 0)
    {
        itoa( err, vszBuffer, 10 );
        MessageBox( NULL, vszBuffer, "SortArray Error", MB_OK );
        return;
    } 

    // Display the results  
    for (i = 0; i < 5; i++)
    { 
        InitWCB( &wcb, TypeString, vszBuffer, 256 );
        AddDoubleParam( &wcb, array[i] );
        err = wdCommandDispatch( wdStr$, 0, wcb.cArgs,wcb.wdoprArgs, &wcb.wdoprReturn );
        MessageBox( NULL, vszBuffer, "Sort Array", MB_OK );
    } 
    
    // Free the Array definition
    GlobalUnlock( hArrayDef );
    GlobalFree( hArrayDef );   
}        
    

// Standard LibMain for a Windows DLL
//   
int FAR PASCAL LibMain( HANDLE hInstance, WORD wDataSeg, WORD wHeapSize, LPSTR lpszCmdLine )
{
    if (wHeapSize > 0)
        UnlockData( 0 );

    vhInst = hInstance;
    return 1;
}

// Standard WEP for a Windows DLL
// 
int FAR PASCAL WEP (int nParam)
{
    return 1;
}
