/*-----------------------------------------------------------------------

    File: CAPILIB.H
    Header file for CAPILIB.C

------------------------------------------------------------------------*/
#include "wdcapi.h" 

// Input and ouput constans for dialog commands
#define INPUT   1
#define OUTPUT  2
#define IN_OUT  3

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

/**** Word Command Buffer Manipulation Routines ****/
// Initialization
void InitWCB( WCB far *, ushort, LPUCHAR, ushort );

// Dialog command arguments
void AddShortDlgField( WCB far *, short, ushort, ushort );
void AddLongDlgField( WCB far *, long, ushort, ushort );
void AddDoubleDlgField( WCB far *, double, ushort, ushort );
void AddStringDlgField( WCB far *, LPUCHAR, ushort, ushort, ushort );

// Function and statement arguments
void AddShortParam( WCB far *, short );
void AddLongParam( WCB far *, long );
void AddDoubleParam( WCB far *, double );
void AddStringParam( WCB far *, LPUCHAR );

// Arrays
ARRAY_DEF far *SetArrayDef( HANDLE far *, short , ... ); 
void          AddStringArray( WCB far *, ARRAY_DEF far *, LPUCHAR far *, ushort );
void          AddDoubleArray( WCB far *, ARRAY_DEF far *, double far * );


/**** Word Customization Routines ****/
short CAPIRegister( short, LPUCHAR );
short CAPIAddToolbar( short, LPUCHAR );
short CAPIAddButton( short, LPUCHAR, short, LPUCHAR, LPUCHAR ); 
short CAPIAddMenu( short, LPUCHAR, short, short );
short CAPIAddMenuItem( short, LPUCHAR, LPUCHAR, LPUCHAR, short, short );
short CAPIAddKey( short, short, LPUCHAR );

#ifdef __cplusplus
}
#endif // __cplusplus
