;
; QuickSurf AutoLISP Utility Version 4.7
;
; (c) Copyright 1993 Schreiber Instruments, Inc.
; All rights reserved.

(prompt "\nLoading lisp, Please Wait...")

(if (not enter) (load "qs"))

(defun c:setopts ( / ch ch2 ch3 ch4 tmp so_err so_oer version)
  (setvar "CMDECHO" 0)
  (defun so_err (s)
    (if (/= s "Function cancelled")
      (if (= s "quit / exit abort")
        (princ)
        (princ (strcat "\nError: " s))
      )
    )
    (if so_oer        
      (setq *error* so_oer) 
    )
    (menucmd "s=")
    (menucmd "s=")
    (princ)
  )
  
  (if *error*                     
    (setq so_oer *error* *error* so_err) 
    (setq *error* so_err) 
  )

  (menucmd "s=QSclr")
  (menucmd "s=QSopt1")
  (setq ch "Window")
  (while (/= ch "Cancel")
    (setq ch "Cancel")
    (initget 0 "Window Grid Draping Extract CAncel List Save RESet COLor CONtour File REAd BReaks BOundary")
    (setq tmp (getkword "\nWindow/Grid/CONtour/Draping/Extract/BReaks/BOundary/COLor/File <>: "))
    (if tmp (setq ch tmp))
    (if (/= ch "Cancel") 
      (progn
        (cond
          ((= ch "Window")
            (c:qsopt "window")
            (c:qsopt "avoid")
          )
          ((= ch "BOundary")
            (bound_dialog)
            (setq ch "Cancel")
          )
          ((= ch "CONtour")
            (contour_dialog)
            (setq ch "Cancel")
          )
          ((= ch "Grid")
            (grid_dialog)
            (setq ch "Cancel")
          )
          ((= ch "File")
            (file_dialog)
            (setq ch "Cancel")
          )
          ((= ch "Draping")    
            (drape_dialog)
            (setq ch "Cancel")
          )
          ((= ch "COLor")
            (menucmd "s=QSclr")
            (menucmd "s=QSopt2")
            (setq ch2 "Last"
                  wh 0
                  lp 1
            )
            (while (= lp 1)
              (initget 0 "Paint Contour Show Wheel Last File Cancel")
              (setq tmp (getkword "\nPaint/Contour/Show/File/Wheel <>: "))
              (if tmp (setq ch2 tmp))
              (cond
                ((= ch2 "Paint")
                  (c:paint)
                  (setq lp 0)
                )
                ((= ch2 "File")
                  (c:qsopt "cmapfile")
                  (setq lp 0)
                )
                ((= ch2 "Wheel")
                  (command "vslide" "colorwh")
                  (setq wh 1)
                )
                ((= ch2 "Show")
                  (c:qsopt "showcolor")
                  (c:qsopt "showhi")
                  (setq lp 0)
                )
                ((= ch2 "Contour")
                  (c:qsopt "color")
                  (setq ch3 (c:qsopt "get" "color"))
                  (if (= ch3 1)
                    (progn
                      (c:qsopt "colcont")
                      (setq ch4 (c:qsopt "get" "colcont"))
                      (prompt (strcat "\nMethod: " ch4))
                      (cond
                        ((= ch4 "Cycle")
                          (c:qsopt "startcol")
                          (c:qsopt "ncolors")
                          (prompt "\nInterval for increamenting color")
                          (c:qsopt "colintvl")
                        )
                        ((= ch4 "Interval")
                          (prompt "\nInterval for highlighted contour/0 for auto")
                          (c:qsopt "colintvl")
                          (prompt "\nBase")
                          (c:qsopt "color1")
                          (prompt "\nHighlighted")
                          (c:qsopt "color2")
                        )
                        ((= ch4 "Split")
                          (prompt "\nLow")
                          (c:qsopt "color1")
                          (prompt "\nHigh")
                          (c:qsopt "color2")
                          (prompt "\nElevation for color split")
                          (c:qsopt "colintvl")
                        )
                      )
                    )
                  )
                  (setq lp 0)
                )
                ((= ch2 "Cancel")
                  (setq ch "Cancel")
                  (setq lp 0)
                )
                ((= ch2 "Last")
                  (setq lp 0)
                )
              )
            )
            (if (= wh 1)
              (redraw)
            )
            (menucmd "s=")
            (menucmd "s=")
          )
          ((= ch "Extract")
            (extract_dialog)
            (setq ch "Cancel")
          )
          ((= ch "BReaks")
            (break_dialog)
            (setq ch "Cancel")
          )
          ((= ch "Save")
            (c:qsopt "write" "?")
          )
          ((= ch "REAd")
            (c:qsopt "read" "?")
          )
          ((= ch "RESet")
            (c:qsopt "reset")
          )
          ((= ch "List")
            (c:qsopt "?")
          )
          (T
            (setq ch "Cancel")
          )
        )
      )
    )
    (if (/= ch "Cancel") 
      (setq ch "Window")
    )
  )
  (menucmd "s=")
  (menucmd "s=")
  (princ)
)

(defun grid_dialog( / id al ret so_err so_oer version)
  (setvar "CMDECHO" 0)
  (defun so_err (s)
    (if (/= s "Function cancelled")
      (if (= s "quit / exit abort")
        (princ)
        (princ (strcat "\nError: " s))
      )
    )
    (if so_oer        
      (setq *error* so_oer) 
    )
    (princ)
  )
  
  (if *error*                     
    (setq so_oer *error* *error* so_err) 
    (setq *error* so_err) 
  )
  (setq version (substr (getvar "ACADVER") 1 2))

  (if (and (= (getvar "FILEDIA") 1)(= version "12"))
    (progn
      (setq id (load_dialog "qsopts.dcl"))
      (if (new_dialog "gridopts" id)
        (progn
          (setq al (c:qsopt "get" "cellsize"))
          (set_tile "grid_size_x" (rtos (car al) 2))
          (set_tile "grid_size_y" (rtos (cadr al) 2))
          (if (= (car al) 0)
            (progn
              (set_tile "auto_size" "1")
              (mode_tile "grid_size_x" 1)
              (mode_tile "grid_size_y" 1)
            )
            (set_tile "auto_size" "0")
          )  
          (setq al (c:qsopt "get" "cellcnt"))
          (set_tile "grid_count_x" (itoa (car al)))
          (set_tile "grid_count_y" (itoa (cadr al)))
          (if (= (car al) 0)
            (progn
              (set_tile "auto_count" "1")
              (mode_tile "grid_count_x" 1)
              (mode_tile "grid_count_y" 1)
            )
            (set_tile "auto_count" "0")
          )  
          (set_tile "grid_factor" (rtos (c:qsopt "get" "cellfac") 2))
          (set_tile "grid_cellmin" (rtos (c:qsopt "get" "cellmin") 2 0))
          (set_tile "grid_cellmax" (rtos (c:qsopt "get" "cellmax") 2 0))
          (set_tile "grid_meshbase" (rtos (c:qsopt "get" "meshbase") 2))
          (setq al (c:qsopt "get" "gmethod"))
          (cond 
            ((= al 1)
              (set_tile "grid_standard" "1")
              (mode_tile "grid_trd" 1)
              (mode_tile "grid_krg" 1)
            )
            ((= al 2)
              (set_tile "grid_krige" "1")
              (mode_tile "grid_trd" 1)
              (mode_tile "grid_std" 1)
            )
            ((= al 3)
              (set_tile "grid_trend" "1")
              (mode_tile "grid_std" 1)
              (mode_tile "grid_krg" 1)
            )
          )
          (setq al (c:qsopt "get" "dorder"))
          (cond 
            ((= al 0)
              (set_tile "dorder_0" "1")
            )
            ((= al 1)
              (set_tile "dorder_1" "1")
            )
            ((= al 2)
              (set_tile "dorder_2" "1")
            )
          )
          (setq al (c:qsopt "get" "border"))
          (cond 
            ((= al 1)
              (set_tile "border_1" "1")
            )
            ((= al 2)
              (set_tile "border_2" "1")
            )
          )
          (set_tile "grid_weight" (itoa (c:qsopt "get" "weight")))
          (if (/= (c:qsopt "get" "honor") 0)
            (set_tile "grid_honor" "1")
          )
          (setq al (c:qsopt "get" "ttype"))
          (cond 
            ((= al 1)
              (set_tile "ttype_1" "1")
            )
            ((= al 2)
              (set_tile "ttype_2" "1")
            )
          )
          (setq al (c:qsopt "get" "torder"))
          (set_tile "torder_x" (itoa (car al)))
          (set_tile "torder_y" (itoa (cadr al)))
          (set_tile "grid_rings" (itoa (c:qsopt "get" "rings")))
          (grid_actions)
          (setq ret (start_dialog))
        )
      )
    )
    (progn
      (menucmd "s=QSclr")
      (menucmd "s=QSopt12")
      (setq ch2 "Last")
      (while (/= ch2 "CAncel")
        (initget 0 "Size COunt Factor MIn MAx MEShbase Last CAncel METhod")
        (setq tmp (getkword "\nMEThod/Size/COunt/Factor/MIn/MAx/MEShbase <>: "))
        (if tmp (setq ch2 tmp))
        (cond
          ((= ch2 "Size")
            (c:qsopt "cellsize")
          )
          ((= ch2 "COunt")
            (c:qsopt "cellcnt")
          )
          ((= ch2 "Factor")
            (c:qsopt "cellfac")
          )
          ((= ch2 "MIn")
            (c:qsopt "cellmin")
          )
          ((= ch2 "MAx")
            (c:qsopt "cellmax")
          )
          ((= ch2 "MEShbase")
            (c:qsopt "meshbase")
          )
          ((= ch2 "METhod")
            (c:qsopt "gmethod")
            (setq ch3 (c:qsopt "get" "gmethod"))
            (cond 
              ((= ch3 1)
                (c:qsopt "dorder")
                (setq ch4 (c:qsopt "get" "dorder"))
                (cond 
                  ((= ch4 1)
                    (c:qsopt "border" 1)
                    (c:qsopt "border")
                  )
                  ((= ch4 2)
                    (c:qsopt "border" 2)
                    (c:qsopt "border")
                  )
                )
                (c:qsopt "weight")
                (c:qsopt "honor")
              )
              ((= ch3 2)
                (c:qsopt "rings")
              )
              ((= ch3 3)
                (c:qsopt "ttype")
                (c:qsopt "torder")
              )
            )
          )
          ((= ch2 "CAncel")
            (setq ch "Cancel")
          )
          (T
            (setq ch2 "CAncel")
          )
        )
        (if (/= ch2 "CAncel")
          (setq ch2 "Last")
        )
      )
      (menucmd "s=")
      (menucmd "s=")
    )
  )
)

(defun grid_actions( / vl ky )
  (action_tile "auto_size" "(gridCB_asize (setq vl $value))")
  (action_tile "grid_size_x" "(optCB_num (setq vl $value) (setq ky $key) 1)")
  (action_tile "grid_size_y" "(optCB_num (setq vl $value) (setq ky $key) 1)")
  (action_tile "auto_count" "(gridCB_acount (setq vl $value))")
  (action_tile "grid_count_x" "(optCB_num (setq vl $value) (setq ky $key) 0)")
  (action_tile "grid_count_y" "(optCB_num (setq vl $value) (setq ky $key) 0)")
  (action_tile "grid_factor" "(optCB_num (setq vl $value) (setq ky $key) 1)")
  (action_tile "grid_cellmin" "(optCB_num (setq vl $value) (setq ky $key) 0)")
  (action_tile "grid_cellmax" "(optCB_num (setq vl $value) (setq ky $key) 0)")
  (action_tile "grid_meshbase" "(optCB_num (setq vl $value) (setq ky $key) 1)")
  (action_tile "grid_standard" "(gridCB_gmethod 1)")
  (action_tile "grid_krige" "(gridCB_gmethod 2)")
  (action_tile "grid_trend" "(gridCB_gmethod 3)")
  (action_tile "torder_x" "(optCB_num (setq vl $value) (setq ky $key) 0)")
  (action_tile "torder_y" "(optCB_num (setq vl $value) (setq ky $key) 0)")
  (action_tile "grid_weight" "(optCB_num (setq vl $value) (setq ky $key) 0)")
  (action_tile "grid_rings" "(optCB_num (setq vl $value) (setq ky $key) 0)")
  (action_tile "accept" "(gridCB_accept)")
  (action_tile "cancel" "(done_dialog 0)")
  (action_tile "help" "(acad_helpdlg \"qs.hlp\" \"Grid Configuration\")")
)

(defun optCB_num( vl ky fp / n nf )
  (setq n (ascii vl))
  (if (or (< n 45)(> n 57)(= n 47))
    (progn
      (alert "Not a numeric value")
      (setq nf 0.0)
    )
    (setq nf (atof vl))
  )
  (if (= fp 0)
    (set_tile ky (rtos nf 2 0))
    (set_tile ky (rtos nf 2))
  )
)

(defun gridCB_asize( tog )
  (if (= tog "1")
    (progn
      (set_tile "grid_size_x" (rtos 0.0 2))
      (set_tile "grid_size_y" (rtos 0.0 2))
      (mode_tile "grid_size_x" 1)
      (mode_tile "grid_size_y" 1)
    )
    (progn
      (mode_tile "grid_size_x" 0)
      (mode_tile "grid_size_y" 0)
    )
  )
)

(defun gridCB_acount( tog )
  (if (= tog "1")
    (progn
      (set_tile "grid_count_x" "0")
      (set_tile "grid_count_y" "0")
      (mode_tile "grid_count_x" 1)
      (mode_tile "grid_count_y" 1)
    )
    (progn
      (mode_tile "grid_count_x" 0)
      (mode_tile "grid_count_y" 0)
    )
  )
)

(defun gridCB_gmethod( ngrid )
  (cond 
    ((= ngrid 1)
      (mode_tile "grid_trd" 1)
      (mode_tile "grid_krg" 1)
      (mode_tile "grid_std" 0)
    )
    ((= ngrid 2)
      (mode_tile "grid_trd" 1)
      (mode_tile "grid_krg" 0)
      (mode_tile "grid_std" 1)
    )
    ((= ngrid 3)
      (mode_tile "grid_trd" 0)
      (mode_tile "grid_krg" 1)
      (mode_tile "grid_std" 1)
    )
  )
)

(defun gridCB_accept()
  (c:qsopt "cellsize" (atof (get_tile "grid_size_x")) (atof (get_tile "grid_size_y")))
  (c:qsopt "cellcnt" (atoi (get_tile "grid_count_x")) (atoi (get_tile "grid_count_y")))
  (c:qsopt "cellfac" (atof (get_tile "grid_factor")))
  (c:qsopt "cellmin" (atof (get_tile "grid_cellmin")))
  (c:qsopt "cellmax" (atof (get_tile "grid_cellmax")))
  (c:qsopt "meshbase" (atof (get_tile "grid_meshbase")))

  (if (= (get_tile "grid_standard") "1")
    (c:qsopt "gmethod" 1)
    (progn
      (if (= (get_tile "grid_krige") "1")
        (c:qsopt "gmethod" 2)
        (c:qsopt "gmethod" 3)
      )
    )
  )
  (if (= (get_tile "dorder_2") "1")
    (c:qsopt "dorder" 2)
    (progn
      (if (= (get_tile "dorder_1") "1")
        (c:qsopt "dorder" 1)
        (c:qsopt "dorder" 0)
      )
    )
  )
  (if (= (get_tile "border_2") "1")
    (c:qsopt "border" 2)
    (c:qsopt "border" 1)
  )
  (c:qsopt "weight" (atoi (get_tile "grid_weight")))
  (if (= (get_tile "grid_honor") "1")
    (c:qsopt "honor" 1)
    (c:qsopt "honor" 0)
  )
  (if (= (get_tile "ttype_2") "1")
    (c:qsopt "ttype" 2)
    (c:qsopt "ttype" 1)
  )
  (c:qsopt "torder" (atoi (get_tile "torder_x")) (atoi (get_tile "torder_y")))
  (c:qsopt "rings" (atoi (get_tile "grid_rings")))

  (done_dialog 1)
)

(defun break_dialog( / so_err so_oer version)
  (setvar "CMDECHO" 0)
  (defun so_err (s)
    (if (/= s "Function cancelled")
      (if (= s "quit / exit abort")
        (princ)
        (princ (strcat "\nError: " s))
      )
    )
    (if so_oer        
      (setq *error* so_oer) 
    )
    (princ)
  )
  
  (if *error*                     
    (setq so_oer *error* *error* so_err) 
    (setq *error* so_err) 
  )
  (setq version (substr (getvar "ACADVER") 1 2))

  (if (and (= (getvar "FILEDIA") 1)(= version "12"))
    (progn
      (setq id (load_dialog "qsopts.dcl"))
      (if (new_dialog "breakopts" id)
        (progn
          (setq al (c:qsopt "get" "brkstep"))
          (set_tile "brk_step" (rtos al 2))
          (if (= al 0.0)
            (progn
              (set_tile "auto_bstep" "1")
              (mode_tile "brk_step" 1)
            )
          )
          (setq al (c:qsopt "get" "brkcrverr"))
          (set_tile "brk_crverr" (rtos al 2))
          (if (= al 0.0)
            (progn
              (set_tile "auto_cerr" "1")
              (mode_tile "brk_crverr" 1)
            )
          )
          (action_tile "brk_crverr" "(optCB_num (setq vl $value) (setq ky $key) 1)")
          (action_tile "brk_step" "(optCB_num (setq vl $value) (setq ky $key) 1)")
          (action_tile "auto_bstep" "(brkCB_bstep (setq vl $value))")
          (action_tile "auto_cerr" "(brkCB_cerr (setq vl $value))")
          (action_tile "accept" "(breakCB_accept)")
          (action_tile "cancel" "(done_dialog 0)")
          (action_tile "help" "(acad_helpdlg \"qs.hlp\" \"Break Line Configuration\")")
          (setq ret (start_dialog))
        )
      )
    )
    (progn
      (c:qsopt "brkstep")
      (c:qsopt "brkcrverr")
    )
  )
)

(defun brkCB_bstep( tog )
  (if (= tog "1")
    (progn
      (set_tile "brk_step" (rtos 0.0 2))
      (mode_tile "brk_step" 1)
    )
    (progn
      (mode_tile "brk_step" 0)
    )
  )
)

(defun brkCB_cerr( tog )
  (if (= tog "1")
    (progn
      (set_tile "brk_crverr" (rtos 0.0 2))
      (mode_tile "brk_crverr" 1)
    )
    (progn
      (mode_tile "brk_crverr" 0)
    )
  )
)

(defun breakCB_accept()
  (c:qsopt "brkstep" (atof (get_tile "brk_step")))
  (c:qsopt "brkcrverr" (atof (get_tile "brk_crverr")))
  (done_dialog 1)
)

(defun extract_dialog( / so_err so_oer version)
  (setvar "CMDECHO" 0)
  (defun so_err (s)
    (if (/= s "Function cancelled")
      (if (= s "quit / exit abort")
        (princ)
        (princ (strcat "\nError: " s))
      )
    )
    (if so_oer        
      (setq *error* so_oer) 
    )
    (princ)
  )
  
  (if *error*                     
    (setq so_oer *error* *error* so_err) 
    (setq *error* so_err) 
  )
  (setq version (substr (getvar "ACADVER") 1 2))

  (if (and (= (getvar "FILEDIA") 1)(= version "12"))
    (progn
      (setq id (load_dialog "qsopts.dcl"))
      (if (new_dialog "extractopts" id)
        (progn
          (if (= (c:qsopt "get" "rough") 0)
            (set_tile "ext_rough" "0")
            (set_tile "ext_rough" "1")
          )
          (set_tile "ext_npmax" (rtos (c:qsopt "get" "npmax") 2 0))
          (action_tile "ext_npmax" "(optCB_num (setq vl $value) (setq ky $key) 0)")
          (action_tile "accept" "(extractCB_accept)")
          (action_tile "cancel" "(done_dialog 0)")
          (action_tile "help" "(acad_helpdlg \"qs.hlp\" \"Extract Configuration\")")
          (setq ret (start_dialog))
        )
      )
    )
    (progn
      (c:qsopt "rough")
      (c:qsopt "npmax")
    )
  )
)

(defun extractCB_accept()
  (c:qsopt "npmax" (atof (get_tile "ext_npmax")))
  (if (= (get_tile "ext_rough") "1")
    (c:qsopt "rough" 1)
    (c:qsopt "rough" 0)
  )
  (done_dialog 1)
)

(defun drape_dialog( / al so_err so_oer version)
  (setvar "CMDECHO" 0)
  (defun so_err (s)
    (if (/= s "Function cancelled")
      (if (= s "quit / exit abort")
        (princ)
        (princ (strcat "\nError: " s))
      )
    )
    (if so_oer        
      (setq *error* so_oer) 
    )
    (princ)
  )
  
  (if *error*                     
    (setq so_oer *error* *error* so_err) 
    (setq *error* so_err) 
  )
  (setq version (substr (getvar "ACADVER") 1 2))

  (if (and (= (getvar "FILEDIA") 1)(= version "12"))
    (progn
      (setq id (load_dialog "qsopts.dcl"))
      (if (new_dialog "drapeopts" id)
        (progn
          (if (= (setq al (c:qsopt "get" "drbase")) 0)
            (set_tile "drape_tin" "1")
            (set_tile "drape_grid" "1")
          )
          (if (= (c:qsopt "get" "drorder") 3)
            (set_tile "drape_order_3" "1")
            (set_tile "drape_order_1" "1")
          )
          (if (= al 0)
            (mode_tile "drape_order" 1)
          )
          (setq al (c:qsopt "get" "drstep"))
          (set_tile "drape_step" (rtos al 2))
          (if (= al 0.0)
            (progn
              (set_tile "auto_dstep" "1")
              (mode_tile "drape_step" 1)
            )
          )
          (action_tile "drape_tin" "(drapeCB_base 1)")
          (action_tile "drape_grid" "(drapeCB_base 0)")
          (action_tile "drape_tgrd" "(drapeCB_base 1)")
          (action_tile "auto_dstep" "(drapeCB_dstep (setq vl $value))")
          (action_tile "drape_step" "(optCB_num (setq vl $value) (setq ky $key) 1)")
          (action_tile "accept" "(drapeCB_accept)")
          (action_tile "cancel" "(done_dialog 0)")
          (action_tile "help" "(acad_helpdlg \"qs.hlp\" \"Drape Configuration\")")
          (setq ret (start_dialog))
        )
      )
    )
    (progn
      (c:qsopt "drbase")
      (setq ch2 (c:qsopt "get" "drbase"))
      (if (= ch2 1)
        (c:qsopt "drorder")
      )
      (c:qsopt "drstep")
    )
  )
)

(defun drapeCB_base( tog )
  (mode_tile "drape_order" tog)
)

(defun drapeCB_dstep( tog )
  (if (= tog "1")
    (progn
      (set_tile "drape_step" (rtos 0.0 2))
      (mode_tile "drape_step" 1)
    )
    (progn
      (mode_tile "drape_step" 0)
    )
  )
)

(defun drapeCB_accept()
  (if (= (get_tile "drape_grid") "1")
    (c:qsopt "drbase" 1)
    (c:qsopt "drbase" 0)
  )
  (if (= (get_tile "drape_order_3") "1")
    (c:qsopt "drorder" 3)
    (c:qsopt "drorder" 1)
  )
  (c:qsopt "drstep" (atof (get_tile "drape_step")))
  (done_dialog 1)
)

(defun file_dialog( / so_err so_oer version)
  (setvar "CMDECHO" 0)
  (defun so_err (s)
    (if (/= s "Function cancelled")
      (if (= s "quit / exit abort")
        (princ)
        (princ (strcat "\nError: " s))
      )
    )
    (if so_oer        
      (setq *error* so_oer) 
    )
    (princ)
  )
  
  (if *error*                     
    (setq so_oer *error* *error* so_err) 
    (setq *error* so_err) 
  )
  (setq version (substr (getvar "ACADVER") 1 2))

  (if (and (= (getvar "FILEDIA") 1)(= version "12"))
    (progn
      (setq id (load_dialog "qsopts.dcl"))
      (if (new_dialog "fileopts" id)
        (progn
          (setq al (c:qsopt "get" "scalefac"))
          (set_tile "file_scl_x" (rtos (car al) 2))
          (set_tile "file_scl_y" (rtos (cadr al) 2))
          (set_tile "file_scl_z" (rtos (caddr al) 2))
          (setq al (c:qsopt "get" "colpos"))
          (set_tile "file_colpos_x" (itoa (car al)))
          (set_tile "file_colpos_y" (itoa (cadr al)))
          (set_tile "file_colpos_z" (itoa (caddr al)))
          (setq al (c:qsopt "get" "fname"))
          (if (= al " ")
            (progn
              (set_tile "file_fname" "")
              (setq al nil)
            )
            (set_tile "file_fname" al)
          ) 
          (if (and al (> (strlen al) 0))
            (set_tile "error" "")
            (set_tile "error" "No file set")
          )
          (action_tile "file_colpos_x" "(optCB_num (setq vl $value) (setq ky $key) 0)")
          (action_tile "file_colpos_y" "(optCB_num (setq vl $value) (setq ky $key) 0)")
          (action_tile "file_colpos_z" "(optCB_num (setq vl $value) (setq ky $key) 0)")
          (action_tile "file_scl_x" "(optCB_num (setq vl $value) (setq ky $key) 1)")
          (action_tile "file_scl_y" "(optCB_num (setq vl $value) (setq ky $key) 1)")
          (action_tile "file_scl_z" "(optCB_num (setq vl $value) (setq ky $key) 1)")
          (action_tile "file_fname" "(fileCB_file (setq vl $value) (setq ky $key))")
          (action_tile "accept" "(fileCB_accept)")
          (action_tile "cancel" "(done_dialog 0)")
          (action_tile "help" "(acad_helpdlg \"qs.hlp\" \"File Controls\")")
          (setq ret (start_dialog))
        )
      )
    )
    (progn
      (c:qsopt "fname")
      (c:qsopt "colpos")
      (c:qsopt "scalefac")
    )
  )
)

(defun fileCB_file( vl ky / fl )
  (if (and vl (> (strlen vl) 0))
    (progn
      (if (setq fl (findfile vl))
        (progn
          (set_tile ky fl)
          (set_tile "error" "")
        )
        (progn
          (set_tile "error" "File not found")
          (set_tile ky "")
        )
      )
    )
    (set_tile "error" "No file set")
  )
)

(defun fileCB_accept( / fl )
  (c:qsopt "scalefac" (atof (get_tile "file_scl_x")) (atof (get_tile "file_scl_y")) (atof (get_tile "file_scl_z")))
  (c:qsopt "colpos" (atoi (get_tile "file_colpos_x")) (atoi (get_tile "file_colpos_y")) (atoi (get_tile "file_colpos_z")))
  (setq fl (get_tile "file_fname"))
  (if (and fl (> (strlen fl) 0))
    (c:qsopt "fname" fl)
    (c:qsopt "fname" "")
  )
  (done_dialog 1)
)

(defun contour_dialog( / al vl ky so_err so_oer version)
  (setvar "CMDECHO" 0)
  (defun so_err (s)
    (if (/= s "Function cancelled")
      (if (= s "quit / exit abort")
        (princ)
        (princ (strcat "\nError: " s))
      )
    )
    (if so_oer        
      (setq *error* so_oer) 
    )
    (princ)
  )
  
  (if *error*                     
    (setq so_oer *error* *error* so_err) 
    (setq *error* so_err) 
  )
  (setq version (substr (getvar "ACADVER") 1 2))

  (if (and (= (getvar "FILEDIA") 1)(= version "12"))
    (progn
      (setq id (load_dialog "qsopts.dcl"))
      (if (new_dialog "contouropts" id)
        (progn
          (if (= (c:qsopt "get" "cmethod") 2)
            (set_tile "cont_tin" "1")
            (set_tile "cont_grid" "1")
          )
          (set_tile "cont_level" (itoa (c:qsopt "get" "levels")))
          (set_tile "cont_interval" (setq al (rtos (c:qsopt "get" "interval") 2)))
          (if (= al 0)
            (progn
              (set_tile "auto_int" "1")
              (mode_tile "cont_interval" 1)
            )
            (progn
              (set_tile "auto_int" "0")
              (mode_tile "cont_level" 1)
            )
          )
          (set_tile "cont_elevfile" (setq al (c:qsopt "get" "elevfile")))
          (if (and al (> (strlen al) 0))
            (set_tile "error" "Contouring from file elevations")
            (set_tile "error" "Contouring using calculated intervals")
          )
          (action_tile "auto_int" "(contourCB_auto (setq vl $value))")
          (action_tile "cont_interval" "(contourCB_int (setq vl $value) (setq ky $key))")
          (action_tile "cont_level" "(optCB_num (setq vl $value) (setq ky $key) 0)")
          (action_tile "cont_elevfile" "(contourCB_file (setq vl $value) (setq ky $key))")
          (action_tile "accept" "(contourCB_accept)")
          (action_tile "cancel" "(done_dialog 0)")
          (action_tile "help" "(acad_helpdlg \"qs.hlp\" \"Contour Configuration\")")
          (setq ret (start_dialog))
        )
      )
    )
    (progn
      (c:qsopt "cmethod")
      (c:qsopt "interval")
      (setq ch2 (c:qsopt "get" "interval"))
      (if (= ch2 0)
        (c:qsopt "levels")
      )
      (c:qsopt "elevfile")
    )
  )
)

(defun contourCB_auto( tog )
  (if (= tog "1")
    (progn
      (set_tile "cont_interval" "0")
      (mode_tile "cont_interval" 1)
      (mode_tile "cont_level" 0)
    )
    (progn
      (mode_tile "cont_interval" 0)
      (mode_tile "cont_level" 1)
    )
  )
)

(defun contourCB_int( vl ky / nf )
  (optCB_num vl ky 1)

  (if (= (atof vl) 0)
    (progn
      (set_tile "auto_int" "1")
      (mode_tile "cont_interval" 1)
      (mode_tile "cont_level" 0)
    )
    (progn
      (set_tile "auto_int" "0")
      (mode_tile "cont_interval" 0)
      (mode_tile "cont_level" 1)
    )
  )
)

(defun contourCB_file( vl ky / fl )
  (if (and vl (> (strlen vl) 0))
    (progn
      (if (setq fl (findfile vl))
        (progn
          (set_tile "error" "Contouring from file elevations")
          (set_tile ky fl)
        )
        (progn
          (set_tile "error" "File not found")
          (set_tile ky "")
        )
      )
    )
    (set_tile "error" "Contouring using calculated intervals")
  )
)

(defun contourCB_accept( / fl )
  (c:qsopt "interval" (atof (get_tile "cont_interval")))
  (c:qsopt "levels" (atoi (get_tile "cont_level")))
  (if (= (get_tile "cont_grid") "1")
    (c:qsopt "cmethod" 1)
    (c:qsopt "cmethod" 2)
  )
  (setq fl (get_tile "cont_elevfile"))
  (if (and fl (> (strlen fl) 0))
    (c:qsopt "elevfile" fl)
    (c:qsopt "elevfile" "")
  )
  (done_dialog 1)
)

(defun bound_dialog(/ al so_err so_oer version)
  (setvar "CMDECHO" 0)
  (defun so_err (s)
    (if (/= s "Function cancelled")
      (if (= s "quit / exit abort")
        (princ)
        (princ (strcat "\nError: " s))
      )
    )
    (if so_oer        
      (setq *error* so_oer) 
    )
    (princ)
  )
  
  (if *error*                     
    (setq so_oer *error* *error* so_err) 
    (setq *error* so_err) 
  )
  (setq version (substr (getvar "ACADVER") 1 2))

  (if (and (= (getvar "FILEDIA") 1)(= version "12"))
    (progn
      (setq id (load_dialog "qsopts.dcl"))
      (if (new_dialog "boundopts" id)
        (progn
          (setq al (c:qsopt "get" "bmethod"))
          (cond 
            ((= al 1)
              (set_tile "bnd_center" "1")
            )
            ((= al 2)
              (set_tile "bnd_any" "1")
            )
            ((= al 3)
              (set_tile "bnd_all" "1")
            )
          )
          (action_tile "accept" "(boundCB_accept)")
          (action_tile "cancel" "(done_dialog 0)")
          (action_tile "help" "(acad_helpdlg \"qs.hlp\" \"Boundary Configuration\")")
          (setq ret (start_dialog))
        )
      )
    )
    (progn
      (c:qsopt "bmethod")
    )
  )
)

(defun boundCB_accept()
  (if (= (get_tile "bnd_center") "1")
    (c:qsopt "bmethod" 1)
    (progn
      (if (= (get_tile "bnd_any") "1")
        (c:qsopt "bmethod" 2)
        (c:qsopt "bmethod" 3)
      )
    )
  )
  (done_dialog 1)
)

(defun color_dialog( / so_err so_oer version)
  (setvar "CMDECHO" 0)
  (defun so_err (s)
    (if (/= s "Function cancelled")
      (if (= s "quit / exit abort")
        (princ)
        (princ (strcat "\nError: " s))
      )
    )
    (if so_oer        
      (setq *error* so_oer) 
    )
    (princ)
  )
  
  (if *error*                     
    (setq so_oer *error* *error* so_err) 
    (setq *error* so_err) 
  )
  (setq version (substr (getvar "ACADVER") 1 2))

  (if (and (= (getvar "FILEDIA") 1)(= version "12"))
    (progn
      (setq id (load_dialog "qsopts.dcl"))
      (if (new_dialog "selectclr" id)
        (progn
          (action_tile "accept" "(colorCB_accept)")
          (action_tile "cancel" "(done_dialog 0)")
          (action_tile "help" "(acad_helpdlg \"qs.hlp\" \"Color Configuration\")")
          (setq ret (start_dialog))
        )
      )
    )
    (progn
    )
  )
)

(defun colorCB_accept()
  (done_dialog 1)
)

(defun c:gisopts ( / ch ch2 ch3 tmp go_err go_oer)
  (setvar "CMDECHO" 0)

  (defun go_err (s)
    (if (/= s "Function cancelled")
      (if (= s "quit / exit abort")
        (princ)
        (princ (strcat "\nError: " s))
      )
    )
    (if go_oer        
      (setq *error* go_oer) 
    )
    (menucmd "s=")
    (menucmd "s=")
    (princ)
  )
  
  (if *error*                     
    (setq go_oer *error* *error* go_err) 
    (setq *error* go_err) 
  )

  (menucmd "s=QSclr")
  (menucmd "s=GISopt1")
  (setq ch "Symbol")
  (while (/= ch "Cancel")
    (setq ch "Cancel")
    (initget 0 "Quicksurf Dir Symbol Point Window Master Edit Cancel LISt LINe Write Reset")
    (setq tmp (getkword "\nWindow/Symbol/Point/Edit/Master/LINe/Quicksurf <>: "))
    (if tmp (setq ch tmp))
    (if (/= ch "Cancel") 
      (progn
        (cond
          ((= ch "Window")
            (c:qsopt "datawin")
          )
          ((= ch "Quicksurf")
            (c:setopts)
          )
          ((= ch "Edit")
            (c:qsopt "edittab")
          )
          ((= ch "Dir")
            (c:pdir)
          )
          ((= ch "Master")
            (c:mastbl)
          )
          ((= ch "Point")
            (c:qsopt "dtfldx")
            (c:qsopt "dtfldy")
            (c:qsopt "dtfldz")
            (c:qsopt "ptrefch")
            (setq ch2 (c:qsopt "get" "ptrefch"))
            (if (= ch2 1)
              (c:qsopt "ptreftab")
            )
          )
          ((= ch "LINe")
            (c:qsopt "dtfldx")
            (c:qsopt "dtfldy")
            (c:qsopt "pgtable")
            (c:qsopt "pgline")
            (c:qsopt "pgpoint")
            (c:qsopt "pgreftab")
          )
          ((= ch "Symbol")
            (c:qsopt "dtfldx")
            (c:qsopt "dtfldy")
            (c:qsopt "dtfldz")
            (c:qsopt "syfldblk")
            (c:qsopt "sylyrsrc")
            (setq ch2 (c:qsopt "get" "sylyrsrc"))
            (c:qsopt "syblksrc")
            (setq ch3 (c:qsopt "get" "syblksrc"))
            (if (OR (= ch2 1)(= ch3 1))
              (c:qsopt "syreftab")
            )
            (if (= ch2 0)
              (c:qsopt "sylayer")
            )
            (if (= ch3 0)
              (c:qsopt "syscale")
            )
          )
          ((= ch "Write")
            (c:qsopt "write" "?")
          )
          ((= ch "Reset")
            (c:qsopt "reset")
          )
          ((= ch "LISt")
            (c:qsopt "?")
          )
          (T
            (setq ch "Cancel")
          )
        )
      )
    )
    (if (/= ch "Cancel") 
      (setq ch "Symbol")
    )
  )
  (menucmd "s=")
  (menucmd "s=")
  (princ)
)

(princ)




