
name_edit_box: edit_box {
    allow_accept = false;
    edit_width = 12;
}

real_edit_box: name_edit_box {
    edit_limit = 20;
}

num_edit_box: name_edit_box {
    edit_limit = 12;
}

file_name_box: edit_box {
    allow_accept = false;
    edit_width = 30;
}

g_size : boxed_row {
   label = "Cell Size";
   fixed_width = true;
   : column {
      : real_edit_box {
         key   = "grid_size_x";
         label = "X:";
      }
      : real_edit_box {
         key   = "grid_size_y";
         label = "Y:";
      }
      : toggle {
         key = "auto_size";
         label = "Auto";
      }
   }
}

g_count : boxed_row {
   label = "Cell Count";
   fixed_width = true;
   : column {
      : num_edit_box {
         key   = "grid_count_x";
         label = "X:";
      }
      : num_edit_box {
         key   = "grid_count_y";
         label = "Y:";
      }
      : toggle {
         key = "auto_count";
         label = "Auto";
      }
   }
}

grid_dorder : boxed_radio_row {
    label = "Derivatives";
    alignment = top;
    : radio_button {
        key = "dorder_0";
        label = "None";
    }
    : radio_button {
        key = "dorder_1";
        label = "1st";
    }
    : radio_button {
        key = "dorder_2";
        label = "2nd";
    }
}

grid_border : boxed_radio_row {
    label = "Blend order";
    alignment = top;
    : radio_button {
        key = "border_1";
        label = "1st";
    }
    : radio_button {
        key = "border_2";
        label = "2nd";
    }
}

grid_weight : real_edit_box {
    key   = "grid_weight";
    label = "Weighting:";
}

grid_honor : toggle {
    key   = "grid_honor";
    label = "Honor local extrema";
}

grid_rings : num_edit_box {
    key   = "grid_rings";
    label = "Rings:";
}

grid_ttype : boxed_radio_row {
    label = "Trend type";
    fixed_height = true;
    : radio_button {
        key = "ttype_1";
        label = "1st";
    }
    : radio_button {
        key = "ttype_2";
        label = "2nd";
    }
}

grid_torder : boxed_row {
    label = "Trend order";
    fixed_height = true;
    : column {
      : num_edit_box {
         key = "torder_x";
         label = "X:";
      }
      : num_edit_box {
         key = "torder_y";
         label = "Y:";
      }
    }
}

grid_std : boxed_column {
    key = "grid_std";
    grid_dorder;
    grid_border;
    grid_weight;
    grid_honor;
}

grid_trd : boxed_column {
    key = "grid_trd";
    grid_ttype;
    grid_torder;
}

grid_krg: boxed_column {
    key = "grid_krg";
    grid_rings;
}

gridopts : dialog {
    label = "Grid Configuration";

    : row {
        g_size;
        g_count;
        : boxed_row {
            label = "Number of Cells";
            fixed_width = true;
            : column {
               fixed_height = true;
               : num_edit_box {
                  key   = "grid_cellmin";
                  label = "Min:";
               }
               : num_edit_box {
                  key   = "grid_cellmax";
                  label = "Max:";
               }
            }
        }
    }
    : row {
        : real_edit_box {
            fixed_width = true;
            key   = "grid_factor";
            label = "Cell Factor:";
        }

        : real_edit_box {
            fixed_width = true;
            key   = "grid_meshbase";
            label = "Undefined grid value:";
        }
    }
    spacer;
    : boxed_radio_row {
        label = "Grid Method";
        alignment = top;
        fixed_height = true;
        : radio_button {
            key = "grid_standard";
            label = "Standard";
        }
        : radio_button {
            key = "grid_trend";
            label = "Trend";
        }
        : radio_button {
            key = "grid_krige";
            label = "Krige";
        }
    }
    : row {
        grid_std;
        grid_trd;
        grid_krg;
    }
    spacer;
    ok_cancel_help;
}

boundopts : dialog {
    label = "Boundary Configuration";

    : boxed_radio_row {
      label = "Honor boundary method for surfaces";
      alignment = top;
      fixed_height = true;
      : radio_button {
         key = "bnd_center";
         label = "Center";
      }
      : radio_button {
         key = "bnd_any";
         label = "Any point";
      }
      : radio_button {
         key = "bnd_all";
         label = "All points";
      }
    }

    spacer;
    ok_cancel_help;
}

c_method : boxed_radio_row {
    label = "Surface for contouring";
    alignment = top;
    fixed_height = true;
    : radio_button {
       key = "cont_tin";
       label = "TIN";
    }
    : radio_button {
       key = "cont_grid";
       label = "Grid";
    }
    : radio_button {
       key = "cont_tgrd";
       label = "Tgrid";
    }
}

c_interval : boxed_row {
   key = "cont_intslt";
   label = "Interval";
   fixed_width = true;
   : column {
      : toggle {
         key = "auto_int";
         label = "Auto";
      }
      : num_edit_box {
         key   = "cont_interval";
         label = "Interval:";
      }
      : num_edit_box {
         key   = "cont_level";
         label = "Levels:";
      }
   }
}

c_elevfile: file_name_box {
   key = "cont_elevfile";
   label= "Elevation list file:";
}

contouropts : dialog {
    label = "Contour Configuration";

    : column {
       c_method;
       c_interval;
       c_elevfile;
    }
    spacer;
    ok_cancel_help_errtile;
}

f_colpos : boxed_row {
   key   = "file_colpos";
   label = "Data Column Postion";
   fixed_width = true;
   : column {
      : num_edit_box {
         key   = "file_colpos_x";
         label = "X:";
      }
      : num_edit_box {
         key   = "file_colpos_y";
         label = "Y:";
      }
      : num_edit_box {
         key   = "file_colpos_z";
         label = "Z:";
      }
   }
}

f_scalefac : boxed_row {
   key   = "file_scl";
   label = "Scale Factors";
   fixed_width = true;
   : column {
      : real_edit_box {
         key   = "file_scl_x";
         label = "X:";
      }
      : real_edit_box {
         key   = "file_scl_y";
         label = "Y:";
      }
      : real_edit_box {
         key   = "file_scl_z";
         label = "Z:";
      }
   }
}

f_pntfile: file_name_box {
   key = "file_fname";
   label= "ASCII File:";
}

fileopts : dialog {
    label = "File Controls";

    : column {
       f_pntfile;
       f_colpos;
       f_scalefac;
    }
    spacer;
    ok_cancel_help_errtile;
}

d_drbase : boxed_radio_row {
    label = "Surface for draping";
    alignment = top;
    fixed_height = true;
    : radio_button {
       key = "drape_tin";
       label = "TIN";
    }
    : radio_button {
       key = "drape_grid";
       label = "Grid";
    }
    : radio_button {
       key = "drape_tgrd";
       label = "Tgrid";
    }
}

d_drorder : boxed_radio_row {
    key = "drape_order";
    label = "Drape Order";
    alignment = top;
    fixed_height = true;
    : radio_button {
       key = "drape_order_1";
       label = "1st";
    }
    : radio_button {
       key = "drape_order_3";
       label = "3rd";
    }
}

d_drstep:boxed_row {
   label= "Drape Step";
   : real_edit_box {
      key = "drape_step";
      label= "Size:";
   }
   : toggle {
      key = "auto_dstep";
      label = "Auto";
   }
}

drapeopts : dialog {
    label = "Drape Configuration";

    : column {
       d_drbase;
       d_drorder;
       d_drstep;
    }
    spacer;
    ok_cancel_help;
}

e_rough : toggle {
    key   = "ext_rough";
    label = "Extract only frame points";
}

e_npmax: real_edit_box {
   key = "ext_npmax";
   label= "Maximum number of points:";
}

extractopts : dialog {
    label = "Extract Configuration";

    : column {
       e_rough;
       e_npmax;
    }
    spacer;
    ok_cancel_help;
}

b_brkstep : boxed_row {
   label = "Break line step";
   fixed_width = true;
   : real_edit_box {
      key = "brk_step";
      label = "Size:";
   }
   : toggle {
      key = "auto_bstep";
      label = "Auto";
   }
}

b_brkcrv : boxed_row {
   label = "Break line curves";
   : real_edit_box {
      key = "brk_crverr";
      label = "Error:";
   }
   : toggle {
      key = "auto_cerr";
      label = "Auto";
   }
}

breakopts : dialog {
    label = "Break Line Configuration";

    : column {
       b_brkstep;
       b_brkcrv;
    }
    spacer;
    ok_cancel_help;
}

selectclr : dialog {
    label = "Select Color";
    key = "chroma";
    std_rq_color;
}
