;&k2S&l8D
;
; QuickSurf AutoLISP Utility Version 4.0
;
; (c) Copyright 1991 Schreiber Instruments, Inc.
; All rights reserved.

(prompt "\nLoading lisp, Please Wait...")

(defun enter ()
	(gc)
	(setq
		cecho (getvar "cmdecho")
		cblip (getvar "blipmode")
		clay (getvar "clayer")
		ccol (getvar "cecolor")
		cgri (getvar "gridmode")
		hilite (getvar "highlight"))
	(setvar "blipmode" 0)
	(setvar "cmdecho" 0)
	(setvar "gridmode" 0))

(defun leave ( / tem)
	(command
		".layer" "s" clay ""
		".color" (if (< 0 (setq tem (atoi ccol))) tem ccol))
	(setvar "cmdecho" cecho)
	(setvar "blipmode" cblip)
	(setvar "highlight" hilite)
	(setvar "gridmode" cgri) (princ))

(defun c:delev ( / e elev1 elev2)
  (enter)
  (setq e 't)
  (while e
    (setq e (car (entsel "\nSelect object: ")))
   	  (if e
   	  (progn
        (setq 
          e     (entget e) 
          elev1 (nth 3 (assoc 10 e))
          elev2 nil
        )
        (if (or (= (cdr (assoc 0 e)) "LINE")
              (= (cdr (assoc 0 e)) "3DLINE"))
          (setq elev2 (nth 3 (assoc 11 e)))
        )
        (if (or (= elev1 elev2)(= elev2 nil))
          (prompt (strcat (rtos elev1 2 2) " "))
          (prompt (strcat (rtos elev1 2 2) " " " to " (rtos elev2 2 2) " "))
        )
      )
    )
  )
  (setq e nil elev1 nil elev2 nil)
	(leave)
  (princ)
)

(defun c:celev ( / ss ent nelev ename i obj entx entpnt enty entz cnt)
  (enter)
  (prompt "\nSelect objects to change elevation")
  (menucmd "s=select")
  (setq ss (ssget))
  (menucmd "s=")
  (if ss
    (progn
      (setq ename (car (entsel "\nSelect object with desired elevation or <Enter>: ")))
      (if (/= ename nil)
        (progn
          (setq 
            ent (entget ename)
            nelev (nth 3 (assoc 10 ent))
          )
        )
        (progn
          (setq nelev nil)
          (setq nelev (getdist "\nNew elevation: "))
        )
      )
      (if (/= nelev nil)
 	      (progn
          (setq cnt (sslength ss) i 0)
          (while (< i cnt)
            (setq 
              obj (ssname ss i)
              entpnt (cdr (assoc 10 (entget obj)))
              entx (car entpnt)
              enty (cadr entpnt)
              entz (caddr entpnt)
            )
            (command "Move" obj "" (list entx enty entz) (list entx enty nelev) )
            (setq i (+ i 1))
          )
        )
        (prompt (strcat "\n" (rtos (sslength ss) 2 0) " objects elevated to " (rtos nelev 4 8)))
      )
    )
  )
  (graphscr)
	(leave)
  (princ)
)

(defun c:esel ( / )
  (enter)

  (defun eaerr (s)

    (if (/= s "Function cancelled")
        (princ (strcat "\nError: " s))
    )
    (setq *error*  olderr)
	  (leave)
    (setq
          objset nil erset nil objlen nil
          i      nil ent   nil objent nil
          etype  nil lname nil #er    nil
          bname  nil
    )
    (princ)
  )
  (setq olderr *error* *error* eaerr)

  (setq 
    objset (ssadd)
    erset (ssadd)
    objset (ssget)
    objlen (sslength objset)
    i     0
  )
  (while (< i objlen)
    (setq 
          ent    (ssname objset i)
          objent (entget ent)
    )
    (setq etype (cdr (assoc 0 objent)))
    (setq lname (cdr (assoc 8 objent)))
    (setq bname (cdr (assoc 2 objent)))
    (if (or (/= etype nil)(/= lname nil))
      (progn
        (cond
          ((= etype "INSERT")
            (setq erset (ssget "x" (list (cons 2 bname)(cons 8 lname))))
            (setq #er   (itoa (sslength erset)))
            (prompt (strcat "\nErasing "#er" "bname"'S from layer " lname))
            (command "erase" "multiple" erset "")
          )
          (T
            (setq erset (ssget "x" (list (cons 0 etype)(cons 8 lname))))
            (setq #er   (itoa (sslength erset)))
            (prompt (strcat "\nErasing "#er" "etype"'S from layer " lname))
            (command "erase" "multiple" erset "")
          )
        )
      )
    )
    (setq i (+ i 1))
  )
  (setq
      objset nil erset nil objlen nil
      i      nil ent   nil objent nil
      etype  nil lname nil #er    nil
      bname  nil
  )
	(leave)
  (graphscr)
  (princ)
)

(princ)

;E
