;&k2S&l8D
;
; QuickSurf AutoLISP Utility Version 4.0
;
; (c) Copyright 1991 Schreiber Instruments, Inc.
; All rights reserved.

(prompt "\nLoading lisp, Please Wait...")

(defun enter ()
	(gc)
	(setq
		cecho (getvar "cmdecho")
		cblip (getvar "blipmode")
		clay (getvar "clayer")
		ccol (getvar "cecolor")
		cgri (getvar "gridmode")
		hilite (getvar "highlight"))
	(setvar "blipmode" 0)
	(setvar "cmdecho" 0)
	(setvar "gridmode" 0))

(defun leave ( / tem)
	(command
		".layer" "s" clay ""
		".color" (if (< 0 (setq tem (atoi ccol))) tem ccol))
	(setvar "cmdecho" cecho)
	(setvar "blipmode" cblip)
	(setvar "highlight" hilite)
	(setvar "gridmode" cgri) (princ))

(defun next (ent) (if (setq ent (entnext (ename ent))) (entget ent) nil))

(defun square (x) (* x x))

(defun vlen (a b) (sqrt (+ (square (- (car a) (car b)))
		(square (- (cadr a) (cadr b))))))

(defun getall ( / ss)
	(prompt "\nRETURN to select all or")
	(setq
		ss (ssget)
		ss (if ss ss (ssget "c" (getvar "vsmin")
				(getvar "vsmax"))))
	(setq n (if ss (sslength ss) 0)) ; Side effect !!!
	ss)

(defun sthigh (p / tem)
	(if (not fixhi) (setq
		thigh (if thigh thigh 0.2)
		tem (initget 6)
		tem (getdist p (strcat "\nText height <" (rtos thigh) ">: "))
		thigh (if tem tem thigh))
	(setq thigh fixhi)))

(defun elev (ent / tem) (if (setq tem (cdr (assoc 38 ent))) tem
		(if (setq tem (caddr (epoint ent))) tem 0.0)))

(defun ran ()
	(setq seed (if seed (rem (+ (* seed 15625.7) 0.21137152) 1) 0.3171943)))

(setq seed nil)

(defun etyp (ent) (cdr (assoc 0 ent)))

(defun ename (ent) (cdr (assoc -1 ent)))

(defun epoint (ent) (cdr (assoc 10 ent)))

(defun epnt1 (ent) (cdr (assoc 11 ent)))

(defun eflags (ent) (cdr (assoc 70 ent)))

(defun band (a b) (boole 1 a b))

(defun c:gen ( / n x0 y0 dx dy dz r x y)
	(enter)
	(setvar "blipmode" 1)
	(if nil ;(setq y0 (getvar "vsmin"))
		(setq
			y1 (getvar "vsmax")
			dx (* 0.45 (- (car y1) (car y0)))
			dy (* 0.45 (- (cadr y1) (cadr y0)))
			x0 (* 0.5 (+ (car y1) (car y0)))
			y0 (* 0.5 (+ (cadr y1) (cadr y0))))
		(setq
			y0 (getvar "viewctr")
			x0 (car y0)
			y0 (cadr y0)
			dy (* 0.45 (getvar "viewsize"))
			dx (getvar "screensize")
			dx (* dy (/ (car dx) (cadr dx)))))
	(initget 4)
	(setq
		dz (* 0.5 (+ dx dy))
		x 0 y 0
		n (getint "\nNumber of points <100>: ")
		n (if n n 100))
	(while (> n 0)
		(setq n (1- n) r (* 12 (sqrt (+ (* x x) (* y y)))))
		(command ".point" (list
			(+ x0 (* dx x)) (+ y0 (* dy y))
			(if (zerop r) dz (* dz (/ (sin r) r)))))
		(setq x (1- (* 2 (ran))) y (1- (* 2 (ran)))))
	(leave))

(defun pstin (p / tem)
	(setq tem (getvar "elevation"))
	(setvar "elevation" (if (caddr p) (caddr p) 0.0)) 
	(setq
		pt (getpoint p "\nText position: ")
		pt (if pt pt p))
	(sthigh pt)
	(setvar "elevation" tem)
	(setq
		tangle (getangle pt "\nText angle <0>: ")
		tangle (if tangle tangle 0)
		pt (list (- (car pt) (car p)) (- (cadr pt) (cadr p)))
		talign (+ (* (cos tangle) (car pt)) (* (sin tangle) (cadr pt)))
		talign (if (< talign 0) "R" "L")
		tangle (* (/ 180 pi) tangle)
		tem "")
	(while (not (member tem (list "L" "C" "M" "R"))) (setq
		tem (getstring (strcat "\nAlign (Left/Center/Middle/Right) <"
			talign ">: "))
		tem (if (/= "" tem) (strcase (substr tem 1 1)) talign)))
	(setq talign (if (= "L" tem) nil tem)))

(defun c:label ( / fixhi p qlist r n ent entnm hilite)
	(enter)
	(udset)
	(setq
		fixhi (txhi)
		p nil
		qlist (list)
		r (* 0.01 (getvar "viewsize")) n 0)
	(while (setq ent (getpoint "\nLabel location: "))
		(setq
			p ent
			qlist (cons p qlist)
			n (1+ n))
		(command ".circle" p r))
	(if p (progn
		(command ".undo" n)
		(sthigh p)
		(while (car qlist)
			(setq ent (ssget (setq p (car qlist))))
			(if ent (progn
				(setq ent (entget (setq entnm (ssname ent 0))))
				(if (= "POLYLINE" (etyp ent))
					(labler (list entnm p)))))
			(setq qlist (cdr qlist)))))
	(udres)
	(leave))

(defun c:smoo ( / ss n i ent entnm)
	(enter)
	(if (not howsmooth) (setq howsmooth "s"))
	(setq ss (getall) i 0)
	(while (< i n)
		(if (and (= "POLYLINE" (etyp (setq ent (entget
				(setq entnm (ssname ss i))))))
			(zerop (band 80 (eflags ent))))
			(command ".pedit" entnm howsmooth ""))
		(setq i (1+ i)))
	(leave))

(defun ticker (ent / dpat closed inner x0 y0 x1 y1 r dx dy dd dline
		alfa beta xc yc a1 a2 da da0 rd dx0 dy0 dxd dyd x y z p0)
	(command ".layer" "s" (cdr (assoc 8 ent)) ""
		".color" (if (setq x1 (assoc 62 ent)) (cdr x1) "bylayer"))
	(setq
		z (elev ent)
		dpat (* 0.5 tikdst)
		closed (= 1 (band 1 (eflags ent)))
		e0 (next ent))
	(while (and (= "VERTEX" (etyp e0))
		(= 16 (band 16 (eflags e0)))) (setq e0 (next e0)))
	(setq
		r (assoc 42 e0)
		p0 (epoint e0) x0 (car p0) y0 (cadr p0)
		closed (if closed e0 nil))
	(while (= "VERTEX" (etyp (setq e0 (next e0))))
		(if (zerop (band 16 (eflags e0)))
			(tickto (epoint e0))))
	(if closed (tickto (epoint closed))))

(defun tickto (p / pa pb)
	(setq 
		x1 (car p)
		y1 (cadr p)
		dx (- x1 x0)
		dy (- y1 y0)
		dline (sqrt (+ (* dx dx) (* dy dy)))
		dd (if (zerop dline) 1 dline)
		r (cdr r)
		r (if (zerop r) nil r))
	(if r
		(setq
			alfa (atan r)
			r (/ (* r dd 0.25) (square (sin alfa)))
			beta (- (+ (atan dy dx) (* 0.5 pi)) (+ alfa alfa))
			xc (+ x0 (* r (cos beta)))
			yc (+ y0 (* r (sin beta)))
			a1 (- beta pi)
			a2 (+ a1 (* 4 alfa))
			da (/ tikdst r)
			da0 (/ dpat r)
			r0 (if (= "C" tikhow) (+ r tl) r)
			rd (- r tl)
			dline (* r (- a2 a1)))
		(setq
			dx (/ dx dd)
			dy (/ dy dd)
			dx0 (* dx dpat)
			dy0 (* dy dpat)
			dxd (- (* dy tl))
			dyd (* dx tl)
			dx (* dx tikdst)
			dy (* dy tikdst)))
	(while (< dpat dline)
		(if r
			(setq 
				a1 (+ a1 da0)
				da0 da
				x (cos a1)
				y (sin a1)
				x0 (+ xc (* r x))
				y0 (+ yc (* r y))
				pa (if (= "C" tikhow)
					(list (+ xc (* r0 x)) (+ yc (* r0 y)) z)
					(list x0 y0 z))
				pb (list (+ xc (* rd x)) (+ yc (* rd y)) z))
			(setq
				x0 (+ x0 dx0)
				y0 (+ y0 dy0)
				dx0 dx
				dy0 dy
				pb (list (+ x0 dxd) (+ y0 dyd) z)
				pa (if (= "C" tikhow)
					(list (- x0 dxd) (- y0 dyd) z)
					(list x0 y0 z))))
		(command ".line" pa pb "")
		(setq dline (- dline dpat) dpat tikdst))
		(setq dpat (- dpat dline) x0 x1 y0 y1 r (assoc 42 e0)))

(defun c:tick ( / ss n i p ent e0 tl)
	(enter)
	(setq ss (ssget) n (if ss (sslength ss) 0) i (1- n) p nil)
	(while (and (<= 0 i) (not p))
		(if (and (= "POLYLINE" (etyp (setq ent
				(entget (ssname ss i)))))
			(zerop (band 80 (eflags ent)))) (progn
			(setq ent (next ent))
			(while (= 16 (band 16 (eflags ent)))
				(setq ent (next ent)))
			(setq p (epoint ent) p (list (car p) (cadr p)))))
		(setq i (1- i)))
	(if p (progn
		(setq tikhow (if tikhow tikhow "D"))
		(while (not (member i (list "U" "C" "D")))
			(setq
				i (getstring (strcat
					"\nUpward/Center/Downward <"
					tikhow ">: "))
				i (if (= "" i) tikhow
					(strcase (substr i 1 1)))))
		(initget 6)
		(setq
			tikhow i
			tikdst (if tikdst tikdst 0.25)
			tiklen (if tiklen tiklen 0.0625)
			i (getdist p (strcat "\nDistance between ticks <"
				(rtos tikdst) ">: "))
			tikdst (if i i tikdst))
		(initget 4)
		(setq
			i (getdist p (strcat "\nLength of ticks <"
				(rtos tiklen) ">: "))
			tiklen (if i i tiklen)
			tl (if (= "D" tikhow) tiklen (if (= "U" tikhow)
				(- tiklen) (* 0.5 tiklen)))
			i 0)
		(while (< i n)
			(if (and (= "POLYLINE" (etyp (setq ent (entget
				(ssname ss i)))))
			(zerop (band 80 (eflags ent))))
				(ticker ent))
			(setq i (1+ i))))
	(prompt "\nNo contours found"))
	(leave))

(defun c:post ( / ss n i pt p ent z tem)
	(enter)
	(setq ss (getall) pt nil fixhi (txhi)
		postlist (if postlist postlist (list "POINT" "SHAPE" "INSERT")))
	(while (< 0 n)
		(if (member (etyp (setq ent (entget
			(ssname ss (setq n (1- n)))))) postlist) (progn
				(setq p (epoint ent)
					z (elev ent))
				(if (not pt) (pstin p))
				(command "text")
				(if talign (command talign))
				(command (list (+ (car p) (car pt))
					(+ (cadr p) (cadr pt)) z))
				(if (not fixhi) (command thigh))
				(command tangle (labfrm z)))))
	(leave))

(defun arc2l (ent / r a x0 y0 x1 y1)
	(if (= "ARC" (etyp ent))
		(setq
			r (cdr (assoc 40 ent))
			a (cdr (assoc 50 ent))
			x0 (+ (car (epoint ent)) (* r (cos a)))
			y0 (+ (cadr (epoint ent)) (* r (sin a)))
			a (cdr (assoc 51 ent))
			x1 (+ (car (epoint ent)) (* r (cos a)))
			y1 (+ (cadr (epoint ent)) (* r (sin a)))
			ent
	(subst (list 10 x0 y0) (assoc 10 ent)
		(subst (list 11 x1 y1) (assoc 50 ent)
			(subst (cons 0 "LINE") (cons 0 "ARC") ent)))) ent))

(defun txhi ( / tem) (setq
	tem (cdr (assoc 40 (tblsearch "style" (getvar "textstyle"))))
	tem (if (zerop tem) nil tem)))

(defun howu ( / w blip)
	(setq blip (getvar (setq w "blipmode")))
	(command ".setvar" w (- 1 blip) ".setvar" "" blip ".undo" "")
	(if (= blip (getvar w)) (progn (command ".undo" "c" "n") 0)
		 (progn (command ".undo" "")
			(if (= blip (getvar w)) nil
				(progn (setvar w blip) 1)))))

(defun udset () (if (and (setq undo (howu)) (zerop undo))
	(command ".undo" "a") (command ".undo" "c" "a")))

(defun udres () (if undo (command ".undo" "c" (if (zerop undo) "n" "o"))))

(defun labfrm (x / i j l) 
	(setq x (rtos x) l (strlen x) i 1)
	(while (< i l) (if (= "." (substr x i 1)) (progn
		(while (and (>= (setq j (substr x (setq i (1+ i)) 1)) "0")
			(<= j "9")))
		(setq j i)
		(while (= "0" (substr x (setq i (1- i)) 1)))
		(if (= "." (substr x i 1)) (setq i (1- i)))
		(setq x (strcat (substr x 1 i) (substr x j)) l 0))
	(setq i (1+ i))))
	(if (and (> (setq l (strlen x)) 4) (= "E" (substr x (- l 3) 1)))
		(if (= "00" (substr x (1- l)))
			(substr x 1 (- l 4))
			(if (= "0" (substr x (1- l) 1))
		(strcat (substr x 1 (- l 2)) (substr x l)) x)) x))

(defun labler (es /
	tem ent entnm p ele elet entc ne1 e1 e2 llast p1 p2 r r1 r2 closed p11)
	(if (and (= "POLYLINE" (etyp (setq ent (entget (car es)))))
		(zerop (band 88 (eflags ent)))) (progn
		(command
			".undo" "g"
			".layer" "s" (cdr (assoc 8 ent)) ""
			".color" (if (setq tem (assoc 62 ent))
				(cdr tem) "bylayer"))
		(setq
			p (cadr es)
			ele (elev ent)
			p (list (car p) (cadr p) ele)
			elet (labfrm ele)
			r (* 0.5 thigh (strlen elet))
			closed (= 1 (band 1 (eflags ent))))
		(command
			".circle" p r
			".trim" "l" "" es "")
		(setq
			r (* 0.99 r)
			entc (entget (ssname (ssget "p") 0))
			e1 (next entc)
			e2 (entget (ssname (ssget "l") 0))
			e2 (if (and e1 (not (equal e1 e2))) e2 nil)
			llast nil)
		(if e1 (progn
			(setq
				ne1 (ename e1)
				p1 (epoint (arc2l (next e1))))
			(command ".undo" "m" ".explode" ne1)
			(setq llast (arc2l (entget (ssname (ssget "l") 0))))
			(command ".undo" "b")
			(setq
				p2 (epnt1 llast)
				r1 (vlen p p1)
				r2 (vlen p p2))))
		(cond (e2 (progn
				(setq
					p1 (epnt1 llast)
					p2 (epoint (arc2l (next e2))))
				(if closed
					(command
			;	".move" ne1 "" (list 0 0 ele) "0,0,0"
				".pedit"  ne1 "j" (ename e2) "" ""
			;	".move" "l" "" "0,0,0" (list 0 0 ele)
				))))
			((not e1) (progn
				(command ".erase" (ename ent) "")
				(setq
					p1 (list (+ (car p) 1.0) (cadr p))
					p2 p1)))
			((< r2 r) (progn
				(command ".trim" (ename entc) "" p2 "")
				(setq e1 (entget (ssname (ssget "l") 0)))
				(command ".undo" "m" ".explode" "l")
				(setq
					llast (arc2l (entget (ssname
						(ssget "l") 0)))
					p2 (epnt1 llast))
				(command ".undo" "b")))
			((< r1 r) (progn
				(setq
					p11 (epoint (arc2l (next e1))))
				(while (> (vlen p p11) r) (setq p11 (list
					(* 0.5 (+ (car p1) (car p11)))
					(* 0.5 (+ (cadr p1) (cadr p11))))))
				(command ".trim" (ename entc) "" p11 "")
				(setq
					e1 (entget (ssname (ssget "l") 0))
					p1 (epoint (arc2l (next e1))))))
			((< r1 r2) (progn
				(setq p2 (list
					(- (* 2 (car p)) (car p1))
					(- (* 2 (cadr p)) (cadr p1))))))
			((< r2 r1) (progn
				(setq p1 (list
					(- (* 2 (car p)) (car p2))
					(- (* 2 (cadr p)) (cadr p2)))))))
		(command ".erase" (ename entc) "")
		(if p1 (progn
			(if (> (car p1) (car p2)) (setq tem p2 p2 p1 p1 tem))
			(setq p2 (list
				(+ (car p) (- (car p2) (car p1)))
				(+ (cadr p) (- (cadr p2) (cadr p1)))))
			(if fixhi (command ".text" "m" p p2 elet)
			(command ".text" "m" p thigh p2 elet))))
		(command ".undo" "e"))))

(defun iindex ( / ss n i last dz tem ent)
	(setq ss (ssget "x" (list (cons 0 "POLYLINE")))
		n (if ss (sslength ss) 0)
		i 0 last nil dz nil tem nil)
	(while (and  (> n i) (not dz))
		(if (zerop (band 88 (eflags (setq ent (entget
				(ssname ss i))))))
			(if (not last) (setq last (elev ent))
				(progn (setq
			dz (- last (elev ent))
			dz (if (> dz 0) dz nil))
				(if dz (progn
					(setq tem dz)
				(while (>= tem 10) (setq tem (/ tem 10.0)))
				(while (< tem 1) (setq tem (* tem 10)))
				(setq tem (if (<= tem 2) 5 4)
					dz (* tem dz)))))))
		(setq i (1+ i))) dz)

(defun c:index ( / ent entnm del tem layer ss n indexi)
	(enter)
	(initget 6)
	(setq
		indexi (iindex)
		indexi (if indexi indexi 1)
		tem (getdist (strcat "\nIndex interval <" (rtos indexi)
			">: "))
		indexi (if tem tem indexi)
		del (* indexi 0.000000001)
		layer (getstring "\nIndex layer <unchanged>: ")
		layer (if (= layer "") nil layer)
		index (if index index 0.03125)
		ss (getdist (strcat "\nIndex width <" (rtos index) ">: "))
		index (if ss ss index)
		ss (getall))
	(if layer (command ".layer" "m" layer "t" layer "on" layer ""))
	(while (> n 0)
		(if (and
	(= "POLYLINE" (etyp (setq ent (entget (setq entnm (ssname ss
			(setq n (1- n))))))))
	(zerop (band 88 (eflags ent))))
			(if (> (+ del del)
					(rem (+ (abs (elev ent)) del) indexi))
				(progn
		(if layer (command ".change" entnm "" "p" "la" layer ""))
		(command ".pedit" entnm "w" index ""))
				(if (zerop (cdr (assoc 40 ent))) nil
		(command ".pedit" entnm "w" 0 "")))))
	(leave))

(defun c:tilt ( / ss p )
	(enter)
	(setq p (list (getvar "vpointx")
		(getvar "vpointy") (getvar "vpointz")))
	(if (not (car p)) (setq p (getvar "viewdir")))
	(if (and (zerop (car p)) (zerop (cadr p)))
		(prompt "\nCan't tilt from plan view - go to a VPOINT\n")
	(if (setq ss (ssget)) (progn
		(enter)
		(if (not (tblsearch "block" "__TILT__"))
			(command ".block" "__TILT__" "0,0" ""))
		(setq untilt p)
		(command
			".ucs" "v"
			".block" "__TILT__" "y" "0,0,0" ss ""
			".ucs" "w"
			".vpoint" "0,0,1"
			".insert" "__TILT__" "0,0,0" "" "" ""
			".zoom" "e"
			".explode" "l")))) (leave))
	
(defun c:untilt ( / ss n)
	(if untilt
		(if (setq ss (ssget)) (progn
		(enter)
		(setq
			xv (car untilt)
			yv (cadr untilt)
			zv (caddr untilt))
		(command ".vpoint" (list
			0 (sqrt (+ (* xv xv) (* yv yv))) zv)
			".ucs" "v"
			".block" "__TILT__" "y" "0,0,0" ss ""
			".ucs" "w"
			".vpoint" "0,0,1"
			".insert" "__TILT__" "0,0,0" "" ""
				(- (* (/ (atan yv xv) pi) 180) 90)
			".zoom" "e"
			".explode" "l") (leave)))
	(prompt "\nNo prevous tilt\n")) (princ))
	
(defun mapp (p / i k sumx sumy yf j fac)
	(setq i 0 k 0 sumx 0 sumy 0 yf 1)
	(while (< i m)
		(setq j 0 fac yf)
		(while (< j n)
			(setq
				sumx (+ sumx (* fac (nth k a)))
				sumy (+ sumy (* fac (nth k b)))
				fac (* fac (cadr p))
				j (1+ j) k (1+ k)))
			(setq yf (* yf (caddr p)) i (1+ i)))
	(if (cadddr p) (list (car p) sumx sumy (* zf (cadddr p)))
		(list (car p) sumx sumy)))

(defun mapcal (a / n l p q i j rp ri ro)
	(setq l -1 det 1 n (length a))
	(while (< (setq l (1+ l)) n)
		(setq p (abs (cadr (nth l a))) j l i (1+ l))
		(while (< i n)
			(if (> (setq q (abs (cadr (nth i a)))) p)
				(setq p q j i))
			(setq i (1+ i)))
		(if (/= j l) (setq
			det (- det)
			ri (cons j (cdr (nth l a)))
			ro (cons l (cdr (nth j a)))
			a (subst ri (assoc j a) (subst ro (assoc l a) a))))
		(setq ri (nth l a) p (cadr ri) rp (list l) j 1 det (* det p))
		(while (setq q (nth (setq j (1+ j)) ri))
			(setq rp (append rp (list (/ q p)))))
		(setq a (subst rp ri a) i l)
		(while (< (setq i (1+ i)) n)
			(setq ri (nth i a) ro (list i) j 1 q (cadr ri))
			(while (setq x (nth (setq j (1+ j)) ri))
				(setq ro (append ro (list (- x
					(* q (nth (1- j) rp)))))))
			(setq a (subst ro ri a))))
	(setq l n ro (list) i 0)
	(while (> l 0)
		(setq l (1- l) i (1+ i) ri (nth l a) p (nth i ri) j 1)
		(while (< j i) (setq
			p (- p (* (nth (1- j) ro) (nth j ri))) j (1+ j)))
		(setq ro (append (list p) ro))))

(defun c:map ( / m n mn a b k l p row yf fac i j po zf ss np enm ent e0 det pn)
	(enter) (udset)
	(command ".undo" "g")
	(setq
		m (getint "\nRows <2>: ") m (if m m 2)
		n (if (zerop m) 0
			(getint (strcat "\nColumns <" (itoa m) ">: ")))
		n (if n n m)
		mn (* m n) pn (list)
		a (list) k 0)
	(while (< k m)
		(setq l 0)
		(while (< l n)
			(initget 1)
			(setq 
				p (getpoint (strcat "\nFrom point "
		(itoa k) "," (itoa l) ": "))
				pn (append pn (list p))
				i 0 row (list (+ l (* k n))) yf 1)
			(while (< i m)
				(setq j 0 fac yf)
				(while (< j n)
					(setq row (append row (list fac))
						fac (* fac (car p))
						j (1+ j)))
				(setq i (1+ i) yf (* yf (cadr p))))
			(setq a (append a (list row)) l (1+ l)))
		(setq k (1+ k)))
	(setq k 0 i 0 b a po (list))
	(while (< k m)
		(setq l 0)
		(while (< l n)
			(initget 1)
			(setq 
				p (getpoint (strcat "\nTo point "
		(itoa k) "," (itoa l) ": "))
				po (append po (list p))
				row (nth i a)
				a (subst (append row (list (car p))) row a)
				b (subst (append row (list (cadr p))) row b)
				l (1+ l) i (1+ i)))
		(setq k (1+ k)))
	(prompt "\nWait ...")
	(setq
		a (mapcal a)
		b (mapcal b)
		l (getvar "lunits"))
	(if (or (zerop m) (zerop n))
		(setq a (list 0 1 0 0) b (list 0 0 1 0) m 2 n 2))
	(if (= 1 m) (progn
		(setq j n i (list))
		(while (> j 1) (setq  j (1- j) i (append i (list 0))))
		(setq m 2
			a (append a (append (list 0) i))
			b (append b (append (list 1) i)))))
	(if (= 1 n) (progn
		(setq j 0 i (list))
		(while (< j m)
			(setq i (append i (list (nth j a)
				(if (zerop j) 1 0))) j (1+ j)))
		(setq a i j 0 i (list))
		(while (< j m)
			(setq i (append i (list (nth j b) 0)) j (1+ j)))
		(setq b i n 2)))
	(setvar "lunits" 1)
	(setvar "lunits" l)
	(setq
		zf (getreal "\nZ scale factor <1>: ")
		zf (if zf zf 1)
		tem n
		ss (getall)
		np n n tem)
	(prompt "\nWait ...")
	(while (> np 0)
		(setq np (1- np)
			enm (ssname ss np)
			ent (entget enm))
		(if (= "POLYLINE" (cdr (assoc 0 ent))) (progn
			(setq e0 ent)
			(while (= "VERTEX" (cdr (assoc 0 (setq e0
	(entget (entnext (cdr (assoc -1 e0))))))))
				(setq p (assoc 10 e0))
				(entmod (subst (mapp p) p e0)))
			(setq p (assoc 10 ent))
			(entmod (subst (mapp p) p ent))
			(entupd (cdr (assoc -1 ent))))
		(progn
			(setq k 9)
			(while (setq p (assoc (setq k (1+ k)) ent))
				(setq ent (subst (mapp p) p ent)))
				(entmod ent))))
	(command ".regen" ".undo" "e") (udres) (leave))

(defun c:unwrap ( / zc ss n enm ent e0 tem p k)
	(enter) (udset)
	(command ".undo" "g")
	(setq
		zc (getpoint "Center <0,0,0>: ")
		zc (if zc (if (caddr zc) zc (list (car zc) (cadr zc) 0))
			(list 0 0 0))
		ss (getall))
	(prompt "\nWait ...")
	(while (> n 0)
		(setq n (1- n)
			enm (ssname ss n)
			ent (entget enm))
		(if (= "POLYLINE" (cdr (assoc 0 ent))) (progn
			(setq e0 ent)
			(if (zerop (band 88 (cdr (assoc 70 ent)))) (progn
	(command ".layer" "s" (cdr (assoc 8 ent)) ""
		".color" (if (setq tem (assoc 62 ent)) (cdr tem) "bylayer")
		".3dpoly")
	(setq z (cadddr (assoc 10 ent)))
	(while (= "VERTEX" (cdr (assoc 0 (setq e0
		(entget (entnext (cdr (assoc -1 e0))))))))
		(if (zerop (band 8 (cdr (assoc 70 e0)))) (progn
			(setq p (assoc 10 e0))
			(command (cdr (mapuw (list 0 (cadr p) (caddr p) z)))))))
	(command (if (zerop (band 1 (cdr (assoc 70 ent)))) "" "c")
		".erase" enm ""))	
			(while (= "VERTEX" (cdr (assoc 0 (setq e0
	(entget (entnext (cdr (assoc -1 e0))))))))
				(setq p (assoc 10 e0))
				(entmod (subst (mapuw p) p e0))))
			(entupd (cdr (assoc -1 ent))))
		(progn
			(setq k 9)
			(while (setq p (assoc (setq k (1+ k)) ent))
				(setq ent (subst (mapuw p) p ent)))
				(entmod ent))))
	(command ".regen" ".undo" "e") (udres) (leave))

(defun c:wrap ( / zc ss n enm ent e0 tem p k)
	(enter) (udset)
	(command ".undo" "g")
	(setq
		zc (getpoint "Center <0,0,0>: ")
		zc (if zc (if (caddr zc) zc (list (car zc) (cadr zc) 0))
			(list 0 0 0))
		ss (getall))
	(prompt "\nWait ...")
	(while (> n 0)
		(setq n (1- n)
			enm (ssname ss n)
			ent (entget enm))
		(if (= "POLYLINE" (cdr (assoc 0 ent))) (progn
			(setq e0 ent)
			(if (zerop (band 88 (cdr (assoc 70 ent)))) (progn
	(command ".layer" "s" (cdr (assoc 8 ent)) ""
		".color" (if (setq tem (assoc 62 ent)) (cdr tem) "bylayer")
		".3dpoly")
	(setq z (cadddr (assoc 10 ent)))
	(while (= "VERTEX" (cdr (assoc 0 (setq e0
		(entget (entnext (cdr (assoc -1 e0))))))))
		(if (zerop (band 16 (cdr (assoc 70 e0)))) (progn
			(setq p (assoc 10 e0))
			(command (cdr (mapw (list 0 (cadr p) (caddr p) z)))))))
	(command (if (zerop (band 1 (cdr (assoc 70 ent)))) "" "c")
		"erase" enm ""))	
			(while (= "VERTEX" (cdr (assoc 0 (setq e0
	(entget (entnext (cdr (assoc -1 e0))))))))
				(setq p (assoc 10 e0))
				(entmod (subst (mapw p) p e0))))
			(entupd (cdr (assoc -1 ent))))
		(progn
			(setq k 9)
			(while (setq p (assoc (setq k (1+ k)) ent))
				(setq ent (subst (mapw p) p ent)))
				(entmod ent))))
	(command ".regen" ".undo" "e") (udres) (leave))

(defun mapw (p / x y z th ph cph)
	(setq
		x (- (cadr p) (car zc))
		y (- (caddr p) (cadr zc))
		z (- (if (setq z (cadddr p)) z 0) (caddr zc))
		p (cons (car p) (if (zerop z) zc (setq
			th (/ x z)
			ph (/ y z)
			cph (cos ph)
			p (list
				(+ (* z (sin th) cph) (car zc))
				(+ (* z (sin ph)) (cadr zc))
				(+ (* z (cos th) cph) (caddr zc))))))))

(defun mapuw (p / x y z th ph r)
	(setq
		x (- (cadr p) (car zc))
		y (- (caddr p) (cadr zc))
		z (- (if (setq z (cadddr p)) z 0) (caddr zc))
		th (atan x z)
		r (+ (* x x) (* z z))
		ph (atan y (sqrt r))
		r (sqrt (+ r (* y y)))
		p (list (car p)
			(+ (* r th) (car zc))
			(+ (* r ph) (cadr zc))
			(+ r (caddr zc)))))


;	LL2FEET		Converts Long-Lat in degrees to feet
;			(approximate equidistant cylindrical projection)

(defun c:ll2feet ( / ss n p0 p1 r xfac yfac ent ent1 xysc)
	(enter)
	(defun xysc ( ent / k p)
		(setq k 9)
		(while (setq p (assoc (setq k (1+ k)) ent))
			(setq ent (subst
	(list k (* (cadr p) tem) (caddr p) (* fixz (cadddr p))) p ent)))
		(entmod ent))
	(setq ss (getall))
	(if ss (progn
	(setq
		p0 (getpoint "From base point <0,0>: ")
		p0 (if p0 p0 (list 0 0 0))
		p1 (getpoint "To base point <0,0>: ")
		p1 (if p1 p1 (list 0 0 0))
		tem (cos (* (cadr p0) (/ pi 180.0)))
		r (/ (+ 6356752.3 (* (- 6378137.0 6356752.3) tem)) 0.3048)
		yfac (* r (/ pi 180.0))
		fixz (/ 1.0 yfac))
	(command
		".scale" ss "" p0 yfac
		".move" ss "" p0 p1
		".zoom" "e")
	(while (> n 0)
		(setq ent (entget (ssname ss (setq n (1- n)))))
		(if (or (= "POLYLINE" (cdr (assoc 0 ent)))
			(= "INSERT" (cdr (assoc 0 ent))))
			(setq ent1 ent
			ent1 (while (/= "SEQEND" (cdr (assoc 0 (setq ent1
				(entget (entnext (cdr (assoc -1 ent1))))))))
				(xysc ent1))))
		(xysc ent))
	(command ".zoom" "e")))
	(leave))


; Polyline dasher 
;

(defun c:polydash ( /
	wide ss n i dist howfar ent p pt p1 dx dy togo doing plast)
	(enter)
	(setq
		i 0
		dashlen (if dashlen dashlen 0.25)
		spacelen (if spacelen spacelen 0.15)
		dist (getdist (strcat "Dash length <" (rtos dashlen) ">: "))
		dashlen (if dist dist dashlen)
		dist (getdist (strcat "Space length <" (rtos spacelen) ">: "))
		spacelen (if dist dist spacelen)
		ss (ssget)
		n (if ss (sslength ss) 0)
	)
	(while (< i n)
		(if (and
(= "POLYLINE" (cdr (assoc 0 (setq ent (entget (setq enam (ssname ss i)))))))
(zerop (boole 1 88 (cdr (assoc 70 ent)))))
			(progn
(command "elev" (elev ent) "")
(command "layer" "s" (cdr (assoc 8 ent)) "")
(if (assoc 62 ent) (command "color" (cdr (assoc 62 ent))))
(setq wide (if (and (assoc 40 ent) (assoc 41 ent)
	(= (cdr (assoc 40 ent)) (cdr (assoc 41 ent)))
	(> (cdr (assoc 40 ent)) 0)) (cdr (assoc 40 ent)) 0))
(setq
	howfar (* 0.5 dashlen)
	ent (entget (entnext (cdr (assoc -1 ent))))
	p (cdr (assoc 10 ent))
)
(while (= "VERTEX" (cdr (assoc 0
		(setq ent (entget (entnext (cdr (assoc -1 ent))))))))
	(if (or (not (assoc 70 ent)) (/= 16 (cdr (assoc 70 ent)))) (progn
	(setq
		p1 (cdr (assoc 10 ent))
		dx (- (car p1) (car p))
		dy (- (cadr p1) (cadr p))
		dist (sqrt (+ (* dx dx) (* dy dy)))
		togo dist
		dist (if (/= 0.0 dist) dist 1.0)
		dx (/ dx dist)
		dy (/ dy dist)
	)
	(while (> togo 0.0)
		(if (< howfar dashlen) (progn
			(setq
				dist (- dashlen howfar)
				dist (if (> dist togo) togo dist)
				pt
	(list (+ (car p) (* dist dx)) (+ (cadr p) (* dist dy)))
			)
			(if doing (if (and (= (car p) (car plast))
					(= (cadr p) (cadr plast)))
				(command pt) 
				(command "" ".pline" p "w" wide wide pt))
				(command ".pline" p "w" wide wide pt))
			(setq doing t plast pt)
			(setq
				p pt
				togo (- togo dist)
				howfar (+ howfar dist)
			)
		)
		(progn
			(setq
				dist (- (+ dashlen spacelen) howfar)
				dist (if (> dist togo) togo dist)
				pt
	(list (+ (car p) (* dist dx)) (+ (cadr p) (* dist dy)))
			)
			(setq
				p pt
				togo (- togo dist)
				howfar (+ howfar dist)
				howfar (if (>= howfar (+ dashlen spacelen))
					0.0 howfar)
			)
		))
		(if doing (command ""))
		(setq doing nil)
	)
)
			)
		)
		(command "erase" enam "")
		))
		(setq i (1+ i))
	)
	(command "elev" 0 "" "redraw")
	(leave)
	(princ)
)

(defun c:township ( / pt1 pt2 cn n m nm ts)
	(enter)
  (setq cn 1)
	(initget 1 "UL UR LR LL")
	(setq pt1 (getpoint "\nUL/UR/LR/<Lower left corner>: "))
  (cond 
    ((eq pt1 "UL")
	    (initget 1)
	    (setq pt1 (getpoint "\nUpper left corner: "))
      (setq cn 2)
    )
    ((eq pt1 "UR")
	    (initget 1)
	    (setq pt1 (getpoint "\nUpper right corner: "))
      (setq cn 3)
    )
    ((eq pt1 "LR")
	    (initget 1)
	    (setq pt1 (getpoint "\nLower right corner: "))
      (setq cn 4)
    )
    ((eq pt1 "LL")
	    (initget 1)
	    (setq pt1 (getpoint "\nLower left corner: "))
    )
  )
  (if pt1
    (progn
      (cond
        ((eq cn 2)
          (setq pt1 (list (car pt1)(- (cadr pt1) 31680)(caddr pt1)))  
        )
        ((eq cn 3)
          (setq pt1 (list (- (car pt1) 31680)(- (cadr pt1) 31680)(caddr pt1)))  
        )
        ((eq cn 4)
          (setq pt1 (list (- (car pt1) 31680)(cadr pt1)(caddr pt1)))  
        )
      )
      (setq pt2 (list (+ (car pt1) 31680)(+ (cadr pt1) 31680)(caddr pt1)))  
      (command ".layer" "make" "Section" "color" "cyan" "Section" "")
      (setq n 1)
      (while (< n 6)
        (command ".line" (list (car pt1)(+ (cadr pt1)(* 5280 n))(caddr pt1))
          (list (car pt2)(+ (cadr pt1)(* 5280 n))(caddr pt1)) "")
        (command ".line" (list (+ (car pt1)(* 5280 n))(cadr pt1)(caddr pt1))
          (list (+ (car pt1)(* 5280 n))(cadr pt2)(caddr pt1)) "")
        (setq n (+ n 1))
      )
      (command ".layer" "make" "Township" "color" "blue" "Township" "")
      (command ".pline" pt1 "w" 100 100 (list (car pt1)(cadr pt2)(caddr pt1))
        pt2 (list (car pt2)(cadr pt1)(caddr pt1)) "close")
      (command ".layer" "make" "SecNumbers" "color" "8" "SecNumbers" "")
	    (setq st (getvar "textstyle"))
      (command ".style" "secnumbers" "romans" 700 1 0 "N" "N" "N")
      (setq n 1)
      (while (< n 7)
        (setq m 1)
        (while (< m 7)
          (setq pt1 (list (- (car pt2)(* 2640 (- (* m 2) 1)))
            (- (cadr pt2)(* 2640 (- (* n 2) 1)))(caddr pt1)))
          (if (or (= n 1)(= n 3)(= n 5))
            (setq nm (+ (* (- n 1) 6) m))
            (setq nm (- (* n 6)(- m 1)))
          )
          (command ".text" "J" "MC" pt1 0 nm)
          (setq m (+ m 1))
        )
        (setq n (+ n 1))
      )
      (command ".style" st "" "" "" "" "" "" "")
    )
  )
	(leave)
)

(defun *error* (s) (terpri) (prompt (strcat "\nError: " s "\n")))
(defun c:noerror () (setq *error* nil)) ; For debugging

(princ)


;E





