;
; QuickSurf AutoLISP Utility Version 4.0
;
; (c) Copyright 1991 Schreiber Instruments, Inc.
; All rights reserved.

; Commands in this file:

; LTEXT     Load text from a file
; NUMBER    Number selected entities
; NUMTRI    Number 3d faces
;	MAKE2D		Change selected 3D polylines to 2D
;	RARIFY    Delete points too close to others, or with excessive slope
; RECOLOR   Color selected entities
; SAREA     Surface area calculation (Areas of 3DFACES by Heron's formula)
;	SCALESYM	Scale symbols
;	SCALEZ		Scale Z components of all selected entities
;	SELZ		  Select contours by z range
;	SETL		  Set single layer to be on
;	SETZ		  Set elevation to elevation of selected object
; DWG2TXT - Extract points from the drawing to an ASCII text file

; BONUS.LSP is loaded automatically, if necessary.

(prompt "\nLoading bonus lisp, Please Wait...")
(defun c:make2d ( / ss en ent ent1 flag z n)
	(setq ss (ssget) n 0)
	(while (setq en (ssname ss n))
		(if (= "POLYLINE" (cdr (assoc 0 (setq ent (entget en))))) (setq
			ent1 (entget (entnext (cdr (assoc -1 ent))))
			z (cadddr (assoc 10 ent1))
			flag (while (= "VERTEX" (cdr (assoc 0 ent1)))
				(setq flag (assoc 10 ent1))
				(entmod (subst
					(list 10 (cadr flag) (caddr flag) 0)
					flag (subst (cons 70 0)
						(assoc 70 ent1) ent1)))
				(setq ent1 (entget (entnext (cdr
					(assoc -1 ent1))))))
			flag (boole 1 1 (cdr (assoc 70 ent)))
			ent (entmod (subst (cons 70 flag) (assoc 70 ent)
				(subst (list 10 0 0 z) (assoc 10 ent) ent)))))
		(setq n (1+ n))))

(defun c:scalesym ( / zscent ss n scale ent ent1)
	(enter)
	(setq ss (ssget) n (if ss (sslength ss) 0)
		scale (getreal "Scale factor: "))
	(while (> n 0)
		(setq ent (entget (ssname ss (setq n (1- n)))))
		(if (= "INSERT" (cdr (assoc 0 ent)))
			(command ".scale" (cdr (assoc -1 ent)) ""
				(cdr (assoc 10 ent)) scale))))

(defun c:scalez ( / zscent ss n scale ent ent1)
	(defun zscent ( / k p)
		(setq k 9)
		(while (setq p (assoc (setq k (1+ k)) ent))
			(setq ent (subst
	(list k (cadr p) (caddr p) (* (cadddr p) scale)) p ent)))
		(entmod ent))
	(setq ss (ssget) n (if ss (sslength ss) 0)
		scale (getreal "Scale factor: "))
	(while (> n 0)
		(setq ent (entget (ssname ss (setq n (1- n)))))
		(if (or (= "POLYLINE" (cdr (assoc 0 ent)))
			(= "INSERT" (cdr (assoc 0 ent)))) (progn
			(setq ent1 ent)
			(while (/= "SEQEND" (cdr (assoc 0 (setq ent
				(entget (entnext (cdr (assoc -1 ent))))))))
				(zscent))
			(setq ent ent1)))
		(zscent))
	(command ".redraw") (princ))

(defun c:selz ( / n lay zlo zhi ss ent enam)
	(setq
		n (getvar "clayer")
		lay (getstring (strcat "Layer <" n ">: "))
		lay (if (= "" lay) n lay)
		zlo (getreal "Minimum z <-inf>: ")
		zhi (getreal "Maximum z <+inf>: ")
		ss (ssget "x" (list (cons 8 (strcase lay))))
		n (if ss (sslength ss) 0))
	(while (> n 0)
		(setq ent (entget (setq enam (ssname ss (setq n (1- n))))))
		(if (and zlo (< (cadddr (assoc 10 ent)) zlo))
			(setq ss (ssdel enam ss))
			(if (and zhi (> (cadddr (assoc 10 ent)) zhi))
				(setq ss (ssdel enam ss)))))
	(if ss (command ".select" ss ""))
	(prompt (strcat (if ss (itoa (sslength ss)) "0") " selected.\n"))
	(princ))

(defun c:setz ( / z)
	(setq z (cadddr (assoc 10 (entget (car (entsel))))))
	(command "elev" z 0) z)

(defun c:setl ( / s)
	(setq s (getstring (strcat "\nLayer <" (getvar "clayer") ">: ")))
	(setvar "cmdecho" 0)
	(if (/= s "")
    (progn
		  (if (not (tblsearch "layer" s))
			  (command "layer" "m" s "")
      )
		  (command "layer" "t" s "m" s "off" "*" "" "")
    )
		(command "layer" "off" "*" "no" "")
  )
  (princ)
)

(defun c:ltext ()
	(setq fil (open (getstring "File name: ") "r"))
	(while (setq s (read-line fil))
		(command "text" "" s)))

(defun c:number ()
	(setq ss (ssget) n (sslength ss) i 0)
	(while (< i n)
		(setq ent (entget (ssname ss (- n i 1))))
		(command ".text" (cdr (assoc 10 ent)) "" "" (itoa i))
		(setq i (1+ i))))

(defun c:numtri () {
	(setq ss (ssget) n (if ss (sslength ss) 0) j (- 1))
	(while (< 0 n)
		(setq n (1- n))
		(if
		(= "3DFACE" (cdr (assoc 0 (setq ent (entget (ssname ss n))))))
		(command "text" "m"
	(list
		(* 0.25 (+
		(car (cdr (assoc 10 ent)))
		(car (cdr (assoc 11 ent)))
		(car (cdr (assoc 12 ent)))
		(car (cdr (assoc 13 ent)))))
		(* 0.25 (+
		(cadr (cdr (assoc 10 ent)))
		(cadr (cdr (assoc 11 ent)))
		(cadr (cdr (assoc 12 ent)))
		(cadr (cdr (assoc 13 ent)))))
		(* 0.25 (+
		(caddr (cdr (assoc 10 ent)))
		(caddr (cdr (assoc 11 ent)))
		(caddr (cdr (assoc 12 ent)))
		(caddr (cdr (assoc 13 ent)))))
	) "" "" (itoa (setq j (1+ j))) "")))
)

;	Command: RARIFY
;	Critical distance: distance
;	Maximum slope <0>: [slope]
;	Select objects: points
;
;
;	Control points that are extremely close to one another are
;	not necessary to define a surface, and they may cause severe
;	problems to QuickSurf if there is even a slight error in their
;	coordinates.  The RARIFY routine moves unwanted points from
;	their current layers to the layer TOOCLOSE, so that they can be
;	excluded from extraction by freezing or turning off that layer.
;
;	Points are considered unwanted if
;
;	  1.  They are within the user specified critical distance, and
;
;	  2.  The slope between them is greater then or equal to the
;	      specified slope.
;
;	Only POINT entities are considered, if they are not already 
;	on the layer TOOCLOSE.  Other entities are ignored.
;
;	If only the 2D distance between points is to be considered, the
;	slope should be set to zero (default).  This is normally the
;	preferred method.  If specified, the slope is interpreted as
;	the absolute difference in elevation divided by the 2D
;	distance.
;
;	The layer TOOCLOSE may be created a priori, and frozen or turned
;	off, so that unwanted points disappear as RARIFY identifies them.
;	If the layer doesn't exist, RARIFY will create it, and set its
;	color to blue, but leave it visible.
;
;	In any cluster of points that are too close to one another,
;	the point with the lowest y coordinate will be retained, and
;	others will be moved to TOOCLOSE.
;
;	If a large number of points is selected, RARIFY may run a long
;	time, because of the large number of comparisons it must make
;	between points.  It would be more efficient to run RARIFY only
;	on small areas that contain, or are suspected of containing
;	unwanted points.


(defun c:rarify ( / delr del slope ss n i j el en ent enb dd sq sort k p0 p1)
	(setvar "CMDECHO" 0)
	(if (not (tblsearch "LAYER" "TOOCLOSE"))
		(command "LAYER" "N" "TOOCLOSE" "C" "B" "TOOCLOSE" ""))
	(command "UNDO" "G")
	(defun sq (x) (* x x))
	(defun sort (a / b c d e f del) (if (cdr a) (progn
		(setq b (nth (/ (length a) 2) a))
		(while (setq c (car a))
			(setq a (cdr a) del (- (cadr b) (cadr c)))
			(if (> del 0) (setq d (cons c d))
				(if (< del 0) (setq f (cons c f))
					(setq e (cons c e)))))
		(append (sort d) e (sort f))) a))
	(initget 7)
	(setq delr (getdist "Critical distance: ") del (* delr delr))
	(initget 4)
	(setq slope (getreal "Maximum slope <0>: ")
		slope (if slope (if (not (zerop slope)) (* slope slope))))
	(setq ss (ssget) n (if ss (sslength ss) 0) i 0 el nil)
	(princ "Wait ...\n")
	(while (< i n)
	(if (and (= "POINT" (cdr (assoc 0 (setq ent (entget
			(setq en (ssname ss i)))))))
		(/= "TOOCLOSE" (cdr (assoc 8 ent))))
			(setq el (cons (list en (caddr (assoc 10 ent))) el)))
		(setq i (1+ i)))
	(setq i 0 el (sort el) n (length el) k 0)
	(while (< i n)
		(setq ent (entget (car (nth i el)))
			p0 (cdr (assoc 10 ent)) i (1+ i) j i)
		(print i)
		(if (/= "TOOCLOSE" (cdr (assoc 8 ent)))
		(while (< j n)
	(setq enb (entget (car (nth j el))) p1 (cdr (assoc 10 enb)) j (1+ j))
	(if (> (setq dd (- (cadr p1) (cadr p0))) delr)
		(setq j n)
		(if (and (/= "TOOCLOSE" (cdr (assoc 8 enb)))
			(<= (setq dd (+ (* dd dd)
	(sq (- (car p1) (car p0))))) del)
		(or (not slope) (<= (* dd slope)
	(sq (- (caddr p1) (caddr p0)))))) (progn
		(setq k (1+ k))
		(entmod (subst (cons 8 "TOOCLOSE") (assoc 8 enb) enb))))))))
	(princ (strcat "\n" (itoa k) " of " (itoa n) " points removed"))
	(command "REDRAW" "UNDO" "E")
	(setvar "CMDECHO" 1)
	(princ))

(defun c:recolor ()
	(setq ss (ssget) n (if ss (sslength ss) 0) i 0)
	(while (< i n)
		(setq i (1+ i))
		(command "change" (ssname ss i) "" "p" "c" i "")
	))

; Surface area calculation (Areas of 3DFACES by Heron's formula)
; Exact for any triangle; quadrangles divided by a line from 1st to 3rd point.
(defun square (x) (* x x))
(defun aent (ent / pa pb pc pd la lb lc ld ll sa sb sum)
	(setq
	pa (cdr (assoc 10 ent))
	pb (cdr (assoc 11 ent))
	pc (cdr (assoc 12 ent))
	pd (cdr (assoc 13 ent))
	la (sqrt (+ (square (- (car pa) (car pb)))
		(square (- (cadr pa) (cadr pb)))
		(square (- (caddr pa) (caddr pb)))))
	lb (sqrt (+ (square (- (car pb) (car pc)))
		(square (- (cadr pb) (cadr pc)))
		(square (- (caddr pb) (caddr pc)))))
	lc (sqrt (+ (square (- (car pc) (car pd)))
		(square (- (cadr pc) (cadr pd)))
		(square (- (caddr pc) (caddr pd)))))
	ld (sqrt (+ (square (- (car pd) (car pa)))
		(square (- (cadr pd) (cadr pa)))
		(square (- (caddr pd) (caddr pa)))))
	ll (sqrt (+ (square (- (car pc) (car pa)))
		(square (- (cadr pc) (cadr pa)))
		(square (- (caddr pc) (caddr pa)))))
	sa (* 0.5 (+ la lb ll))
	sb (* 0.5 (+ lc ld ll)))
	(+ (sqrt (* sa (- sa la) (- sa lb) (- sa ll)))
		(sqrt (* sb (- sb lc) (- sb ld) (- sb ll))))
)

(defun c:sarea ( / n ss i sum ar)
	(setq ss (ssget) n (if ss (sslength ss) 0) i 0 sum 0.0) (textscr)
	(while (< i n)
		(setq ent (entget (ssname ss i)) i (1+ i))
		(if (= "3DFACE" (cdr (assoc 0 ent))) (progn
			(setq ar (aent ent) sum (+ sum ar))
;Remove ";" from next line to get a verbose report
;			(print ar)
	))) sum)

; DWG2TXT - Extract points from the drawing to an ASCII text file
;
;	  Command: DWG2TXT
;	  File name <default>: filename
;	[ RETURN to select all or ]
;	  Select objects: objects
;
;	The DWG2TXT command extracts points from the current drawing and
;	writes them to an ASCII text file, the format of which is
;	described in Section 6.  A file of this type is required for
;	input into QuickSurf.  If you want to select all visible
;	objects in plan view, just press RETURN.  Otherwise, select
;	objects in the normal AutoCAD manner.  DWG2TXT will display an
;	updated count of extracted points every 25 points, except
;	while processing objects with many points.
;
;	No extension should be given with the file name, since
;	a .QS extension will be added automatically.  If multiple
;	surfaces are to be manipulated in the same drawing, you may
;	want to devise a convenient naming system for these surfaces.
;
;	All definable points of selected objects will be extracted
;	as control points.  For INSERTed blocks, only the insertion
;	point is extracted; for POLYLINEs, all vertices; for
;	LINES, the two endpoints; for 3DFACEs, the four corners;
;	for TEXT, the insertion point and the alignment point,
;	if any; etc.  Naturally, all selected objects that are to
;	be used as control points should have the appropriate elevation,
;	unless their elevation is explicitly intended to be 0.
;
;	When all objects have been selected, DWG2TXT will write the file
;	filename.QS to disk, and show the point count.  You can examine
;	or modify the file using any text editor.

(defun getfn ( / tem) (setq
	fname (if (and fname (/= "" fname)) fname (getvar "dwgname"))
	tem (getstring (strcat "\nFile name <" fname ">: "))
	fname (if (/= "" tem) tem fname)))

(defun pout (p)
	(write-line (strcat (rtos (car p)) " " (rtos (cadr p)) " "
		(rtos (caddr p))) qfile))

(defun eflags (ent) (cdr (assoc 70 ent)))

(defun ename (ent) (cdr (assoc -1 ent)))

(defun band (a b) (boole 1 a b))

(defun etyp (ent) (cdr (assoc 0 ent)))

(defun epoint (ent) (cdr (assoc 10 ent)))

(defun next (ent) (if (setq ent (entnext (ename ent))) (entget ent) nil))

(defun elev (ent / tem) (if (setq tem (cdr (assoc 38 ent))) tem
		(if (setq tem (caddr (epoint ent))) tem 0.0)))

(defun c:dwg2txt ( / units rough tem p0 ss j j0 n ent z e0 flt typ r k fname)
	(enter)
  (setq rough (c:qsopt "get" "rough"))
	(setq fname (getfn) ss (getall) j 0)
	(setq qfile (open (strcat fname ".qs") "w"))
	(if (not qfile) (setq qfile (open fname "w")))
	(if qfile (progn
		(if (> (setq units (getvar "lunits")) 2) (setvar "lunits" 2))
		(prompt "\nWait ...")
		(setq i 0)
		(while (< i n)
			(setq ent (entget (ssname ss i))
				i (1+ i))
			(setq	z (elev ent))
			(setq typ (etyp ent))
			(if typ (cond
((= "POLYLINE" typ) (progn
	(setq
		e0 ent
		flt (if (zerop (band 88 (eflags ent))) 1 nil))
	(while (= "VERTEX" (etyp (setq e0 (next e0))))
		(if (and (/= 128 (setq tem (eflags e0)))
			(zerop (band (if rough 9 16) tem)))
				(progn
					(setq tem (epoint e0))
	(pout (list (car tem) (cadr tem) (if flt z (caddr tem))))
					(setq j (1+ j)))))
	(print j)))
((= "ARC" typ) (setq
	p0 (epoint ent)
	r (cdr (assoc 40 ent))
	tem (cdr (assoc 50 ent))
	tem (pout (list (+ (car p0) (* r (cos tem)))
		(+ (cadr p0) (* r (sin tem))) z))
	tem (cdr (assoc 51 ent))	
	tem (pout (list (+ (car p0) (* r (cos tem)))
		(+ (cadr p0) (* r (sin tem))) z))
	j (+ 2 j)
	tem (print j)))
(t (progn
	(setq k 9)
	(while (setq tem (assoc (setq k (1+ k)) ent)) 
		(setq j (1+ j))
		(pout (list (cadr tem) (caddr tem)
			(if (setq tem (cadddr tem)) tem z))))
	(if (zerop (rem j 25)) (print j)))))))
		(print j)
		(close qfile)
		(setq qfile nil)
		(setvar "lunits" units))
	(prompt (strcat "\nCan't open file '" fname "' ")))
	(leave))

(defun c:cls () (grclear))


(princ)
