/* WDASM Example Disassembly Program */

#include <windows.h>

long FAR PASCAL WndProc( HWND, WORD, WORD, LONG);

int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance,
		    LPSTR lpszCmdParam, int nCmdShow)

{	static	char	szAppName[] = "Windows Disassembler Example";
	HWND	hwnd;
	MSG	msg;
	WNDCLASS wndclass;

	if( !hPrevInstance)
	{	wndclass.style = CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc = WndProc;
		wndclass.cbClsExtra = 0;
		wndclass.cbWndExtra = 0;
		wndclass.hInstance = hInstance;
		wndclass.hIcon = LoadIcon( NULL, IDI_APPLICATION);
		wndclass.hCursor = LoadCursor( NULL, IDC_ARROW);
		wndclass.hbrBackground = GetStockObject( WHITE_BRUSH);
		wndclass.lpszMenuName = NULL;
		wndclass.lpszClassName = szAppName;
		RegisterClass( &wndclass);
	}
	hwnd = CreateWindow( szAppName,	    // lpClassName
                 "Windows Disassembler Example",    // lpWindowName
                 WS_OVERLAPPEDWINDOW,       // dwStyle
                 CW_USEDEFAULT,             // X
                 CW_USEDEFAULT,             // Y
                 CW_USEDEFAULT,             // nWidth
                 CW_USEDEFAULT,             // nHeight
                 NULL,                      // hWndParent
                 NULL,                      // hMenu
                 hInstance,                 // hInstance
                 NULL);                     // lpParam
	ShowWindow( hwnd, nCmdShow);
	UpdateWindow( hwnd);
	while( GetMessage( &msg, NULL, 0, 0))
	{	TranslateMessage( &msg);
		DispatchMessage( &msg);
	}
	return msg.wParam;
}

long FAR PASCAL WndProc( HWND hwnd, WORD message, WORD wParam, LONG lParam)
{	HDC	hdc;
	PAINTSTRUCT ps;
	RECT	rect;

	switch( message)
	{	case WM_PAINT:
			hdc = BeginPaint( hwnd, &ps);
			GetClientRect( hwnd, &rect);
			DrawText( hdc, "Congratulations, it works!", -1, &rect,
				  DT_CENTER | DT_VCENTER | DT_SINGLELINE);
			EndPaint( hwnd, &ps);
			return 0;
		case WM_DESTROY:
			PostQuitMessage( 0);
			return 0;
	}
	return DefWindowProc( hwnd, message, wParam, lParam);
}
