#include <windows.h>
#include "mailexts.h"
#include "msgbrwse.h"

#define cchMaxPelem (cchMaxSubject + cchMaxSender + cchMaxFolderName + 
            sizeof(ELEMDATA) + sizeof(MSGDATA))

void EnumMsgs(HMSC, PELEMDATA);
void TextizeMessageID(OID oidObject, OID oidContainer, LPSTR sz);

long FAR PASCAL Command(PARAMBLK FAR * pparamblk)
{
   PSMAPIBLK      psmapiblk = PsmapiblkFromPparamblk(pparamblk); // get hmsc
   HMSC           hmsc = psmapiblk->hmsc;
   OID            oidHier = oidIPMHierarchy; // browse the Folder Hierarchy
   HCBC           hcbc = hcbcNull;
   BYTE           buffer[cchMaxPelem];       // set up buffer for elemdata
   PELEMDATA      pelemdata = (PELEMDATA)&buffer;
   ULONG          lcbElemData;               // size of elemdata structure
   PFOLDDATA      pfolddata;
   int            ec;

   ec = EcOpenPhcbc(hmsc, &oidHier, fwOpenNull, &hcbc, NULL, NULL);
   if(ec)
      goto err;

   for(;;)
   {
      lcbElemData = cchMaxPelem;
      ec = EcGetPelemdata(hcbc, pelemdata, &lcbElemData);
      if(ec && (ec != ecElementEOD))
         break;
      pfolddata = (PFOLDDATA)pelemdata->pbValue;

      OutputDebugString(pfolddata->grsz);
      OutputDebugString(" comment:");
      OutputDebugString(pfolddata->grsz + lstrlen(pfolddata->grsz) + 1);
      OutputDebugString("\r\n");
      
      EnumMsgs(hmsc, pelemdata);
   }

err:
   if(hcbc)
      EcClosePhcbc(&hcbc);
   return 0L;
}

void EnumMsgs(HMSC hmsc, PELEMDATA pelemdata)
{
   OID      oidParent = pelemdata->oid;
   HCBC     hcbcMsg = hcbcNull;
   PMSGDATA pmsgdata;
   ULONG    lcbElemData;
   int      ec;
   char     szMessageId[65];

   ec = EcOpenPhcbc(hmsc, &oidParent, fwOpenNull, &hcbcMsg, NULL, NULL);
   if(!ec)
   {
      for(;;)
      {
         lcbElemData = cchMaxPelem;
         ec = EcGetPelemdata(hcbcMsg, pelemdata, &lcbElemData);
         if(ec && (ec != ecElementEOD))
            break;
         pmsgdata = (PMSGDATA)pelemdata->pbValue;

         OutputDebugString("    ");
         OutputDebugString(pmsgdata->grsz);

         TextizeMessageID(pelemdata->oid, oidParent, szMessageId);
         OutputDebugString(": ");
         OutputDebugString(szMessageId);
         OutputDebugString("\r\n");
      }
   }

   if(hcbcMsg)
      EcClosePhcbc(&hcbcMsg);
}

// converts an oidMsg/oidParent to MAPI szMessageID format.
// un-stringtize the first two DWORDs to get the oid from a MAPI szMessageID.
void TextizeMessageID(OID oidObject, OID oidContainer, LPSTR sz)
{
   wsprintf(sz, (LPSTR)"%08lX%08lX000000000000000000000000", 
         oidObject, oidContainer);
}


int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, 
                           WORD cbHeapSize, LPSTR lpszCmdLine)
{
   if (cbHeapSize != 0)
      UnlockData(0);

   return 1;
}

int FAR PASCAL WEP(int nParm)
{
    return 1;
}

