' Schedule+ Access Libraries Sample Application
'   This application is an example of how to use some of
'   the Schedule+ Access Libraries functions
' Copyright(C) 1992-1993 Microsoft Corporation
'
' You have a royalty-free right to use, modify, reproduce
' and distribute this sample application (and/or any modified version)
' in any way you find useful, provided that you agree that
' Microsoft has no warranty, obligations or liability for
' this sample application

'****************************************************************************'
'                                                                            '
' Visual Basic declaration for the MAPI functions.                           '
' This file can be loaded into the global module.                            '
'                                                                            '                                                                           '
'****************************************************************************'


'***************************************************
'   MAPI Message holds information about a message
'***************************************************

Type MAPIMessage
    Reserved As Long
    Subject As String
    NoteText As String
    MessageType As String
    DateReceived As String
    ConversationID As String
    Flags As Long
    RecipCount As Long
    FileCount As Long
End Type


'************************************************
'   MAPIRecip holds information about a message
'   originator or recipient
'************************************************

Type MapiRecip
    Reserved As Long
    RecipClass As Long
    Name As String
    Address As String
    EIDSize As Long
    EntryID As String
End Type


'******************************************************
'   MapiFile holds information about file attachments
'******************************************************

Type MapiFile
    Reserved As Long
    Flags As Long
    Position As Long
    PathName As String
    FileName As String
    FileType As String
End Type


'***************************
'   FUNCTION Declarations
'***************************

Declare Function MAPILogon Lib "MAPI.DLL" (ByVal UIParam&, ByVal User$, ByVal Password$, ByVal Flags&, ByVal Reserved&, Session&) As Long
Declare Function MAPILogoff Lib "MAPI.DLL" (ByVal Session&, ByVal UIParam&, ByVal Flags&, ByVal Reserved&) As Long
Declare Function BMAPIReadMail Lib "MAPI.DLL" (lMsg&, nRecipients&, nFiles&, ByVal Session&, ByVal UIParam&, MessageID$, ByVal Flag&, ByVal Reserved&) As Long
Declare Function BMAPIGetReadMail Lib "MAPI.DLL" (ByVal lMsg&, Message As MAPIMessage, Recip As MapiRecip, File As MapiFile, Originator As MapiRecip) As Long
Declare Function MAPIFindNext Lib "MAPI.DLL" Alias "BMAPIFindNext" (ByVal Session&, ByVal UIParam&, MsgType$, SeedMsgID$, ByVal Flag&, ByVal Reserved&, MsgID$) As Long
Declare Function MAPISendDocuments Lib "MAPI.DLL" (ByVal UIParam&, ByVal DelimStr$, ByVal FilePaths$, ByVal FileNames$, ByVal Reserved&) As Long
Declare Function MAPIDeleteMail Lib "MAPI.DLL" (ByVal Session&, ByVal UIParam&, ByVal MsgID$, ByVal Flags&, ByVal Reserved&) As Long
Declare Function MAPISendMail Lib "MAPI.DLL" Alias "BMAPISendMail" (ByVal Session&, ByVal UIParam&, Message As MAPIMessage, Recipient As MapiRecip, File As MapiFile, ByVal Flags&, ByVal Reserved&) As Long
Declare Function MAPISaveMail Lib "MAPI.DLL" Alias "BMAPISaveMail" (ByVal Session&, ByVal UIParam&, Message As MAPIMessage, Recipient As MapiRecip, File As MapiFile, ByVal Flags&, ByVal Reserved&, MsgID$) As Long
Declare Function BMAPIAddress Lib "MAPI.DLL" (lInfo&, ByVal Session&, ByVal UIParam&, Caption$, ByVal nEditFields&, Label$, nRecipients&, Recip As MapiRecip, ByVal Flags&, ByVal Reserved&) As Long
Declare Function BMAPIGetAddress Lib "MAPI.DLL" (ByVal lInfo&, ByVal nRecipients&, Recipients As MapiRecip) As Long
Declare Function MAPIDetails Lib "MAPI.DLL" Alias "BMAPIDetails" (ByVal Session&, ByVal UIParam&, Recipient As MapiRecip, ByVal Flags&, ByVal Reserved&) As Long
Declare Function MAPIResolveName Lib "MAPI.DLL" Alias "BMAPIResolveName" (ByVal Session&, ByVal UIParam&, ByVal UserName$, ByVal Flags&, ByVal Reserved&, Recipient As MapiRecip) As Long



'**************************
'   CONSTANT Declarations
'**************************
'

Global Const SUCCESS_SUCCESS = 0
Global Const MAPI_USER_ABORT = 1
Global Const MAPI_E_FAILURE = 2
Global Const MAPI_E_LOGIN_FAILURE = 3
Global Const MAPI_E_DISK_FULL = 4
Global Const MAPI_E_INSUFFICIENT_MEMORY = 5
Global Const MAPI_E_BLK_TOO_SMALL = 6
Global Const MAPI_E_TOO_MANY_SESSIONS = 8
Global Const MAPI_E_TOO_MANY_FILES = 9
Global Const MAPI_E_TOO_MANY_RECIPIENTS = 10
Global Const MAPI_E_ATTACHMENT_NOT_FOUND = 11
Global Const MAPI_E_ATTACHMENT_OPEN_FAILURE = 12
Global Const MAPI_E_ATTACHMENT_WRITE_FAILURE = 13
Global Const MAPI_E_UNKNOWN_RECIPIENT = 14
Global Const MAPI_E_BAD_RECIPTYPE = 15
Global Const MAPI_E_NO_MESSAGES = 16
Global Const MAPI_E_INVALID_MESSAGE = 17
Global Const MAPI_E_TEXT_TOO_LARGE = 18
Global Const MAPI_E_INVALID_SESSION = 19
Global Const MAPI_E_TYPE_NOT_SUPPORTED = 20
Global Const MAPI_E_AMBIGUOUS_RECIPIENT = 21
Global Const MAPI_E_MESSAGE_IN_USE = 22
Global Const MAPI_E_NETWORK_FAILURE = 23
Global Const MAPI_E_INVALID_EDITFIELDS = 24
Global Const MAPI_E_INVALID_RECIPS = 25
Global Const MAPI_E_NOT_SUPPORTED = 26

Global Const MAPI_ORIG = 0
Global Const MAPI_TO = 1
Global Const MAPI_CC = 2
Global Const MAPI_BCC = 3


'***********************
'   FLAG Declarations
'***********************

Global Const MAPI_LOGON_UI = &H1
Global Const MAPI_NEW_SESSION = &H2
Global Const MAPI_DIALOG = &H8
Global Const MAPI_UNREAD_ONLY = &H20
Global Const MAPI_ENVELOPE_ONLY = &H40
Global Const MAPI_PEEK = &H80
Global Const MAPI_GUARANTEE_FIFO = &H100
Global Const MAPI_BODY_AS_FILE = &H200
Global Const MAPI_AB_NOMODIFY = &H400
Global Const MAPI_SUPPRESS_ATTACH = &H800
Global Const MAPI_FORCE_DOWNLOAD = &H1000

Global Const MAPI_OLE = &H1
Global Const MAPI_OLE_STATIC = &H2
'****************************************************************************'
'                                                                            '
' Visual Basic declaration for the SPLUS functions.                           '
' This file can be loaded into the global module.                            '
'                                                                            '                                                                           '
'****************************************************************************'


'***************************************************
'   SPlusAttendee holds information about an attendee
'***************************************************

Type SplusAttendee
    Reserved As Long
    UserType As String
    User As MapiRecip
    Status As Long
End Type


'***************************************************
'   SPlusAssoc describes an associated item
'***************************************************

Type SplusAssoc
    Reserved As Long
    ItemType As String
    Flags As Long
    ItemID As String
    Position As Long
    Data As String
End Type



'***************************************************
'   SPlusMessage holds information about a message
'***************************************************

Type SPlusMessage
    Reserved As Long
    Subject As String
    NoteText As String
    MessageType As String
    DateReceived As String
    ConversationID As String
    Flags As Long
    RecipCount As Long
    FileCount As Long
    SentForCount As Long
End Type


'***************************************************
'   SPlusAppt holds information about an appointment
'***************************************************

Type SplusAppt
    Reserved As Long
    ItemType As String
    Flags As Long
    Creator As MapiRecip
    AssocCount As Long
    Organizer As MapiRecip
    OrganizerItemID As String
    AttendeeCount As Long
    Text As String
    Body As String
    Recurrence As String
    DateStart As String
    DateEnd As String
End Type


'***************************************************
'   SPlusTask holds information about a task
'***************************************************

Type SPlusTask
    Reserved As Long
    ItemType As String
    Flags As Long
    Creator As MapiRecip
    AssocCount As Long
    Organizer As MapiRecip
    OrganizerItemID As String
    AttendeeCount As Long
    Text As String
    Body As String
    Recurrence As String
    DateDue As String
    DurationActive As String
    ProjectName As String
    Priority As String
End Type


'***************************************************
'   SPlusUserInfo holds information about some user
'***************************************************

Type SPlusUserInfo
    Reserved As Long
    UserType As String
    Flags As Long
    Assistant As MapiRecip
    StartTime As String
    EndTime As String
    TimeZone As String
    Data As String
End Type


'***************************************************
'   SPlusRestriction describes a restriction
'***************************************************

Type SPlusRestriction
    Reserved As Long
    ItemType As String
    RestrictionType As String
    RestrictionData As String
End Type



'***************************
'   FUNCTION Declarations
'***************************

Declare Function SPLUSSendMeeting Lib "SPLUS.DLL" Alias "BSPLUSSendMeeting" (ByVal S&, ByVal UIP&, M As SPlusMessage, R As MapiRecip, F As MapiFile, SF As MapiRecip, A As SplusAppt, CAs As SplusAssoc, At As SplusAttendee, ByVal F&, ByVal Res&) As Long
Declare Function BSPLUSReadMeeting Lib "SPLUS.DLL" (lMsg&, nRecipCount&, nFileCount&, nSentForCount&, nAssocCount&, nAttendeeCount&, ByVal Session&, ByVal UIParam&, MessageID$, ByVal Flags&, ByVal Reserved&) As Long
Declare Function BSPLUSGetReadMeeting Lib "SPLUS.DLL" (ByVal lMsg&, Message As SPlusMessage, Originator As MapiRecip, Recips As MapiRecip, Files As MapiFile, SentFor As MapiRecip, Appt As SplusAppt, Assoc As SplusAssoc, Attendees As SplusAttendee) As Long

Declare Function SPlusBeginSession Lib "SPLUS.DLL" Alias "SPLUSBeginSession" (ByVal Session&, ByVal UIParam&, ByVal Flags&, ByVal Reserved&, SPlusSession&) As Long
Declare Function SPlusEndSession Lib "SPLUS.DLL" Alias "SPLUSEndSession" (ByVal Session&, ByVal UIParam&, ByVal Flags&, ByVal Reserved&) As Long
Declare Function SPLUSReadFreeBusy Lib "SPLUS.DLL" Alias "BSPLUSReadFreeBusy" (ByVal Session&, ByVal UIParam&, ByVal nUserCount&, Users As MapiRecip, Mon$, ByVal Flags&, ByVal Reserved&, HaveInfo$, FreeBusy$) As Long
Declare Function SPlusReadUserInfo Lib "SPLUS.DLL" Alias "BSPLUSReadUserInfo" (ByVal Session&, ByVal UIParam&, User As MapiRecip, ByVal Flags&, ByVal Reserved&, UserInfo As SPlusUserInfo) As Long
Declare Function SPLUSFindNextItem Lib "SPLUS.DLL" Alias "BSPLUSFindNextItem" (ByVal Session&, ByVal UIParam&, User As MapiRecip, Restriction As SPlusRestriction, SeedItemID$, ByVal Flags&, ByVal Reserved&, ItemID$) As Long
Declare Function SPLUSDeleteItem Lib "SPLUS.DLL" Alias "BSPLUSDeleteItem" (ByVal Session&, ByVal UIParam&, User As MapiRecip, ItemID$, ByVal Flags&, ByVal Reserved&) As Long
Declare Function SPLUSSaveAppt Lib "SPLUS.DLL" Alias "BSPLUSSaveAppt" (ByVal Session&, ByVal UIParam&, User As MapiRecip, Appt As SplusAppt, Assoc As SplusAssoc, Attendees As SplusAttendee, ByVal Flags&, ByVal Reserved&, ItemID$) As Long
Declare Function SPlusSaveTask Lib "SPLUS.DLL" Alias "BSPLUSSaveTask" (ByVal Session&, ByVal UIParam&, User As MapiRecip, Task As SPlusTask, Assoc As SplusAssoc, Attendees As SplusAttendee, ByVal Flags&, ByVal Reserved&, ItemID$) As Long
Declare Function BSPLUSReadAppt Lib "SPLUS.DLL" (lAppt&, nAssocCount&, nAttendeeCount&, ByVal Session&, ByVal UIParam&, User As MapiRecip, ItemID$, ByVal Flags&, ByVal Reserved&) As Long
Declare Function BSPLUSGetReadAppt Lib "SPLUS.DLL" (ByVal lAppt&, Appt As SplusAppt, Assoc As SplusAssoc, Attendees As SplusAttendee) As Long
Declare Function BSPLUSReadTask Lib "SPLUS.DLL" (lTask&, nAssocCount&, nAttendeeCount&, ByVal Session&, ByVal UIParam&, User As MapiRecip, ItemID$, ByVal Flags&, ByVal Reserved&) As Long
Declare Function BSPLUSGetReadTask Lib "SPLUS.DLL" (ByVal lTask&, Task As SPlusTask, Assoc As SplusAssoc, Attendees As SplusAttendee) As Long


'**************************
'   CONSTANT Declarations
'**************************
'

Global Const SPLUS_E_INVALID_SENT_FOR = 10000
Global Const SPLUS_E_NOT_INSTALLED = 10005
Global Const SPLUS_E_NO_ITEMS = 10010
Global Const SPLUS_E_NO_SCHEDULE = 10015
Global Const SPLUS_E_NO_PRIVILEGE = 10020
Global Const SPLUS_E_INVALID_ADDRESS_FORMAT = 10025
Global Const SPLUS_E_INVALID_USER = 10030
Global Const SPLUS_E_INVALID_ITEM = 10035
Global Const SPLUS_E_INVALID_TYPE = 10040
Global Const SPLUS_E_INVALID_FLAGS = 10045
Global Const SPLUS_E_INVALID_ASSOC = 10050
Global Const SPLUS_E_INVALID_ORGANIZER = 10055
Global Const SPLUS_E_INVALID_ORGANIZER_ID = 10060
Global Const SPLUS_E_INVALID_ATTENDEES = 10065
Global Const SPLUS_E_INVALID_TIME = 10070
Global Const SPLUS_E_INVALID_PRIORITY = 10075
Global Const SPLUS_E_INVALID_MONTH = 10080
Global Const SPLUS_E_INVALID_RESTRICTION = 10085
Global Const SPLUS_E_ALARM_RING_IN_PAST = 10090
Global Const SPLUS_E_NOT_ONLINE = 10095


'***********************
'   FLAG Declarations
'***********************

Global Const SPLUS_NO_REQUEST_SENT = &H0
Global Const SPLUS_NO_RESPONSE = &H1
Global Const SPLUS_POSITIVE_RESPONSE = &H2
Global Const SPLUS_NEGATIVE_RESPONSE = &H3
Global Const SPLUS_AMBIGUOUS_RESPONSE = &H4

Global Const SPLUS_RESPONSE_REQUESTED = &H10000

Global Const SPLUS_PRIVATE = &H1
Global Const SPLUS_PRIVATE_PROJECT = &H2
Global Const SPLUS_TENTATIVE = &H4

Global Const SPLUS_BOSS_WANTS_COPY = &H1

Global Const SPLUS_DEFAULT_ALARM = &H1000

Global Const SPLUS_MODIFY_FLAGS = &H10000
Global Const SPLUS_MODIFY_ASSOC = &H20000
Global Const SPLUS_MODIFY_ATTENDEES = &H40000
Global Const SPLUS_MODIFY_TEXT = &H80000
Global Const SPLUS_MODIFY_TIMES = &H400000
Global Const SPLUS_MODIFY_PROJECT_NAME = &H800000
Global Const SPLUS_MODIFY_PRIORITY = &H1000000

Global Const SPLUS_SUPPRESS_RECIPIENTS = &H10000

'**********************************************
'  SAL Sample Application specific declarations
'**********************************************


Global SPlusSession As Long
Global MapiSession As Long
Global User As MapiRecip
Global RqstMessage As SPlusMessage
Global RqstAppt As SplusAppt
Global TempSentFor As MapiRecip
Global RqstOriginator As MapiRecip
Global RqstMsgSubject As String


