#include <windows.h>
#include <windowsx.h> 
#include <string.h>
#include "mapi.h"
#include "SPLUS.h" 

/*  This function copies recipient source in 
 *  recipient destination.
 *  The function also allocates memory for these recipients 
 *  nRecipients is the number of recipients to copy. 
 *  Parameters:
 *      lpRecipIn: pointer to the first Recipient structure.
 *                 We assume that Recip_i can be accessed as
 *                 Recip_0 + i (as SAL does)
 *      lppRecipOut: lppMapiRecipDesc. The function will allocate
 *                   memory for the recipients, and copy them in 
 *                   the new structure. This pointer will point to the 
 *                   pointer to the new recipient structure.
 *  This function allocates the memory for all the recipients in one 
 *  block. Only one step will be needed to free it.
 *              
*/

HANDLE CopyRecipients(lpMapiRecipDesc lpRecipIn, 
                        lpMapiRecipDesc far * lppRecipOut,
                        ULONG nRecipients)
{
HANDLE hglb;
int i;
    if (nRecipients==0L) 
        return(999);  /* return if there are not recipients to copy */
    hglb=GlobalAlloc (GMEM_MOVEABLE, 
                     (nRecipients*sizeof(MapiRecipDesc)));
    if (((*(lppRecipOut))=(lpMapiRecipDesc)GlobalLock(hglb))==NULL) 
        return (NULL); /* return if something fails allocating memory */
    /* Copy the recipient structures */
    for (i=0;i<(int)nRecipients;i++)
    {
        ((*lppRecipOut)+i)->ulReserved=0;
        ((*lppRecipOut)+i)->ulRecipClass = ((lpRecipIn)+i)->ulRecipClass;    
        if ((lpRecipIn+i)->lpszName !=NULL)
        {   
        /*allocate memory for the name*/
            hglb=GlobalAlloc(GMEM_MOVEABLE,lstrlen((lpRecipIn+i)->lpszName));
            if ((((*(lppRecipOut)+i)->lpszName)=(LPSTR)GlobalLock(hglb))==NULL) 
                return (NULL); /* return if something fails allocating memory */ 
            _fstrcpy(((*lppRecipOut)+i)->lpszName,(lpRecipIn+i)->lpszName);    

        }
        else
            ((*lppRecipOut)+i)->lpszName=NULL;
        if ((lpRecipIn+i)->lpszAddress !=NULL)
        {   
        /*allocate memory for the address*/
            hglb=GlobalAlloc(GMEM_MOVEABLE,lstrlen((lpRecipIn+i)->lpszAddress));
            if ((((*(lppRecipOut)+i)->lpszAddress)=(LPSTR)GlobalLock(hglb))==NULL) 
                return (NULL); /* return if something fails allocating memory */ 
            _fstrcpy(((*lppRecipOut)+i)->lpszAddress,(lpRecipIn+i)->lpszAddress);
        }
        else
            ((*lppRecipOut)+i)->lpszAddress=NULL;
        ((*lppRecipOut)+i)->ulEIDSize=(lpRecipIn+i)->ulEIDSize;   
        
        if ((lpRecipIn+i)->ulEIDSize!=0L)
        /*allocate memory for EIDSize*/  
        {
            hglb=GlobalAlloc(GMEM_MOVEABLE,((lpRecipIn+i)->ulEIDSize));
            if ((((*(lppRecipOut)+i)->lpEntryID)=(void far *)GlobalLock(hglb))==NULL) 
                return (NULL); /* return if something fails allocating memory */ 
            _fmemcpy(((*lppRecipOut)+i)->lpEntryID,(lpRecipIn+i)->lpEntryID,(int)(lpRecipIn+i)->ulEIDSize);
        }
        else
           ((*lppRecipOut)+i)->lpEntryID=(lpRecipIn+i)->lpEntryID;
    } 
    return(hglb);
}  

/*  This function copies attendee source in
 *  attendee destination.
 *  The function also allocates memory for these attendees
 *  and call CopyRecipients to copy the recipient descriptors.  
 *  nRecipients is the number of recipients to copy. 
 *  Parameters:
 *      lpAttendIn: pointer to the first Attendee structure.
 *                  We assume that Attendee_i can be accessed as
 *                  Attendee_0 + i (as SAL does)
 *      lppAttendOut: lppMapiRecipDesc. The function will allocate
 *                    memory for the recipients, and copy them in 
 *                    the new structure. This pointer will point to the 
 *                    pointer to the new recipient structure.
 *  This function allocates the memory for all the attendees in one 
 *  block. Only one step will be needed to free it.
 *              
*/


HANDLE CopyAttendees(lpSPlusAttendeeDesc lpAttendIn,
                     lpSPlusAttendeeDesc far * lppAttendOut,
                     ULONG nAttendees)
{
HANDLE hglb;
int i;
    if (nAttendees==0L) 
        return(999);  /* return if there are not attendees to copy */
    hglb=GlobalAlloc (GMEM_MOVEABLE, 
                     (nAttendees*sizeof(SPlusAttendeeDesc)));
    if (((*(lppAttendOut)) = (lpSPlusAttendeeDesc)GlobalLock(hglb))==NULL) 
        return (NULL); /* return if something fails allocating memory */
    /* Copy the attendee structures */
    for (i=0;i<(int)nAttendees;i++)
    {
        ((*lppAttendOut)+i)->ulReserved=(lpAttendIn+i)->ulReserved;
        if ((lpAttendIn+i)->lpszUserType !=NULL)
        {   
        /*allocate memory for the user type*/
            hglb=GlobalAlloc(GMEM_MOVEABLE,lstrlen((lpAttendIn+i)->lpszUserType));
            if ((((*lppAttendOut)+i)->lpszUserType=(LPSTR)GlobalLock(hglb))==NULL) 
                return (NULL); /* return if something fails allocating memory */ 
            _fstrcpy(((*lppAttendOut)+i)->lpszUserType,(lpAttendIn+i)->lpszUserType);
        }
        else
             ((*lppAttendOut)+i)->lpszUserType=(lpAttendIn+i)->lpszUserType;  
        
        /* Call CopyRecipients to copy the User field */
        hglb=CopyRecipients((lpAttendIn+i)->lpUser,
                            &((*lppAttendOut)+i)->lpUser,1);
    
        ((*lppAttendOut)+i)->ulStatus=(lpAttendIn+i)->ulStatus;
     }
return(hglb);
}     

/*  This function copies a source appt in a destination.
 *  The function also allocates memory for the appt and 
 *  call CopyAttendees to copy the Attendee descriptors
 *  and CopyRecipients to copy the recipient descriptors. 
 *  In this sample we do not consider the case where that 
 *  appt has any associated item with it (such as an alarm). 
 *  To do that, another function (CopyAlarm) should be written.
 *  Parameters:
 *      lpApptIn: pointer to the appointment structure
 *      lppApptOut: lppSPlusAppt. The function will allocate
 *                   memory for the appt, and copy it in 
 *                   the new structure. This pointer will point to the 
 *                   pointer to the new appointment.
*/
HANDLE CopyAppointment(lpSPlusAppt lpApptIn, 
                       lpSPlusAppt far * lppApptOut)
{
HANDLE hglb; 
    /*  Allocate memory for the new appt structure
        and return if there is an error */
    hglb=GlobalAlloc (GMEM_MOVEABLE, 
                      (sizeof(SPlusAppt)));
    if (((*(lppApptOut))=(lpSPlusAppt)GlobalLock(hglb))==NULL) 
        return (NULL); 
    
    /* copy the structure */
    (*lppApptOut)->ulReserved=lpApptIn->ulReserved;
    if (lpApptIn->lpszItemType !=NULL)
    {   
    /*allocate memory for the user type*/
        hglb=GlobalAlloc(GMEM_MOVEABLE,lstrlen(lpApptIn->lpszItemType));
        if (((*lppApptOut)->lpszItemType=(LPSTR)GlobalLock(hglb))==NULL) 
            return (NULL); /* return if something fails allocating memory */ 
        _fstrcpy((*lppApptOut)->lpszItemType,lpApptIn->lpszItemType);
    }
    else
         (*lppApptOut)->lpszItemType=lpApptIn->lpszItemType;  

    (*lppApptOut)->flFlags=lpApptIn->flFlags;
    
    /* if there is a creator, allocate memory to it and copy it */  
    if (lpApptIn->lpCreator==NULL) (*lppApptOut)->lpCreator=NULL;
    else    hglb=CopyRecipients(lpApptIn->lpCreator,&(*lppApptOut)->lpCreator,1);
    /* this sample app does not support alarms*/
    (*lppApptOut)->nAssocCount=0;
    (*lppApptOut)->lpAssoc=NULL;  
    
    /* if there is an organizer, allocate memory to it and copy it */
    if (lpApptIn->lpOrganizer==NULL) (*lppApptOut)->lpOrganizer=NULL;
    else    hglb=CopyRecipients(lpApptIn->lpOrganizer,&(*lppApptOut)->lpOrganizer,1);
    
    if (lpApptIn->lpszOrganizerItemID !=NULL)
    {   
    /*allocate memory for the user type*/
        hglb=GlobalAlloc(GMEM_MOVEABLE,lstrlen(lpApptIn->lpszOrganizerItemID));
        if (((*lppApptOut)->lpszOrganizerItemID=(LPSTR)GlobalLock(hglb))==NULL) 
            return (NULL); /* return if something fails allocating memory */ 
        _fstrcpy((*lppApptOut)->lpszOrganizerItemID,lpApptIn->lpszOrganizerItemID);
    }
    else
         (*lppApptOut)->lpszOrganizerItemID=lpApptIn->lpszOrganizerItemID;  
    (*lppApptOut)->nAttendeeCount=lpApptIn->nAttendeeCount; 
    
    /* if there attendees, allocate memory to them and copy them */  
    if (lpApptIn->nAttendeeCount==0) (*lppApptOut)->lpAttendees=NULL;
    else    hglb=CopyAttendees(lpApptIn->lpAttendees,&(*lppApptOut)->lpAttendees,(int)lpApptIn->nAttendeeCount); 
    
    if (lpApptIn->lpszText !=NULL)
    {   
    /*allocate memory for the text*/
        hglb=GlobalAlloc(GMEM_MOVEABLE,lstrlen(lpApptIn->lpszText));
        if (((*lppApptOut)->lpszText=(LPSTR)GlobalLock(hglb))==NULL) 
            return (NULL); /* return if something fails allocating memory */ 
        _fstrcpy((*lppApptOut)->lpszText,lpApptIn->lpszText);
    }
    else
         (*lppApptOut)->lpszText=lpApptIn->lpszText;  
    if (lpApptIn->lpszBody !=NULL)
    {   
    /*allocate memory for the body*/
        hglb=GlobalAlloc(GMEM_MOVEABLE,lstrlen(lpApptIn->lpszBody));
        if (((*lppApptOut)->lpszBody=(LPSTR)GlobalLock(hglb))==NULL) 
            return (NULL); /* return if something fails allocating memory */ 
        _fstrcpy((*lppApptOut)->lpszBody,lpApptIn->lpszBody);
    }
    else
         (*lppApptOut)->lpszBody=lpApptIn->lpszBody;  
    if (lpApptIn->lpszRecurrence !=NULL)
    {   
    /*allocate memory for the recurrence*/
        hglb=GlobalAlloc(GMEM_MOVEABLE,lstrlen(lpApptIn->lpszRecurrence));
        if (((*lppApptOut)->lpszRecurrence=(LPSTR)GlobalLock(hglb))==NULL) 
            return (NULL); /* return if something fails allocating memory */ 
        _fstrcpy((*lppApptOut)->lpszRecurrence,lpApptIn->lpszRecurrence);
    }
    else
         (*lppApptOut)->lpszRecurrence=lpApptIn->lpszRecurrence;  
    if (lpApptIn->lpszDateStart !=NULL)
    {   
    /*allocate memory for DateStart*/
        hglb=GlobalAlloc(GMEM_MOVEABLE,lstrlen(lpApptIn->lpszDateStart));
        if (((*lppApptOut)->lpszDateStart=(LPSTR)GlobalLock(hglb))==NULL) 
            return (NULL); /* return if something fails allocating memory */ 
        _fstrcpy((*lppApptOut)->lpszDateStart,lpApptIn->lpszDateStart);
    }
    else
         (*lppApptOut)->lpszDateStart=lpApptIn->lpszDateStart;  
    if (lpApptIn->lpszDateEnd !=NULL)
    {   
    /*allocate memory for DateEnd*/
        hglb=GlobalAlloc(GMEM_MOVEABLE,lstrlen(lpApptIn->lpszDateEnd));
        if (((*lppApptOut)->lpszDateEnd=(LPSTR)GlobalLock(hglb))==NULL) 
            return (NULL); /* return if something fails allocating memory */ 
        _fstrcpy((*lppApptOut)->lpszDateEnd,lpApptIn->lpszDateEnd);
    }
    else
         (*lppApptOut)->lpszDateEnd=lpApptIn->lpszDateEnd;  
    
return(hglb);
}  

/*  This function copies a source message in a destination.
 *  The function also allocates memory for the message and 
 *  call CopyRecipients to copy the Recipient descriptors. 
 *  In this sample we do not consider the case where that 
 *  appt has any associated file to it.
 *  To do that, another function (CopyFile) should be written.
 *  Parameters:
 *      lpMessageIn: pointer to the Message structure
 *      lppMessageOut: lppSPlusMessage. The function will allocate
 *                   memory for the message, and copy it in 
 *                   the new structure. This pointer will point to 
 *                   the pointer to the new message.
*/
HANDLE CopyMessage(lpSPlusMessage lpMessageIn, 
                   lpSPlusMessage far * lppMessageOut)
{
HANDLE hglb;
    /*  Allocate memory for the new message structure
        and return if there is an error */
    hglb=GlobalAlloc (GMEM_MOVEABLE, 
                      (sizeof(SPlusMessage)));
    if (((*(lppMessageOut))=(lpSPlusMessage)GlobalLock(hglb))==NULL) 
        return (NULL); 
    
    
    if (lpMessageIn->lpszSubject !=NULL)
    {   
    /*allocate memory for the subject: 
    in this case we allocate the maximum size: 256 characters */
        hglb=GlobalAlloc(GMEM_MOVEABLE,256*sizeof(char));
        if (((*lppMessageOut)->lpszSubject=(LPSTR)GlobalLock(hglb))==NULL) 
            return (NULL); /* return if something fails allocating memory */ 
        _fstrcpy((*lppMessageOut)->lpszSubject,lpMessageIn->lpszSubject);
    }
    else
         (*lppMessageOut)->lpszSubject=lpMessageIn->lpszSubject;  
    if (lpMessageIn->lpszNoteText !=NULL)
    {   
    /*allocate memory for the Text*/
        hglb=GlobalAlloc(GMEM_MOVEABLE,lstrlen(lpMessageIn->lpszNoteText));
        if (((*lppMessageOut)->lpszNoteText=(LPSTR)GlobalLock(hglb))==NULL) 
            return (NULL); /* return if something fails allocating memory */ 
        _fstrcpy((*lppMessageOut)->lpszNoteText,lpMessageIn->lpszNoteText);
    }
    else
         (*lppMessageOut)->lpszNoteText=lpMessageIn->lpszNoteText;  
    if (lpMessageIn->lpszMessageType !=NULL)
    {   
    /*allocate memory for maximum size of MessageType*/
        hglb=GlobalAlloc(GMEM_MOVEABLE,lstrlen("IPM.Microsoft Schedule.MtgRespN"));
        if (((*lppMessageOut)->lpszMessageType=(LPSTR)GlobalLock(hglb))==NULL) 
            return (NULL); /* return if something fails allocating memory */ 
        _fstrcpy((*lppMessageOut)->lpszMessageType,lpMessageIn->lpszMessageType);
    }
    else
         (*lppMessageOut)->lpszMessageType=lpMessageIn->lpszMessageType;  
    if (lpMessageIn->lpszDateReceived !=NULL)
    {   
    /*allocate memory for the DateReceived*/
        hglb=GlobalAlloc(GMEM_MOVEABLE,lstrlen(lpMessageIn->lpszDateReceived));
        if (((*lppMessageOut)->lpszDateReceived=(LPSTR)GlobalLock(hglb))==NULL) 
            return (NULL); /* return if something fails allocating memory */ 
        _fstrcpy((*lppMessageOut)->lpszDateReceived,lpMessageIn->lpszDateReceived);
    }
    else
         (*lppMessageOut)->lpszDateReceived=lpMessageIn->lpszDateReceived;  
    if (lpMessageIn->lpszConversationID !=NULL)
    {   
    /*allocate memory for the ConversationID*/
        hglb=GlobalAlloc(GMEM_MOVEABLE,lstrlen(lpMessageIn->lpszConversationID));
        if (((*lppMessageOut)->lpszConversationID=(LPSTR)GlobalLock(hglb))==NULL) 
            return (NULL); /* return if something fails allocating memory */ 
        _fstrcpy((*lppMessageOut)->lpszConversationID,lpMessageIn->lpszConversationID);
    }
    else
         (*lppMessageOut)->lpszConversationID=lpMessageIn->lpszConversationID;  
    (*lppMessageOut)->flFlags=lpMessageIn->flFlags;  

    /* if there is an originator, allocate memory to it and copy it */  
    if (lpMessageIn->lpOriginator==NULL) 
        (*lppMessageOut)->lpOriginator=NULL;
    else    hglb=CopyRecipients(lpMessageIn->lpOriginator,
                                &(*lppMessageOut)->lpOriginator,1);

    (*lppMessageOut)->nRecipCount=lpMessageIn->nRecipCount; 
    
    /* if there are recipients, allocate memory to them and copy them */    
    if (lpMessageIn->nRecipCount==0) 
        (*lppMessageOut)->lpRecips=NULL;
    else    hglb=CopyRecipients(lpMessageIn->lpRecips,
                                &(*lppMessageOut)->lpRecips,
                                (int)lpMessageIn->nRecipCount); 
    
     /* this sample app does not support files*/
    (*lppMessageOut)->nFileCount=0;
    (*lppMessageOut)->lpFiles=NULL;  
     
    (*lppMessageOut)->nSentForCount=lpMessageIn->nSentForCount; 
    
    /*  if there are any sentFor recipient, 
        allocate memory to them and copy them */    
    if (lpMessageIn->nSentForCount==0) 
        (*lppMessageOut)->lpSentFor=NULL;
    else    hglb=CopyRecipients(lpMessageIn->lpSentFor,
                                &(*lppMessageOut)->lpSentFor,
                                (int)lpMessageIn->nSentForCount);   
return(hglb);
}  

/*  This function frees the memory associated with a 
 *  RecipientDesc structure. It gets the handle from 
 *  the pointer to the structure, and then frees the 
 *  memory associated with this handle. Since the handle 
 *  has all the information for the block, this function 
 *  will free the memory for all the Recipient Descriptors 
 *  created at the same time.
 *  Parameter:
 *      lppRecipDesc: pointer to the pointer to the block 
 *                    of memory allocated for the recipients
 */
void FreeRecipients(lpMapiRecipDesc far * lppRecipDesc, ULONG nRecipients)
{  
HANDLE hglb; 
unsigned int i;
    for (i=0;i<nRecipients;i++)
    {
        if ((*lppRecipDesc+i)->lpszName !=NULL)  
        {
        /*free memory for the name*/
            hglb=GlobalPtrHandle((LPSTR)(*lppRecipDesc+i)->lpszName);
            GlobalUnlock(hglb);
            GlobalFree(hglb); 
        }

        if ((*lppRecipDesc+i)->lpszAddress !=NULL) 
        {
        /*free memory for the address*/
            hglb=GlobalPtrHandle((LPSTR)(*lppRecipDesc+i)->lpszAddress);
            GlobalUnlock(hglb);
            GlobalFree(hglb);
        }

     }
    hglb=GlobalPtrHandle((LPSTR)(*(lppRecipDesc)));
    GlobalUnlock(hglb);
    GlobalFree(hglb);
} 

/*  This function frees the memory associated with 
 *  an AttendeeDesc structure. It gets the handle from 
 *  the pointer to the structure, and then frees the memory 
 *  associated with this handle. Since the handle has all the 
 *  information for the block, this function will free the 
 *  memory for all the Attendee Descriptors 
 *  created at the same time. It calls Free Recipients to free 
 *  as well the recipient structures 
 *  associated with the attendees 
 *  Parameters:
 *      lppAttendDesc: pointer to the pointer to the block 
 *                    of memory allocated for the attenddes.
 *      nAttendees: number of attendees. This parameter is used
 *                  to free the recipient descriptors associated
 *                  to the User field.
*/

void FreeAttendees(lpSPlusAttendeeDesc far * lppAttendDesc, 
                   ULONG nAttendees)
{  
HANDLE hglb; 
int i;
    
    /* Free the attendees space */

    for (i=0;i<(int)nAttendees;i++)
    {
        if (((*lppAttendDesc)+i)->lpszUserType !=NULL)
        {   
        /*allocate memory for the user type*/
            hglb=GlobalPtrHandle((LPSTR)((*lppAttendDesc)+i)->lpszUserType); 
            GlobalUnlock(hglb);
            GlobalFree(hglb);
        }
        /* Free the recipient descriptors memory for each attendee 
        FreeRecipients needs a lppMapiRecipDescriptor */
        FreeRecipients(&((*lppAttendDesc)+i)->lpUser, 1L);   
     }
    hglb=GlobalPtrHandle((LPSTR)(*(lppAttendDesc)));
    GlobalUnlock(hglb);
    GlobalFree(hglb);
}  

/*  This function frees the memory associated with an 
 *  Appointment structure. It gets the handle from the 
 *  pointer to the structure, and then frees the 
 *  memory associated with this handle. It calls FreeAttendees 
 *  to free as well the attendee structure associated with 
 *  the appointment and it call FreeRecipient to free the
 *  recipient desciptors.
 *  Parameter:
 *      lppAppt: pointer to the pointer to the block 
 *               of memory allocated for the appt.
 */

void FreeAppointment(lpSPlusAppt far * lppAppt)
{  
HANDLE hglb;   

    if ((*lppAppt)->lpszItemType !=NULL)
    {   
    /*free memory for the user type*/ 
        hglb=GlobalPtrHandle((LPSTR)((*lppAppt)->lpszItemType));
        GlobalUnlock(hglb);
        GlobalFree(hglb);
    }
    if ((*lppAppt)->lpszOrganizerItemID !=NULL)
    {   
    /*free memory for the OrganizerItemID*/ 
        hglb=GlobalPtrHandle((LPSTR)((*lppAppt)->lpszOrganizerItemID));
        GlobalUnlock(hglb);
        GlobalFree(hglb);
    }
    
    if ((*lppAppt)->lpszText !=NULL)
    {   
    /*free memory for the text*/ 
        hglb=GlobalPtrHandle((LPSTR)((*lppAppt)->lpszText));
        GlobalUnlock(hglb);
        GlobalFree(hglb);
    }
    
    if ((*lppAppt)->lpszBody !=NULL)
    {   
    /*free memory for the body*/ 
        hglb=GlobalPtrHandle((LPSTR)((*lppAppt)->lpszBody));
        GlobalUnlock(hglb);
        GlobalFree(hglb);
    }
    if ((*lppAppt)->lpszRecurrence !=NULL)
    {   
    /*free memory for the recurrence*/ 
        hglb=GlobalPtrHandle((LPSTR)((*lppAppt)->lpszRecurrence));
        GlobalUnlock(hglb);
        GlobalFree(hglb);
    }
    if ((*lppAppt)->lpszDateStart !=NULL)
    {   
    /*free memory for the dateStart*/ 
        hglb=GlobalPtrHandle((LPSTR)((*lppAppt)->lpszDateStart));
        GlobalUnlock(hglb);
        GlobalFree(hglb);
    }
    if ((*lppAppt)->lpszDateEnd !=NULL)
    {   
    /*free memory for the DateEnd*/ 
        hglb=GlobalPtrHandle((LPSTR)((*lppAppt)->lpszDateEnd));
        GlobalUnlock(hglb);
        GlobalFree(hglb);
    }
    /* Free the memory allocated for the Creator if neccessary */
    if ((*lppAppt)->lpCreator!=NULL)
        FreeRecipients(&(*lppAppt)->lpCreator, 1L);
    /* Free the memory allocated for the Organizer if neccessary */
    if ((*lppAppt)->lpOrganizer!=NULL)
        FreeRecipients(&(*lppAppt)->lpOrganizer, 1L);
    /*Free the memory allocated for the Attenddes if neccessary */  
    if ((*lppAppt)->lpAttendees!=NULL)
        FreeAttendees(&(*lppAppt)->lpAttendees, 
                      (int)(*lppAppt)->nAttendeeCount);
    
    /* Free the appointment memory */

    hglb=GlobalPtrHandle((LPSTR)(*(lppAppt)));
    GlobalUnlock(hglb);
    GlobalFree(hglb);
}  

/*  This function frees the memory associated with a 
 *  Message structure. It gets the handle from the 
 *  pointer to the structure, and then frees the 
 *  memory associated with this handle. It calls FreeRecipient 
 *  to free the recipient desciptors.
 *  Parameter:
 *      lppMessage: pointer to the pointer to the block 
 *                  of memory allocated for the message.
 */

void FreeMessage(lpSPlusMessage far * lppMessage)
{  
HANDLE hglb;   
    if ((*lppMessage)->lpszSubject !=NULL)
    {   
    /*allocate memory for the subject*/ 
        hglb=GlobalPtrHandle((LPSTR)((*lppMessage)->lpszSubject));
        GlobalUnlock(hglb);
        GlobalFree(hglb); 
    }

    if ((*lppMessage)->lpszNoteText !=NULL)
    {   
    /*allocate memory for the NoteText*/ 
        hglb=GlobalPtrHandle((LPSTR)((*lppMessage)->lpszNoteText));
        GlobalUnlock(hglb);
        GlobalFree(hglb); 
    }
    if ((*lppMessage)->lpszMessageType !=NULL)
    {   
    /*allocate memory for the MessageType*/ 
        hglb=GlobalPtrHandle((LPSTR)((*lppMessage)->lpszMessageType));
        GlobalUnlock(hglb);
        GlobalFree(hglb); 
    }
    if ((*lppMessage)->lpszDateReceived !=NULL)
    {   
    /*allocate memory for the DateReceived*/ 
        hglb=GlobalPtrHandle((LPSTR)((*lppMessage)->lpszDateReceived));
        GlobalUnlock(hglb);
        GlobalFree(hglb); 
    }
    if ((*lppMessage)->lpszConversationID !=NULL)
    {   
    /*allocate memory for the ConversationID*/ 
        hglb=GlobalPtrHandle((LPSTR)((*lppMessage)->lpszConversationID));
        GlobalUnlock(hglb);
        GlobalFree(hglb); 
    }
    /* Free the memory allocated for the Originator if neccessary */
    if ((*lppMessage)->lpOriginator!=NULL)
        FreeRecipients(&(*lppMessage)->lpOriginator, 1L);
    /* Free the memory allocated for the Recipients if neccessary */
    if ((*lppMessage)->lpRecips!=NULL)
        FreeRecipients(&(*lppMessage)->lpRecips, (*lppMessage)->nRecipCount);
    /* Free the memory allocated for the SentFor recipients if neccessary */
    if ((*lppMessage)->lpSentFor!=NULL)
        FreeRecipients(&(*lppMessage)->lpSentFor, (*lppMessage)->nSentForCount);
    
    /* Free the message memory */

    hglb=GlobalPtrHandle((LPSTR)(*(lppMessage)));
    GlobalUnlock(hglb);
    GlobalFree(hglb);
}  

