#include <windows.h>
#include <string.h> 
#include "mapi.h"
#include "SPLUS.h"
#include "salmain.h"



extern ULONG ulSaveAppt_Service(char far *,char far *, char far *, BOOL);
extern ULONG ulSaveTask_Service(char far *, char far *, char far *); 
extern ULONG ulReadUserInfo_Service(char far *, char far *);


/*  New Appt(create appt) dlg box procedure.
 *  This procedure handles messsages to the 
 *  dlg Box 
 */
BOOL FAR PASCAL dlgCAProc( HWND hwndDlg, 
                           unsigned msg, 
                           UINT wParam, 
                           LONG lParam)
{
char szDateStart[20];
char szDateEnd[20]; 
char szText[100];
BOOL fAddAttButton;

switch ( msg )
  {
    case WM_INITDIALOG:
        SetFocus(GetDlgItem(hwndDlg,IDC_TEXT));
        break;
    case WM_COMMAND:
        switch (wParam)
        {
            case IDOK:    
            SendMessage(GetDlgItem(hwndDlg,IDC_TEXT),
                        WM_GETTEXT,100,
                        (LONG)((LPSTR)szText));
            SendMessage(GetDlgItem(hwndDlg,IDC_SDATE),
                        WM_GETTEXT,20,
                        (LONG)((LPSTR)szDateStart));
            SendMessage(GetDlgItem(hwndDlg,IDC_EDATE),
                        WM_GETTEXT,20,
                        (LONG)((LPSTR) szDateEnd)); 
            fAddAttButton=FALSE;
            ulSaveAppt_Service((char far *)szText,(char far *)szDateStart,
                         (char far *)szDateEnd,
                         fAddAttButton);
            EndDialog(hwndDlg, TRUE);
            return(TRUE);
            break;
            case IDCANCEL:
            EndDialog(hwndDlg, TRUE);   
            return(TRUE);
            case IDC_ADDATTENDEES:
            SendMessage(GetDlgItem(hwndDlg,IDC_TEXT),
                        WM_GETTEXT,100,
                        (LONG)((LPSTR)szText));
            SendMessage(GetDlgItem(hwndDlg,IDC_SDATE),
                        WM_GETTEXT,20,
                        (LONG)((LPSTR)szDateStart));
            SendMessage(GetDlgItem(hwndDlg,IDC_EDATE),
                        WM_GETTEXT,20,
                        (LONG)((LPSTR)szDateEnd)); 
            fAddAttButton=TRUE;
            ulSaveAppt_Service((char far*)szText,(char far *)szDateStart,
                         (char far *)szDateEnd,
                         fAddAttButton);
            EndDialog(hwndDlg, TRUE);           
            break;    
        } 
    default:
        return(FALSE);                 
    }
 
return(FALSE);
}     


/*  New Task(create task) dlg box procedure.
 *  This procedure handles messsages to the 
 *  dlg Box */

BOOL FAR PASCAL dlgCTProc( HWND hwndDlg, 
                           unsigned msg, 
                           UINT wParam, 
                           LONG p2)
{
char szText[60];
char szProjectName[60];
char szPriority[10];

switch ( msg )
  {
    case WM_INITDIALOG:
        SetFocus(GetDlgItem(hwndDlg,IDC_TNAME));
        break;
    case WM_COMMAND:
        switch (wParam)
        {
            case IDOK:    
            SendMessage(GetDlgItem(hwndDlg,IDC_TNAME),
                        WM_GETTEXT,60,
                        (LONG)((LPSTR)szText));
            SendMessage(GetDlgItem(hwndDlg,IDC_PNAME),
                        WM_GETTEXT,60,
                        (LONG)((LPSTR)szProjectName)); 
            SendMessage(GetDlgItem(hwndDlg,IDC_TPRIORITY),
                        WM_GETTEXT,10,
                        (LONG)((LPSTR)szPriority)); 
            ulSaveTask_Service((char far *)szText,
                         (char far *)szProjectName,
                         (char far *)szPriority);
            EndDialog(hwndDlg, TRUE);
            return(TRUE);
            break;
            case IDCANCEL:
            EndDialog(hwndDlg, TRUE);   
            return(TRUE);
        } 
    default:
        return(FALSE);                 
    }
 
return(FALSE);
}   

/*  User Info dlg box procedure.
 *  This procedure handles messsages 
 *  to the dlg Box */

BOOL FAR PASCAL dlgUIProc( HWND hwndDlg, 
                           unsigned msg, 
                           UINT wParam, 
                           LONG p2)
{
char szName[20];
char szAddress[40];

switch ( msg )
  {
    case WM_INITDIALOG:
        SetFocus(GetDlgItem(hwndDlg,IDC_NAME));
        break;
    case WM_COMMAND:
        switch (wParam)
        {
            case IDOK:    
            SendMessage(GetDlgItem(hwndDlg,IDC_NAME),
                        WM_GETTEXT,20,
                        (LONG)((LPSTR)szName));
            SendMessage(GetDlgItem(hwndDlg,IDC_ADDRESS),
                        WM_GETTEXT,40,
                        (LONG)((LPSTR)szAddress)); 
            ulReadUserInfo_Service((char far *)szName,(char far *)szAddress);
            EndDialog(hwndDlg, TRUE);
            return(TRUE);
            break;
            case IDCANCEL:
            EndDialog(hwndDlg, TRUE);   
            return(TRUE);
        } 
    default:
        return(FALSE);                 
    }
 
return(FALSE);
}
 
/*  Display User Info dlg box procedure.
 *  This procedure handles messsages to the dlg Box.
 *  lParam contains the pointer to the UserInfo structure 
 *  (initialized in DlgBoxParam)
*/

BOOL FAR PASCAL dlgDUIProc( HWND hwndDlg, 
                            unsigned msg, 
                            UINT wParam, 
                            LONG lParam)
{   
SPlusUserInfo far * lpUserInfo;
switch ( msg )
  {
    case WM_INITDIALOG: 
    {    
        lpUserInfo=(SPlusUserInfo far *)lParam;
        SendMessage(GetDlgItem(hwndDlg,IDC_UTYPE),
                    WM_SETTEXT,25,
                    (LPARAM)lpUserInfo->lpszUserType); 
        if (lpUserInfo->flFlags== SPLUS_BOSS_WANTS_COPY )
            SendMessage(GetDlgItem(hwndDlg,IDC_CBOSS),
                        WM_SETTEXT,4,
                        (LPARAM)(char far *)"YES"); 
        else
            SendMessage(GetDlgItem(hwndDlg,IDC_CBOSS),
                        WM_SETTEXT,4,
                        (LPARAM)(char far *)"NO");
        if (lpUserInfo->lpAssistant) 
            SendMessage(GetDlgItem(hwndDlg,IDC_ASSIST),
                        WM_SETTEXT,15,
                        (LPARAM)(lpUserInfo->lpAssistant->lpszName)); 
        else 
            SendMessage(GetDlgItem(hwndDlg,IDC_ASSIST),
                        WM_SETTEXT,15,
                        (LPARAM)( char far *)"(No assistant)"); 

        SendMessage(GetDlgItem(hwndDlg,IDC_DSTART),
                    WM_SETTEXT,15,
                    (LPARAM)lpUserInfo->lpszStartTime); 
        SendMessage(GetDlgItem(hwndDlg,IDC_DEND),
                    WM_SETTEXT,15,
                    (LPARAM)lpUserInfo->lpszEndTime); 
    }
        
    case WM_COMMAND:
        if (wParam==IDOK)    
                EndDialog(hwndDlg, TRUE); 
    default:
        return(FALSE);                 
    }
 
return(FALSE);
}



/* Read Meeting Request dlg box procedure.
 This procedure handles messsages to the dlg Box.
 lParam contains the pointer to the ApptMsg struct
 initialized in vReadRqst_Service
*/

BOOL FAR PASCAL dlgRMProc( HWND hwndDlg, unsigned msg, UINT wParam, ULONG lParam)
{   

ApptMsg FAR * lpTempApptMsg;
char TmpBuf[256] = "";
char far * lpTmpBuf = &TmpBuf[0];

switch (msg)
  {
    case WM_INITDIALOG: 
    {    
        lpTempApptMsg =(lpApptMsg)lParam;
        
        /* build the WHEN: description from the appt's Start and End date*/
        
        ( _fstrcpy( lpTmpBuf, lpTempApptMsg->lpAppt->lpszDateStart ) );
        ( _fstrcat( lpTmpBuf, (char far *) "   TO   ") );
        ( _fstrcat( lpTmpBuf,lpTempApptMsg->lpAppt->lpszDateEnd ) ); 
        
        SetDlgItemText( hwndDlg,IDC_FROM_SET, lpTempApptMsg->lpMsg->lpOriginator->lpszName );
        SetDlgItemText( hwndDlg,IDC_SENTFOR_SET, lpTempApptMsg->lpSentFor->lpszName );
        SetDlgItemText( hwndDlg,IDC_WHEN_SET, lpTmpBuf );
        SetDlgItemText( hwndDlg,IDC_SUB_SET, lpTempApptMsg->lpMsg->lpszSubject );
        SetDlgItemText( hwndDlg,IDC_DESC_SET, lpTempApptMsg->lpMsg->lpszNoteText );

    return(FALSE);
    break;
    }
        
    case WM_COMMAND:
        
        /* return the button that was pressed in the dialog */
        
        switch (wParam)
        {
           case ID_RM_CANCEL:    
                EndDialog(hwndDlg, CANCEL);
                return(TRUE);
                break;
            case ID_RM_ACCEPT:    
                EndDialog(hwndDlg, ACCEPT);
                return(TRUE);
                break;
            case ID_RM_DECLINE:
                EndDialog(hwndDlg, DECLINE);
                return(TRUE);
                break;
        } 
    default:
        return(FALSE);
    }
 
return(FALSE);
}


 
/*  About dlg box procedure.
 *  This procedure handles messsages to the 
 *  dlg Box 
 */
BOOL FAR PASCAL About(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
    switch (message) {
        case WM_INITDIALOG:
            return (TRUE);

        case WM_COMMAND:
        if (wParam == IDOK
                || wParam == IDCANCEL) {
                EndDialog(hDlg, TRUE);
                return (TRUE);
            }
            break;
    }
    return (FALSE);
}
