(* Coding by the Hit M/N of New Age *)
program FCDisplay; (* Display .MAP .U .PAL *)
uses dos,crt;

var
  T, T2: file of Byte;
  A, B, C: Integer;
  S: Byte;
  Pal: Array[1..768] of Byte;
begin
  if ParamCount <> 2 then
  begin
    Clrscr;
    Writeln('FCDisplay  Displays Future Crew''s .MAP and .U files');
    Writeln;
    Writeln('  Usage:  FCDISP palette screen');
    Writeln;
    Writeln('  palette is the screen palette (MUST be 768 bytes)');
    Writeln('  screen is the raw screen data (USUALLY 64,000 bytes)');
    Writeln;
    Writeln('   example with PANIC:  FCDISP MONSTER.PAL MONSTER.U');
    writeln;
    halt;
  end;

  assign(t, paramstr(1));
  reset(t);
  assign(t2, paramstr(2));
  reset(t2);

  asm (* 320x200x256 mode *)
    mov ax,0013h
    int 10h
  end;

  A := 0;  (* Read Palette Data *)
  repeat
    inc(a);
    read(t, s);
    pal[a] := s;
  until eof(t);

  asm  (* Write Palette to VGA Card *)
    mov dx,offset Pal
    mov ax,1012h
    mov bx,0
    mov cx,255
    int 10h
  end;

  A := 0;  (* Read Screen Data *)
  repeat
    inc(A);
    read(T2, S);
    mem[$A000:A] := S;  (* Output to generic VGA port *)
  until eof(t2);

  repeat until readkey=#13;  (* wait for enter *)

  close(t);
  close(t2);

  asm  (* 80x25x16 text mode *)
    mov ax,0003h
    int 10h;
  end;
end.
