; keycode.asm 7/20/93 sat
;
; Changes Soft-ICE/Bounds-Checker keycode tables for foreign keyboards
;
; Syntax:
;       keycode s-ice xxxxxx
;   or
;       keycode bchk xxxxxx
;   or
;       keycode winice xxxxxx
;   or
;       keycode bchkw xxxxxx
;
;   where xxxxxx is a keycode file with the extension ".key".
;   legitimate keycode file names:
; england.key     germany.key     canada.key      france.key      denmark.key
; holland.key     sweden.key      norway.key      suisse.key      spain.key
; portugal.key    italy.key       latin.key       czech.key       poland.key
; slovak.key      hungary.key
;
;******************************************************************************
.386
code    segment Public USE16 'code'
        assume cs:code, ds:code, es:code, ss:NOTHING
        org 100H
;******************************************************************************
start:
; Set up stack
        lea     sp,stack_top
;
;*******************************************************
; Get the file names from the command line
;*******************************************************
;
; Get the name of the Nu-Mega file
;
        mov     si,82h
        lea     di,filename
store_file_name:
        lodsb
        or      al,20H          ;make it lower case
        stosb
        cmp     al,' '
        jne     short store_file_name
; Null terminate it
        dec     di
        mov     byte ptr [di],0
        mov     bx,di
;
;***************************************
; Get the name of the keycode file
        lea     di,key_file
store_key_name:
        lodsb
        cmp     al,' '
        je      short store_key_name
        stosb
        cmp     al,13
        jne     short store_key_name
; Null terminate it
        dec     di
        mov     byte ptr [di],0
        mov     cx,di
;
;*******************************************************
; Add extensions if omitted
;*******************************************************
; If keycode file has no extension, make it .KEY
;
        lea     di,key_file
        sub     cx,di
        mov     al,'.'
        repne   scasb
        je      short check_if_windows
        lea     si,zkey
        mov     cx,5
        rep     movsb
;
;***************************************
; Check if Windows products
;
check_if_windows:
; Check if "winice"
        lea     di,filename
        lea     si,zwinice
        mov     cx,6
        repe    cmpsb
        je      short set_windows_flag
; If not, check if "bchkw"
        lea     di,filename
        lea     si,zbchkw
        mov     cx,5
        repe    cmpsb
        jne     short key_ext_found
; If "bchkw", make it ".386"
        lea     si,z386
        mov     cx,5
        add     bx,cx
        rep     movsb
; Set flag for Windows product
set_windows_flag:
        inc     byte ptr windows
; Set to search for different string
        mov     search_length,4
        lea     si,windows_string
        lea     di,search_string
        mov     cx,4
        rep     movsb
;
;***************************************
; If Nu-Mega file has no extension, make it .EXE
;
key_ext_found:
        lea     di,filename
        mov     cx,bx
        sub     cx,di
        repne   scasb
        je      short exe_ext_found
        lea     si,zexe
        mov     cx,5
        rep     movsb
;
;*******************************************************
; Read the files: keycode first, then Nu-Mega file
;*******************************************************
; Try to open the keycode file
;
exe_ext_found:
        lea     dx,key_file
        mov     ax,3d00h
        int     21h
        jnc     short key_file_open_ok
; Unable to open file
        lea     si,zutof
        call    message
        lea     si,key_file
        call    message
        mov     ax,4c01h
        int     21h
key_file_open_ok:
        mov     file_handle,ax
;
;***************************************
; Read keycode file
        mov     bx,ax
        mov     cx,356
        lea     dx,keycode_buffer
        mov     ah,3fh
        int     21h
;
; Close it
        mov     bx,file_handle
        mov     ah,3eh
        int     21h
;
;***************************************
; Try to open the Nu-Mega file
;
        lea     dx,filename
        mov     ax,3d00h
        int     21h
        jnc     short exe_file_open_ok
; Unable to open file
        lea     si,zutof
        call    message
        lea     si,filename
        call    message
        mov     ax,4c01h
        int     21h
exe_file_open_ok:
        mov     file_handle,ax
;
;***************************************
; Set pointer to buffer start
;
        lea     di,buffer_start
        call    normalize_di
        mov     file_offset,di
        mov     file_segment,es
; Save it as a flat address
;
;***************************************
; Set up to read file from disk
;
; Get the length of the file
        mov     bx,file_handle
        xor     cx,cx
        xor     dx,dx
        mov     ax,4202h
        int     21h
        mov     file_length_lo,ax
        mov     file_length_hi,dx
; Set pointer back to start
        xor     dx,dx
        mov     ax,4200h
        int     21h
; Get length of file
        mov     ebp,file_size
        lds     si,file_pointer
;
;***************************************
; Read file into buffer
;
read_next_block:
        mov     ecx,7000h
        cmp     ebp,ecx
        jae     short not_last_block
        mov     cx,bp
not_last_block:
        mov     dx,si
        mov     bx,cs:file_handle
        mov     ah,3fh
        int     21h
; Update pointers
        movzx   eax,ax
        sub     ebp,eax
; Update data segment
        add     si,ax
        call    normalize_si
; End of file?
        test    ebp,ebp
        jne     short read_next_block
;
; Close the file
        push    cs
        pop     ds
        mov     bx,file_handle
        mov     ah,3eh
        int     21h
;
;*******************************************************
; Search for the string "KBD TABLE"
;*******************************************************
;
; Begin search
start_search:
        les     di,file_pointer
        mov     ebp,file_size
start_search_loop:
        test    ebp,ebp
        je      string_not_found
        call    normalize_di
        mov     ecx,7000h
        cmp     ecx,ebp
        jbe     short search_size_set
        mov     cx,bp
; Look for first byte in string
search_size_set:
        sub     ebp,ecx
continue_search:
        mov     al,search_string
        repne   scasb
        jne     short start_search_loop
        
; First character matches, check rest of string
check_rest_of_string:
        mov     ax,di
        mov     bx,cx
        dec     di
        lea     si,search_string
        mov     cx,search_length
        repe    cmpsb
        mov     cx,bx
        xchg    ax,di
        jne     short continue_search
;
;*******************************************************
; Replace the keycode table
;*******************************************************
;
        mov     di,ax
        lea     si,keycode_buffer
; 4 tables of 88 bytes each (58H)
        mov     bx,4
; Replace only the printing characters in one table
write_next_table:
        mov     dx,3
write_next_group:
; 3 blocks of skip 2 and copy 12
        inc     di
        inc     si
        inc     di
        inc     si
        mov     cx,12
        rep     movsb
        dec     dx
        jne     short write_next_group
; 1 block of skip 1 and copy 11
        inc     di
        inc     si
        mov     cx,11
        rep     movsb
; Skip next 35
        add     di,35
        add     si,35
        dec     bx
        jne     short write_next_table
;
;*******************************************************
; Write the file back to disk. 
;*******************************************************
; Create new file for writing
;
        lea     dx,filename
        xor     cx,cx
        mov     ah,3ch
        int     21h
        mov     file_handle,ax
;
;***************************************
; Write file back to disk
;
        mov     ebp,file_size
        lds     si,file_pointer
write_file:
        mov     ecx,7000h
        cmp     ebp,ecx
        jae     short write_next_block
        mov     cx,bp
write_next_block:
        mov     dx,si
        mov     bx,cs:file_handle
        mov     ah,40h
        int     21h
        movzx   eax,ax
        sub     ebp,eax
; Update data segment
        add     si,ax
        call    normalize_si
; End of file?
        test    ebp,ebp
        jne     short write_file
;
; Close file
        push    cs
        pop     ds
        mov     bx,file_handle
        mov     ah,3eh
        int     21h
; Terminate
        mov     ax,4c00h
        int     21h
;
string_not_found:
        lea     si,zktnf
        call    message
        mov     ax,4c02h
        int     21h
;
;***************************************************************
; This section has the procedures called by the main routine
; above.
;***************************************************************
crlf:
        mov     dl,13
        call    print_char
        mov     dl,10
;***************************************************************
; Print a character in dl
print_char:
        mov     ah,2
        int     21h
        ret
;
;***************************************************************
; Print a null-terminated message in DS:SI
;
message_loop:
        mov     dl,al
        call    print_char
; Entry point
message:
        lodsb
        cmp     al,0
        jne     short message_loop
        ret
;***************************************
; Print a null-terminated in CS:DX
display_message:
;
; Preserve DS & SI
        push    ds
        push    si
; Get address of message
        push    cs
        pop     ds
        mov     si,dx
        call    message
; Restore DS & SI
        pop     si
        pop     ds
        ret
;
;***************************************
; Process DS:SI to make SI between 8000 & 800FH
;
normalize_si:
        push    ax
; Make it a 20-bit address
        xor     eax,eax
        mov     ax,ds
        shl     eax,4
        movzx   esi,si
        add     eax,esi
; Normalize si
        and     si,0fh
        cmp     eax,8000h
        jb      normalize_si_32
        add     si,8000h
normalize_si_32:
        sub     eax,esi
        shr     eax,4
        mov     ds,ax
        pop     ax
        ret
;
;***************************************
; Process ES:DI to make DI between 8000 & 800F
;
normalize_di:
        push    ax
; Make it a 20-bit address
        xor     eax,eax
        mov     ax,es
        shl     eax,4
        movzx   edi,di
        add     eax,edi
; Normalize di
        and     di,0fh
        cmp     eax,8000h
        jb      normalize_di_32
        add     di,8000h
normalize_di_32:
        sub     eax,edi
        shr     eax,4
        mov     es,ax
        pop     ax
        ret
;
;******************************************************************************
; Data block
;
windows db 0
;
key_file db 80 dup(0)
;
filename db 80 dup(0)
file_handle dw 0
file_size label dword
file_length_lo dw 0
file_length_hi dw 0
file_pointer label dword
file_offset dw 0
file_segment dw 0
;
;***************************************
;
;***************************************
; Data block for search
search_length dw 9
search_string db 'KBD TABLE'
windows_string db 'SIWK'
;
;***************************************
; data block for change
change_address dd 0
;
;***************************************
; Messages
;
zutof   db 13,10,'Unable to open file ',0
zktnf   db 13,10,'Keycode table not found',0
zwinice db 'winice'
zbchkw  db 'bchkw'
z386    db '.386',0
zexe    db '.EXE',0
zkey    db '.KEY',0
;
;***************************************
;
; Stack
          dw 1024 dup(0)
stack_top dw 0
;
;***************************************
; Buffer for storing keycode file
keycode_buffer db 356 dup(0)
;
;***************************************
; Buffer for storing files
buffer_start:
;
;******************************************************************************
code    ends
        end     start
