; germany.asm
;
; Soft-ICE keycode data for german keyboard
;
code    segment 'CODE'
        assume cs:code,ds:code,es:code
        org 100h
;
;------------------------------------------------------------------------------
; The following codes are used by Soft-ICE and should not be replaced
;
NUL   EQU     0         ;Null
CSRT  EQU     1         ;Cursor Right           Right Arrow
CSLT  EQU     2         ;Cursor Left            Left Arrow
WNDN  EQU     4         ;Window Down            Ctrl Down Arrow
WNUP  EQU     5         ;Window Up              Ctrl Up Arrow
WNLT  EQU     6         ;Window Left            Ctrl Left Arrow
WNRT  EQU     7         ;Window Right           Ctrl Right Arrow
BKSP  EQU     8         ;Backspace
TAB   EQU     9         ;Tab
CSDN  EQU    0AH        ;Cursor Down            Down Arrow
DEL   EQU    0BH        ;Delete
INS   EQU    0CH        ;Insert
ENTR  EQU    0DH        ;Enter
PGDN  EQU    0EH        ;Page Down
UNSD  EQU    0FH        ;Unused (Reserved)
PGUP  EQU    10H        ;Page Up
HOME  EQU    11H        ;Home
CPLK  EQU    12H        ;CapsLock
NMLK  EQU    13H        ;NumLock
CSUP  EQU    15H        ;Cursor Up              Up Arrow
SCDN  EQU    16H        ;Screen Down            Shift Down Arrow
END_  EQU    17H        ;End
WSMR  EQU    18H        ;Window Smaller         Alt Down Arrow
SCUP  EQU    19H        ;Screen Up              Shift Up Arrow
WLGR  EQU    1AH        ;Window Larger          Alt Up Arrow
ESCP  EQU    1BH        ;Escape
SREQ  EQU    1CH        ;Sys Req
SPC   EQU    20H        ;Space
F1    EQU   0B0H        ;F1
F2    EQU   0B1H        ;F2
F3    EQU   0B2H        ;F3
F4    EQU   0B3H        ;F4
F5    EQU   0B4H        ;F5
F6    EQU   0B5H        ;F6
F7    EQU   0B6H        ;F7
F8    EQU   0B7H        ;F8
F9    EQU   0B8H        ;F9
F10   EQU   0B9H        ;F10
F11   EQU   0BAH        ;F11
F12   EQU   0BBH        ;F12
PTSC  EQU   0BCH        ;Prt SC                 ;Ctrl P
SHFT  EQU   0BEH        ;Shift
CTRL  EQU   0BFH        ;Ctrl
ALT   EQU   0C0H        ;Alt
NU    EQU   0FFH        ;Not Used (Reserved)
;
;------------------------------------------------------------------------------
;
entry:
; unshifted
        db NU,ESCP,"1234567890'",BKSP,TAB
        db 'qwertzuiop+',ENTR,CTRL
        db "asdfghjkl#",SHFT
        db '<yxcvbnm,.-',SHFT
        db '*',ALT,SPC,CPLK
        db F1,F2,F3,F4,F5,F6,F7,F8,F9,F10
        db NMLK,NU
        db HOME,CSUP,PGUP,'-',CSLT,NUL,CSRT,'+',END_,CSDN,PGDN,INS,DEL
        db SREQ,NU,NU,F11,F12
;shifted
        db NU,ESCP,'!"#$%&/()=?`',BKSP,TAB
        db 'QWERTZUIOP*',ENTR,NU
        db 'ASDFGHJKL`',NU
        db '>ZXCVBNM;:_',NU
        db '*',ALT,SPC,CPLK
        db F1,F2,F3,F4,F5,F6,F7,F8,F9,F10
        db NMLK,NU
        db HOME,SCUP,PGUP,'-',CSLT,NUL,CSRT,'+',END_,SCDN,UNSD,INS,DEL
        db SREQ,NU,NU,F11,F12
;ctrl
        db NU,ESCP,"123456{[]}\'",BKSP,TAB
        db '@WERTZUIO',PTSC,'~',ENTR,NU
        db "ASDFGHJKL`",NU
        db '|ZXCVBN;:_',NU
        db '*',ALT,SPC,CPLK
        db F1,F2,F3,F4,F5,F6,F7,F8,F9,F10
        db NMLK,NU
        db HOME,WNUP,PGUP,'-',WNLT,NU,WNRT,'+',NU,WNDN,UNSD,INS,DEL
        db SREQ,NU,NU,F11,F12
;alt
        db NU,ESCP,"1234567890'",BKSP,TAB
        db '@wertzuiop+',ENTR,CTRL
        db "asdfghjkl#",SHFT
        db '<yxcvbnm,.-',SHFT
        db '*',ALT,SPC,CPLK
        db F1,F2,F3,F4,F5,F6,F7,F8,F9,F10
        db NMLK,NU
        db HOME,WLGR,PGUP,'-',CSLT,NU,CSRT,'+',NU,WSMR,UNSD,INS,DEL
        db SREQ,NU,NU,F11,F12
;
code    ends
        end entry
