; be.asm 5/6/93 sat
;
; binary file editor
;
;******************************************************************************
; VALID COMMANDS:
; h help screen
; q quit (exit)
; w write contents of memory to file
; l show length of file
; d display contents of address:
;   d                               display current address in current format
;   db (address)                    display in byte format: address optional
;   dw (address)                    display in word format: address optional
;   dd (address)                    display in dword format: address optional
; s search for pattern:
;   sb b1 b2 b3...                  search for bytes b1 b2 b3...
;   sw www1 www2 www3...            search for words www1 www2...
;   sd ddddddd1 ddddddd2..          search for dwords ddddddd1 ddddddd2...
;   ss '....'                       search for text string '....'
; c change contents of address:
;   cb address b1 b2 b3..           change to bytes b1 b2 b3...
;   cw address www1 www2 www3...    change to words www1 www2 www3...
;   cd address ddddddd1 ddddddd2... change to dwords ddddddd1 ddddddd2...
;   cs address '.....'              change to text string '.....'
; e change contents of address: (added for compatibility with DEBUG)
;   eb address b1 b2 b3..           change to bytes b1 b2 b3...
;   ew address www1 www2 www3...    change to words www1 www2 www3...
;   ed address ddddddd1 ddddddd2... change to dwords ddddddd1 ddddddd2...
;   es address '.....'              change to text string '.....'
; i insert data at address:
;   ib address b1 b2 b3..           insert bytes b1 b2 b3...
;   iw address www1 www2 www3...    insert words www1 www2 www3...
;   id address ddddddd1 ddddddd2... insert dwords ddddddd1 ddddddd2...
;   is address '.....'              insert text string '.....'
; r remove bytes at address:
;   r address #                     remove # bytes starting at address
;       
;******************************************************************************
public  absolute_ds
public  absolute_es
public  back_offset
public  back_pointer
public  back_segment
public  back_start
public  buffer_start
public  calculate_address
public  change_address
public  change_byte
public  change_dword
public  change_file
public  change_string
public  change_word
public  command_list
public  command_routine
public  crlf
public  display_0
public  display_1
public  display_address
public  display_block
public  display_block_byte
public  display_block_byte_loop
public  display_block_dword
public  display_block_dword_loop
public  display_block_exit
public  display_block_exit_0
public  display_block_no_address
public  display_block_no_format
public  display_block_set_format
public  display_block_word
public  display_block_word_loop
public  display_byte
public  display_dword
public  display_format
public  display_length
public  display_message
public  display_start
public  display_word
public  end_of_line
public  end_of_line_control
public  end_of_line_loop
public  exit_no_change
public  filename
public  file_handle
public  file_length_hi
public  file_length_lo
public  file_size
public  file_start
public  find_address
public  find_address_loop
public  find_address_loop_0
public  front_offset
public  front_pointer
public  front_segment
public  get_address
public  get_address_error
public  get_add_byte
public  get_add_dword
public  get_add_string
public  get_add_word
public  get_byte
public  get_byte_error
public  get_dword
public  get_dword_error
public  get_hex
public  get_hex_exit
public  get_hex_loop
public  get_hex_numeric
public  get_next_command
public  get_next_command_loop
public  get_size
public  get_string
public  get_string_error
public  get_string_exit
public  get_string_loop
public  get_word
public  get_word_error
public  got_hex
public  help_screen
public  hex_digit
public  hex_digit_0
public  ignore_leading_space
public  input_buffer
public  input_length
public  input_string
public  insert_byte
public  insert_data
public  insert_dword
public  insert_string
public  insert_word
public  message
public  message_loop
public  normalize_di
public  normalize_di_32
public  normalize_si
public  normalize_si_32
public  not_last_block
public  obj_file_open_ok
public  print_char
public  read_next_block
public  remove_bytes
public  restack_to_back
public  restack_to_back_loop
public  save_back_pointer
public  search_count
public  search_count_ok
public  search_forward
public  search_for_byte
public  search_for_dword
public  search_for_string
public  search_for_word
public  search_length
public  search_size_set
public  search_string
public  show_address
public  show_length
public  stack_top
public  start
public  start_change
public  start_insert
public  start_of_line
public  start_search
public  start_search_loop
public  store_obj_name
public  syntax_error
public  try_next_command
public  write_file
public  write_file_to_disk
public  write_next_block
public  zse
public  zutof
;******************************************************************************
.386
code    segment Public USE16 'code'
        assume cs:code, ds:code, es:code, ss:NOTHING
        org 100H
;******************************************************************************
start:
; Set up stack
        lea     sp,stack_top
;
; Get the name of the file
;
        mov     si,82h
        lea     di,filename
store_obj_name:
        lodsb
        stosb
        cmp     al,13
        jne     short store_obj_name
; Null terminate it
        mov     byte ptr [di - 1],0
;
;***************************************
; Try to open the file
;
        lea     dx,filename
        mov     ax,3d00h
        int     21h
        jnc     short obj_file_open_ok
; Unable to open file
        lea     si,zutof
        call    message
        lea     si,filename
        call    message
        mov     ax,4c01h
        int     21h
obj_file_open_ok:
        mov     file_handle,ax
;
;***************************************
; Set pointer to buffer start
;
        lea     di,buffer_start
        dec     di
        or      di,0fh
        inc     di
        call    normalize_di
        mov     front_offset,di
        mov     front_segment,es
; Save it as a flat address
        call    absolute_es
        mov     file_start,eax
;
;***************************************
; Set up to read file from disk
;
;
; Get the length of the file
        mov     bx,file_handle
        xor     cx,cx
        xor     dx,dx
        mov     ax,4202h
        int     21h
        mov     file_length_lo,ax
        mov     file_length_hi,dx
; Set pointer back to start
        xor     dx,dx
        mov     ax,4200h
        int     21h
; Get length of file
        mov     di,file_length_lo
        mov     bp,file_length_hi
        lds     si,front_pointer
;
;***************************************
; Read file into buffer
;
read_next_block:
        mov     cx,7000h
        test    bp,bp
        jne     short not_last_block
        cmp     di,cx
        jae     short not_last_block
        mov     cx,di
not_last_block:
        mov     dx,si
        mov     bx,cs:file_handle
        mov     ah,3fh
        int     21h
; Update pointers
        sub     di,ax
        sbb     bp,0
; Update data segment
        add     si,ax
        call    normalize_si
; End of file?
        test    di,di
        jne     short read_next_block
        test    bp,bp
        jne     short read_next_block
; Save pointer
        mov     cs:front_segment,ds
        push    cs
        pop     ds
        mov     front_offset,si
;
; Close the file
        mov     bx,file_handle
        mov     ah,3eh
        int     21h
;
; Set back buffer to empty
        les     di,front_pointer
        xor     si,si
        mov     ax,9b00h
        mov     ds,ax
;
;*******************************************************
; This gets and processes commands
;*******************************************************
; Save back pointer
save_back_pointer:
        call    normalize_si
        mov     cs:back_offset,si
        mov     cs:back_segment,ds
; Save front_pointer
        call    normalize_di
        mov     cs:front_offset,di
        mov     cs:front_segment,es
;
; Restack to back of memory
restack_to_back:
        les     di,cs:back_pointer
        lds     si,cs:front_pointer
        std
restack_to_back_loop:
        call    absolute_ds
        cmp     eax,cs:file_start
        jb      short get_size
        movsb
        cmp     si,2000H
        ja      short restack_to_back_loop
        call    normalize_si
        call    normalize_di
        jmp     short restack_to_back_loop
;
; Get size & save
get_size:
        inc     si
        mov     cs:front_segment,ds
        push    cs
        pop     ds
        mov     front_offset,si
        inc     di
        mov     ebx,9b000h
        call    absolute_es
        sub     ebx,eax
        mov     file_size,ebx
        mov     back_start,eax
; Save start address
        call    normalize_di
        mov     back_offset,di
        mov     back_segment,es
;
; Get next command
get_next_command:
        cld
        mov     ax,cs
        mov     ds,ax
        mov     es,ax
; Display the prompt
        call    crlf
        mov     dl,'*'
        call    print_char
; Clear the buffer
        lea     di,input_string
        mov     cx,80
        xor     ax,ax
        rep     stosb
; get the command string
        lea     dx,input_buffer
        mov     ah,0ah
        int     21h
; Process command
        xor     cx,cx
        mov     cl,input_length
        dec     cx
        dec     cx
        lea     si,input_string
        xor     bx,bx
        lodsb
        or      al,20h
get_next_command_loop:
        cmp     al,command_list[bx]
        jne     try_next_command
        shl     bx,1
        jmp     command_routine[bx]
try_next_command:
        inc     bx
        cmp     byte ptr command_list[bx],0
        jne     get_next_command_loop
;
;*******************************************************
; Syntax error
syntax_error:
        lea     si,zse
help_screen_0:
        call    message
        jmp     short get_next_command
;
;*******************************************************
; Display help screen
;*******************************************************
help_screen:
        lea     si,zhelp
        jmp     short help_screen_0
;
;*******************************************************
; Display length of file (hex)
;*******************************************************
show_length:
        call    crlf
        mov     ebx,9b000h
        sub     ebx,back_start
        rol     ebx,16
        rol     bl,4
        call    display_address
        jmp     short get_next_command
;
;*******************************************************
; Exit back to DOS
;*******************************************************
exit_no_change:
        mov     ax,4c00h
        int     21h
;
;*******************************************************
; This section writes the file back to disk. 
;*******************************************************
write_file_to_disk:
; Create new file for writing
        lea     dx,filename
        xor     cx,cx
        mov     ah,3ch
        int     21h
        mov     file_handle,ax
;
;***************************************
; Write file back to disk
;
        mov     di,file_length_lo
        mov     bp,file_length_hi
        lds     si,back_pointer
write_file:
        mov     cx,7000h
        test    bp,bp
        jne     short write_next_block
        cmp     di,cx
        jae     short write_next_block
        mov     cx,di
write_next_block:
        mov     dx,si
        mov     bx,cs:file_handle
        mov     ah,40h
        int     21h
        sub     di,ax
        sbb     bp,0
; Update data segment
        add     si,ax
        call    normalize_si
; End of file?
        test    di,di
        jne     short write_file
        test    bp,bp
        jne     short write_file
;
; Close file
        push    cs
        pop     ds
        mov     bx,file_handle
        mov     ah,3eh
        int     21h
        jmp     get_next_command
;
;*******************************************************
; Display the current block
;*******************************************************
display_block:
; Default is to display 128 bytes
        mov     display_length,128
; Check if a format was specified
        lodsb
        dec     si
        or      al,20h
        mov     dx,3
        mov     di,2
        cmp     al,'b'
        je      short display_block_set_format
        mov     dx,5
        mov     di,10
        cmp     al,'w'
        je      short display_block_set_format
        mov     dx,9
        mov     di,14
        cmp     al,'d'
        jne     short display_block_no_format
; If so, make it the current format
display_block_set_format:
        mov     display_0,dx
        mov     display_1,di
        mov     display_format,al
        inc     si
; Check if any address was entered
display_block_no_format:
        call    get_hex
        je      short display_block_no_address
        mov     edx,ebx
        shl     ebx,12
        shr     bx,12
        mov     display_start,ebx
; Check if a second address was entered
        call    get_hex
        je      short display_block_no_address
; If so, calculate & store length
        sub     ebx,edx
        jb      syntax_error
        inc     ebx
        mov     display_length,ebx
;
display_block_no_address:
; Get length to display
        mov     ecx,display_length
; Calculate start address
        mov     eax,display_start
        lds     si,back_pointer
        add     si,ax
        shr     eax,16
        mov     bx,ds
        add     ax,bx
        mov     ds,ax
        call    normalize_si
        cmp     cs:display_format,'w'
        je      short display_block_word
        cmp     cs:display_format,'d'
        je      short display_block_dword
; Display in byte format
display_block_byte:
        call    start_of_line
        mov     di,16
display_block_byte_loop:
        lodsb
        mov     bl,al
        call    display_byte
        dec     ecx
        je      short display_block_exit
        dec     di
        jne     short display_block_byte_loop
        mov     di,2
        call    end_of_line
        jmp     short display_block_byte
;
; Display in word format
display_block_word:
        call    start_of_line
        mov     di,8
display_block_word_loop:
        lodsw
        mov     bx,ax
        call    display_word
        sub     ecx,2
        jbe     short display_block_exit
        dec     di
        jne     short display_block_word_loop
        mov     di,10
        call    end_of_line
        jmp     short display_block_word
;
; Display in dword format
display_block_dword:
        call    start_of_line
        mov     di,4
display_block_dword_loop:
        lodsd
        mov     ebx,eax
        call    display_dword
        sub     ecx,4
        jbe     short display_block_exit
        dec     di
        jne     short display_block_dword_loop
        mov     di,14
        call    end_of_line
        jmp     short display_block_dword
;
; Exit        
display_block_exit:
; Do the ASCII display
        dec     di
        je      display_block_exit_0
        mov     ax,cs:display_0
        mul     di
        mov     di,ax
display_block_exit_0:
        add     di,cs:display_1
        call    end_of_line
; Change start address to next address
        call    normalize_si
        call    absolute_ds
        mov     ebx,eax
        lds     si,cs:back_pointer
        call    absolute_ds
        sub     ebx,eax
        shl     ebx,12
        shr     bx,12
        mov     cs:display_start,ebx
        jmp     get_next_command
;
;*******************************************************
; Search for occurrences of a string
;*******************************************************
search_forward:
        add     cx,si
        lea     di,search_string
        mov     search_length,0
; Check if a format was specified
        lodsb
        or      al,20h
        cmp     al,'s'
        je      short search_for_string
        cmp     al,'d'
        je      short search_for_dword
        cmp     al,'w'
        je      short search_for_word
        cmp     al,'b'
        je      short search_for_byte
        dec     si
;
; Get byte to search for
search_for_byte:
        call    get_byte
        je      syntax_error
        jmp     short start_search
;
; Get word to search for
search_for_word:
        call    get_word
        je      syntax_error
        jmp     short start_search
;
; Get dword to search for
search_for_dword:
        call    get_dword
        je      syntax_error
        jmp     short start_search
;
; Get string to search for
search_for_string:
        call    get_string
        je      syntax_error
;
; Begin search
start_search:
        call    crlf
        mov     search_count,9
        les     di,back_pointer
start_search_loop:
; If end of file, all done
        call    normalize_di
        call    absolute_es
        mov     ecx,9b000h
        sub     ecx,eax
        jbe     get_next_command
; Look for first byte in string
        test    cx,cx
        jg      short search_size_set
        mov     cx,4000h
search_size_set:
        mov     al,search_string
        repne   scasb
        jne     short start_search_loop
; First character matches, check rest of string
        push    di
        push    cx
        dec     di
        lea     si,search_string
        mov     cx,search_length
        repe    cmpsb
        pop     cx
        pop     di
        jne     search_size_set
;
; String found, display address
        dec     di
        call    absolute_es
        call    show_address
        inc     di
        dec     search_count
        jne     short search_count_ok
; Reset count if end of line
        call    crlf
        mov     search_count,9
; Check count
search_count_ok:
        test    cx,cx
        jne     short search_size_set
        jmp     short start_search_loop
;
;*******************************************************
; Change contents of file
;*******************************************************
change_file:
        add     cx,si
        lea     di,search_string
        mov     search_length,0
; Check if a format was specified
        lodsb
        or      al,20h
        cmp     al,'s'
        je      short change_string
        cmp     al,'d'
        je      short change_dword
        cmp     al,'w'
        je      short change_word
        cmp     al,'b'
        je      short change_byte
        dec     si
; Byte format
change_byte:
        call    get_add_byte
        je      syntax_error
        jmp     short start_change
;
; Word format
change_word:
        call    get_add_word
        je      syntax_error
        jmp     short start_change
;
; Dword format
change_dword:
        call    get_add_dword
        je      syntax_error
        jmp     short start_change
;
; String format
change_string:
        call    get_add_string
        je      syntax_error
;
start_change:
; Get address of where to start
        call    calculate_address
; Replace the string
        lea     si,search_string
        mov     cx,search_length
        rep     movsb
        jmp     get_next_command
;
;*******************************************************
; Insert data into file (changes length of file)
;*******************************************************
insert_data:
        add     cx,si
        lea     di,search_string
        mov     search_length,0
; Check if a format was specified
        lodsb
        or      al,20h
        cmp     al,'s'
        je      short insert_string
        cmp     al,'d'
        je      short insert_dword
        cmp     al,'w'
        je      short insert_word
        cmp     al,'b'
        je      short insert_byte
        dec     si
; Byte format
insert_byte:
        call    get_add_byte
        je      syntax_error
        jmp     short start_insert
;
; Word format
insert_word:
        call    get_add_word
        je      syntax_error
        jmp     short start_insert
;
; Dword format
insert_dword:
        call    get_add_dword
        je      syntax_error
        jmp     short start_insert
;
; String format
insert_string:
        call    get_add_string
        je      syntax_error
;
start_insert:
; Open space at insertion address
        call    find_address
; Save the insertion address
        push    ds
        push    si
; Insert the string there
        push    cs
        pop     ds
        lea     si,search_string
        mov     cx,search_length
        rep     movsb
; Set up to restack to back
        pop     si
        pop     ds
        dec     si
        dec     di
        jmp     save_back_pointer
;
;*******************************************************
; Remove bytes from file (changes length of file)
;*******************************************************
remove_bytes:
; Get removal address
        add     cx,si
        call    get_address
        je      syntax_error
; Get number of bytes to remove
        call    get_hex
        je      syntax_error
        mov     display_length,eax
; Check if length is within file
        les     di,back_pointer
        call    absolute_es
        add     eax,cs:change_address
        add     eax,ebx
        cmp     eax,9b000h
        ja      syntax_error
; Open space at deletion address
        call    find_address
; Calculate the back address
        call    absolute_ds
        add     eax,cs:display_length
        mov     si,ax
        and     esi,0fh
        or      si,8000h
        sub     eax,esi
        shr     eax,4
        mov     ds,ax
; Fix pointers for restacking back
        dec     si
        dec     di
        jmp     save_back_pointer
; 
;***************************************************************
; This section has the procedures called by the main routine
; above.
;***************************************************************
crlf:
        mov     dl,13
        call    print_char
        mov     dl,10
;***************************************************************
; Print a character in dl
print_char:
        mov     ah,2
        int     21h
        ret
;
;***************************************************************
; Print a null-terminated message in DS:SI
;
message_loop:
        mov     dl,al
        call    print_char
; Entry point
message:
        lodsb
        cmp     al,0
        jne     short message_loop
        ret
;***************************************
; Print a null-terminated in CS:DX
display_message:
;
; Preserve DS & SI
        push    ds
        push    si
; Get address of message
        push    cs
        pop     ds
        mov     si,dx
        call    message
; Restore DS & SI
        pop     si
        pop     ds
        ret
;
;***************************************
; Process DS:SI to make SI between 8000 & 800FH
;
normalize_si:
        push    ax
; Make it a 20-bit address
        call    absolute_ds
; Normalize si
        and     si,0fh
        cmp     eax,8000h
        jb      normalize_si_32
        add     si,8000h
normalize_si_32:
        sub     eax,esi
        shr     eax,4
        mov     ds,ax
        pop     ax
        ret
;
;***************************************
; Convert DS:SI to an absolute address in EAX
;
absolute_ds:
        xor     eax,eax
        mov     ax,ds
        shl     eax,4
        movzx   esi,si
        add     eax,esi
        ret
;
;***************************************
; Process ES:DI to make DI between 8000 & 800F
;
normalize_di:
        push    ax
; Make it a 20-bit address
        call    absolute_es
; Normalize di
        and     di,0fh
        cmp     eax,8000h
        jb      normalize_di_32
        add     di,8000h
normalize_di_32:
        sub     eax,edi
        shr     eax,4
        mov     es,ax
        pop     ax
        ret
;
;***************************************
; Convert ES:DI to an absolute address in EAX
;
absolute_es:
        xor     eax,eax
        mov     ax,es
        shl     eax,4
        movzx   edi,di
        add     eax,edi
        ret
;
;***************************************
; Get a hex number
;
ignore_leading_space:
        lodsb
; Ignore leading spaces
get_hex:
        cmp     byte ptr [si],' '
        je      short ignore_leading_space
; Start at zero
        xor     ebx,ebx
        xor     bp,bp
get_hex_loop:
; Check if decimal
        lodsb
        or      al,20h
; Check if hexadecimal
        cmp     al,'a'
        jb      short get_hex_numeric
        cmp     al,'f'
        ja      short get_hex_exit
        sub     al,57H
        jmp     short got_hex
; Check if numeric
get_hex_numeric:
        sub     al,'0'
        jb      short get_hex_exit
        cmp     al,9
        ja      short get_hex_exit
; Add to previous value
got_hex:
        inc     bp
        shl     ebx,4
        movzx   eax,al
        add     ebx,eax
        jmp     short get_hex_loop
; Exit
get_hex_exit:
; Go back to last character
        mov     eax,ebx
        dec     si
; Test if anything was entered
        test    bp,bp
        ret
;
;***************************************
; Start of display line: display address
start_of_line:
        call    crlf
        mov     bp,si
        call    absolute_ds
show_address:
        mov     ebx,eax
        sub     ebx,cs:back_start
        rol     ebx,16
        rol     bl,4
        call    display_address
        call    print_char
        call    print_char
        ret
;
;***************************************
; End of display line: display ASCII codes
end_of_line:
        mov     dl,' '
        call    print_char
        dec     di
        jne     end_of_line
        xchg    bp,si
end_of_line_loop:
        mov     dl,' '
        lodsb
        cmp     al,'~'
        ja      end_of_line_control
        cmp     al,' '
        jb      end_of_line_control
        mov     dl,al
end_of_line_control:
        call    print_char
        cmp     si,bp
        jne     end_of_line_loop
        ret
;
;***************************************
; Display a hexadecimal number
;
; Display doubleword
display_dword:
        rol     ebx,8
        call    hex_digit
        call    hex_digit
        rol     ebx,8
        call    hex_digit
; Display 5-digit address
display_address:
        call    hex_digit
        rol     ebx,16
; Display word
display_word:
        xchg    bh,bl
        call    hex_digit
        call    hex_digit
        xchg    bh,bl
; Display byte
display_byte:
        call    hex_digit
        call    hex_digit
; Print a space after the number
        mov     dl,' '
        call    print_char
        ret
;
;***************************************
; Print 1 hex digit
hex_digit:
        rol     bl,4
        mov     dl,bl
        and     dl,0fh
        add     dl,'0'
        cmp     dl,'9'
        jle     short hex_digit_0
        add     dl,7
hex_digit_0:
        call    print_char
        ret
;
;***************************************
; Get address and byte
get_add_byte:
        call    get_address
        je      short get_byte_error
; Get byte to search for
get_byte:
        call    get_hex
        je      short get_byte_error
        stosb
        inc     search_length
        cmp     si,cx
        jb      short get_byte
        test    si,si
get_byte_error:
        ret
;
;***************************************
; Get address and word
get_add_word:
        call    get_address
        je      short get_word_error
; Get word to search for
get_word:
        call    get_hex
        je      short get_word_error
        stosw
        add     search_length,2
        cmp     si,cx
        jb      short get_word
        test    si,si
get_word_error:
        ret
;
;***************************************
; Get address and dword
get_add_dword:
        call    get_address
        je      short get_dword_error
; Get dword to search for
get_dword:
        call    get_hex
        je      short get_dword_error
        stosd
        add     search_length,4
        cmp     si,cx
        jb      short get_dword
        test    si,si
get_dword_error:
        ret
;
;***************************************
; Get address and string
get_add_string:
        call    get_address
        je      short get_string_error
; Get string to search for
get_string:
        dec     cx
        je      short get_string_error
        lodsb
        cmp     al,"'"
        jne     short get_string
get_string_loop:
        lodsb
        cmp     al,"'"
        je      short get_string_exit
        stosb
        inc     search_length
        jmp     short get_string_loop
get_string_exit:
        test    si,si
get_string_error:
        ret
;
;***************************************
get_address:
        call    get_hex
        je      short get_address_error
        mov     change_address,eax
get_address_error:
        ret
;
;***************************************
calculate_address:
        les     di,back_pointer
        mov     eax,change_address
        shl     eax,12
        shr     ax,12
        add     di,ax
        shr     eax,16
        mov     bx,es
        add     ax,bx
        mov     es,ax
        call    normalize_di
        ret
;
;***************************************
; Restack to open space at specified address
;
find_address:
; Get length up to specified point
        mov     ebx,change_address
; Open space in file at specified address
        les     di,front_pointer
        lds     si,back_pointer
find_address_loop:
        mov     ecx,4000h
        sub     ebx,ecx
        jge     find_address_loop_0
        add     ecx,ebx
        xor     ebx,ebx
find_address_loop_0:
        rep     movsb
        call    normalize_di
        call    normalize_si
        test    ebx,ebx
        jne     find_address_loop
        ret
;
;******************************************************************************
; Data block
;
input_buffer db 80
input_length db 0
input_string db 80 dup(0)
;
filename db 80 dup(0)
file_handle dw 0
file_size label dword
file_length_lo dw 0
file_length_hi dw 0
;
file_start dd 0
back_start dd 0
;
back_pointer label dword
back_offset dw 0
back_segment dw 0
;
front_pointer label dword
front_offset dw 0
front_segment dw 0
;
;***************************************
; Data block for display
display_start dd 0
display_length dd 0
display_format db 'b'
display_0 dw 3
display_1 dw 2
;
;***************************************
; Data block for search
search_length dw 0
search_string db 80 dup(0)
search_count db 9
;
;***************************************
; data block for change
change_address dd 0
;
;***************************************
; Messages
;
zutof   db 13,10,'Unable to open file ',0
zse     db 13,10,'Syntax Error',13,10,0
zhelp   db 13,10,'LIST OF VALID COMMANDS:'
db 13,10,' q                        quit (exit)'
db 13,10,' w                        write contents of memory to file'
db 13,10,' l                        show length of file (hexadecimal)'
db 13,10,' d                        display current address in current format'
db 13,10,' db (address)             display in byte format: address optional'
db 13,10,' dw (address)             display in word format: address optional'
db 13,10,' dd (address)             display in dword format: address optional'
db 13,10,' sb b1 b2 b3...           search for bytes b1 b2 b3...'
db 13,10,' sw w1 w2 w3...           search for words w1 w2 w3...'
db 13,10,' sd d1 d2 d3...           search for dwords d1 d2 d3...'
db 13,10," ss '....'                search for text string '....'"
db 13,10,' cb address b1 b2 b3...   change to bytes b1 b2 b3...'
db 13,10,' cw address w1 w2 w3...   change to words w1 w2 w3...'
db 13,10,' cd address d1 d2 d3...   change to dwords d1 d2 d3...'
db 13,10," cs address '.....'       change to text string '.....'"
db 13,10,' ib address b1 b2 b3...   insert bytes b1 b2 b3...'
db 13,10,' iw address w1 w2 w3...   insert words w1 w2 w3...'
db 13,10,' id address d1 d2 d3...   insert dwords d1 d2 d3...'
db 13,10," is address '.....'       insert text string '.....'"
db 13,10,' r address #              remove # bytes starting at address',0
;
;***************************************
; List of valid commands & routines
command_list db 'qwdsecirhl',0
command_routine dw exit_no_change
        dw write_file_to_disk
        dw display_block
        dw search_forward
        dw change_file          ;e
        dw change_file          ;c
        dw insert_data
        dw remove_bytes
        dw help_screen
        dw show_length
;
;***************************************
;
; Stack
          dw 1024 dup(0)
stack_top dw 0
;***************************************
; Buffer for storing files
buffer_start:
;
;******************************************************************************
code    ends
        end     start
