;
; SRV Processor User Interface
; Compatible with AutoCAD Rel9/Rel10 and CAD Overlay ESP 2.1
; Copyright (C) 1989, Image Systems Technology, Inc.
; All Rights Reserved
;
;   May 3, 1989
;   Version 1.00
;   September 6,1989
;   Version 2.00
;
(prompt (strcat (chr 8) (chr 8) (chr 8) ", SRV Modules..|"))
(defun c:srv (/ cmd wc p0 p1 ang win fp pcmd)
  (setq srvdir "/SRV386/DRAW/")
  (prompt "\nSRV by SCORPION TECHNOLOGIES INC. v1.0\n")
  (IF
    (NULL RLCFILE)
    (*ERROR* "no active image")
  ) ; end IF
  (initget "Yes No")
  (setq cmd (getkword "Set skew angle, Yes or No? <Y> "))
  (if (/= cmd "No")
  (progn
    (initget "Yes No")
    (if (/= (getkword "Zoom to match image resolution, Yes or No? <Y>") "No")
    (progn
      ; get first skew point
      (setq wc (getpoint "Select area of first skew point: "))
      (pushvu)
      (setvuport (nth 0 wc) (nth 1 wc) (yreslimit))
      (zoom)
      (setq p0 (getpoint "\nSelect first skew point: "))
      (setq win (popvu))
      (setvuport (nth 0 win) (nth 1 win) (nth 2 win))
      (zoom)
      ; get second skew point
      (setq wc (getpoint p0 "\nSelect area of second skew point: "))
      (pushvu)
      (setvuport (nth 0 wc) (nth 1 wc) (yreslimit))
      (zoom)
      (setq p1 (getpoint p0 "\nSelect second skew point: "))
      (setq win (popvu))
      (setvuport (nth 0 win) (nth 1 win) (nth 2 win))
      (zoom)
    ) ; end progn
    (progn
      (setq p0 (getpoint "\nSelect first skew point: "))
      (setq p1 (getpoint p0 "\nSelect second skew point: "))
    ) ; end progn
    ) ; end if
    (setq ang (* 180.0 (/ (angle p0 p1) pi)))
  ) ; end progn
  (setq ang 0.0)
  ) ; end if
  (initget 1)                          

; Get name for parameter file, default is the drawing name
  (setq RLCFILE (getvar "DWGNAME"))
  (setq SRPFILE
    (getstring (strcat "\nParameter filename (no extension)  <" RLCFILE ">: "))
  ) ;end setq	
  (if (or (equal SRPFILE "") (null SRPFILE))
    (setq SRPFILE RLCFILE)
  ) ; end if

  (if (setq fp (open (strcat srvdir rlcfile ".SRV") "w"))
  (progn
    (princ (strcat rlcfile ".RLC") fp) ; LINE 1
    (newline fp)
    (write-line (strcase SRPFILE) fp) ; LINE 2
    (princ ang fp) ; LINE 3
    (newline fp)
    (setq cmd "")
    (while (/= cmd "Go")
    (if (= cmd "")
      (initget 1 "Ocr Vectorize Go")
      (initget "Ocr Vectorize Go")
    ) ;end if
    (setq pcmd cmd)
    (setq cmd (getkword (strcat "\nOcr/Vectorize/Go: <" cmd "> ")))
    (if (null cmd)
      (setq cmd pcmd)
    ) ;end if
    (cond
      ((eq cmd "Ocr")
        (initget 1)
        (setq p0 (getpoint "\nFirst corner of OCR box: "))
        (setq p1 (getcorner p0 "\nSecond corner: "))
        (princ 1 fp)
        (space fp)
        (princ (nth 0 (get-ll p0 p1)) fp) (space fp)
        (princ (nth 1 (get-ll p0 p1)) fp) (space fp)
        (princ (nth 0 (get-ur p0 p1)) fp) (space fp)
        (princ (nth 1 (get-ur p0 p1)) fp) (newline fp)
        (hotbox p0 p1)
      ) ;end OCR
      ((eq cmd "Vectorize")
        (initget 1)
        (setq p0 (getpoint "\nFirst corner of region to vectorize: "))
        (setq p1 (getcorner p0 "\nSecond corner: "))
        (princ 2 fp) (space fp)
        (princ (nth 0 (get-ll p0 p1)) fp) (space fp)
        (princ (nth 1 (get-ll p0 p1)) fp) (space fp)
        (princ (nth 0 (get-ur p0 p1)) fp) (space fp)
        (princ (nth 1 (get-ur p0 p1)) fp) (newline fp)
        (hotbox p0 p1)
      ) ;end Vectotize
      ((eq cmd "Go")
        (write-line "99 0 0 0 0" fp)
        (prompt "\nProcessing complete.")
      ) ;end Go
    ) ; end cond
    ) ; end while
  (close fp)
  ) ; end progn
  (prompt "\nCouldn't open the SRV data file for output")
  ) ; end if
  'DONE
  (prin1)
) ; end
;********************** SRVEDIT ****************************
;
; Calls the Dos SRVEDIT.EXE program Version 2.00
;
(prompt (strcat (chr 8) "/"))
(defun c:srvedit ()
  (setq SRPFILE (getvar "DWGNAME"))
  (shell "cd ..")
  (shell (strcat "SRVEDIT " srpfile))
  (shell "cd draw")
  (graphscr)
)
;*************************************************************
(prompt (strcat (chr 8) "-"))
(defun yreslimit ()
 (/ (nth 1 (getvar "SCREENSIZE")) (/ dens scale))
 ) ; end
(prompt (strcat (chr 8) "|"))
(defun hotbox (p0 p1 / l r t b)
 (setq l (nth 0 (get-ll p0 p1)))
 (setq b (nth 1 (get-ll p0 p1)))
 (setq r (nth 0 (get-ur p0 p1)))
 (setq t (nth 1 (get-ur p0 p1)))
 (grdraw (list l b) (list r b) -1 1)
 (grdraw (list r b) (list r t) -1 1)
 (grdraw (list r t) (list l t) -1 1)
 (grdraw (list l t) (list l b) -1 1)
 )
'DONE
