/* Next available MSG number is   1 */

/*    (C) Copyright 1986,87,88,89,90 by Autodesk, Inc.

******************************************************************************
*                                                                            *
* The information contained herein is confidential, proprietary to Autodesk, *
* Inc., and considered a trade secret as defined in section 499C of the      *
* penal code of the State of California.  Use of this information by anyone  *
* other than authorized employees of Autodesk, Inc. is granted only under a  *
* written non-disclosure agreement, expressly prescribing the scope and      *
* manner of such use.                                                        *
*                                                                            *
******************************************************************************/
 

/*  Rendering display driver function requests. The rendering display
    device is a high resolution color display device (e.g. PGC or
    Sun color monitor).  */

#define MAXFNAME 100

#ifndef scrcoord
#define scrcoord short
#endif

#ifndef ushort
/* short rather than unsigned short for Lattice 2.15 */
#define ushort unsigned short
#endif

#ifndef real
#define real double
#endif

#ifdef uadi
#define PASS_DATA 1
#endif

/* If neither data model defined, assume large data model.  If you
   are using the small data model, you must explicitly form the 
   offset and segment values for any of the character pointer values
   needed in the packets below. */
#ifndef LARGEDATA
#ifndef SMALLDATA
#ifndef uadi
#define LARGEDATA 1
#endif
#endif
#endif

#define RDLINKUP 2000              /* Initialize rendering link up */
#define RDINIT   2001              /* Initialise use of rendering device */
#define RDSTART  2002              /* Start new rendering */
#define RDEND    2003              /* End rendering */
#define RDTERM   2004              /* Terminate use of rendering device */
#define RDRESIZE 2005              /* Change size of rendering screen */
#define RDCLEAR  2006              /* Clear entire display */
#define RDCMAPB  2007              /* Begin colour map */
#define RDCMAP   2008              /* Set colour map */
#define RDCMAPE  2009              /* End of colour map */
#define RDPOLY   2010              /* Polygon */
#define RDFNAME  2011              /* User supplied filename */
#define RDCRANGE 2012              /* Continuous colour range */
#define RDCPOLY  2013              /* Continuous colour polygon */
#define RDWSLINE 2014              /* Output Scan line to driver */
#define RDRSLINE 2015              /* Input Scan line from driver */
#define RDRCMAP  2016              /* Input color map rgb from driver */
#define RDETAIL  2017              /* i/o details for hard copy drivers */

#define RPCFGREC    2059           /* execution time configuration record */
#define RPNEWCFG    2060           /* new configuration record */
#define RPCHGCFG    2061           /* change configuration record */
#define RPSHOWCFG   2062           /* show configuration record */

#ifdef P386
#define ADIRPKTLEVEL 1             /* Render packet interface level */
/* Configuration packets - For now use the same calling convention as
   display ADI. */

struct pkcfgrec {                  /* executor portion of adi driver */
    short pfunc;                   /* function code */
    short preclen;                 /* configuration record length */
#ifdef XENIX
    char *pcfgrec;                 /* driver-local cfg record */
#endif
    char paliasid;                 /* alias id */
    char  pcfgrec[1];
};

struct pkconfig {                  /* configurator portion of adi driver */
    short pfunc;                   /* function code */
    short preclen;                 /* configuration record length */
#ifdef XENIX
    char *pcfgrec;
#endif
    char  pcfgrec[1];
};

struct rhcudetail {
     short new;                       /* new configuration? */
     short type;                      /* Serial, Parallel, or NODEVICE. */
     short baud;                      /* Baud rate */
     short parity;                    /* Parity */
     short data;                      /* Data bits/frame */
     short stop;                      /* Stop bits/frame */
     char handshake;                  /* Hardware, XON/XOFF etc. */
};

#endif /* P386 */


struct rd_rgb {                    /* Continuous colour RGB value item */
        real r, g, b;              /* Primary colour intensities */
};

#define MAXINITNAME 65             /* Maximum characters in an init name */

struct rd_init {                   /* Initialisation request (all reply cells)*/
                                   /* Also used for resize request */
        ushort flags;              /* Initialization flags */
        scrcoord xdots, ydots;     /* Total screen size in X and Y */
        ushort pixwid, pixhgt;     /* Pixel width and pixel height */
        short ncolour;             /* Number of rgb colour values,
                                      0x8000 bit = stereo display */
        ushort maxintens;          /* Maximum intensity */
        ushort nshades;            /* Number of shades per colour */
        /* The last two fields are 4-byte data pointers on all platforms.
           Users will cast them to whatever makes their compiler happy. */
#ifdef PASS_DATA
        char name[MAXFNAME + 4];   /* Device name string */
        char rendconf[512];        /* Device configuration block */
#else
#ifdef LARGEDATA
        char *name;                /* Driver name string */
        char *rendconf;            /* Device configuration block */
#else
        long name;                 /* Driver name string */
        long rendconf;             /* Device configuration block */
#endif /* LARGEDATA */
#endif /* uadi */
};

#ifdef P386
struct rd_pinit {                  /* Initialisation request (all reply cells)*/
                                   /* Also used for resize request */
        ushort flags;              /* Initialization flags */
        scrcoord xdots, ydots;     /* Total screen size in X and Y */
        ushort pixwid, pixhgt;     /* Pixel width and pixel height */
        short ncolour;             /* Number of rgb colour values,
                                      0x8000 bit = stereo display */
        ushort maxintens;          /* Maximum intensity */
        ushort nshades;            /* Number of shades per colour */
        char name[MAXINITNAME];    /* Driver name string */
        short adiversion;          /* Protected mode adi level */
};
#endif /* P386 */

#ifdef UNIX
/* Unix version of inititialization packet, with string lengths
   substituted for string addresses.
   NOTE: This MUST match the definition of rd_init in UADI.H */
struct rd_uinit {                  /* Initialisation request (all reply cells) */
                                   /* Also used for resize request */
        ushort flags;              /* Initialization flags */
        scrcoord xdots, ydots;     /* Total screen size in X and Y */
        ushort pixwid, pixhgt;     /* Pixel width and pixel height */
        short ncolour;             /* Number of rgb colour values,
                                      0x8000 bit = stereo display */
        ushort maxintens;          /* Maximum intensity */
        ushort nshades;            /* Number of shades per colour */
        short name_len;            /* length of Driver name string */
        short rdcfg_len;           /* length of Device configuration block */
};
#endif

/* Values in flags of init packet */
#define RF_SINGLSCR   0x1          /* User requests single screen mode */
#define RF_REDRAWSCR  0x2          /* Redraw required on flip screen */
#define RF_FAILINIT   0x4          /* Driver could not initialize */
#define RF_FILEOUTPUT 0x8          /* Driver writes to (or reads from) file */
#define RF_NAME       0x10         /* Driver is returning its name string */
#define RF_HARDCOPY   0x20         /* This is Hard Copy device */
#define RF_DORESIZE   0x40         /* Poll device for size changes */

#ifdef OS2
#define RF_RENDSCR    0x100        /* render to the rendering window   */
#define RF_GFXSCR     0x200        /* render to the graphics window    */
#endif /* OS2 */

/* if the following bit is set, AutoShade will use polygon normals
   to compute smooth shading factors at each polygon vertex.  These
   shading factors will be passed to the device with each polygon. */

#define RF_SMOOTHFAC  0x80        /* Device wants smooth shade factors */

/* The following flags are used in init package for scanline driver */
#define RF_SCANLINE   0x700        /* Device scan line capability mask*/
#define RF_NOSLINE    0x000        /* Device has no scanline capability */
#define RF_SL1BIT     0x100        /* 1 bit per pixel output (Monochrome) */
#define RF_SL8BIT     0x200        /* 8 bits per pixel (LUT) output */
#define RF_SL24BIT    0x300        /* 24 bits per pixel (r,g,b) output */
                                   /* one byte Red, one byte Green and */
                                   /* one byte Blue from left to right */
#define RF_SL32BIT    0x400        /* 32 bits per pixel (r,g,b, alpha) */
                                   /* for RenderMan format, one bye Red*/
                                   /* one byte Green, one byte Blue and*/
                                   /* one byte alpha channel from left */
                                   /* to right, alpha channel is defined*/
                                   /* as in RenderMan and TGA standards, */
                                   /* i.e. it is the  */
                                   /* percentage of the pixel that is  */
                                   /* covered by the generated image,  */
                                   /* compared to how much is purely   */
                                   /* background, and is  used for      */
                                   /* anti-aliasing calculations output */
                                   /* when merging multiple images.*/

#define RF_SLREAD       0x800      /* Set to 1 if driver can return */
                                   /* scan line data as well as accept it, */
                                   /* 0 if driver is write-only. */
#define RF_SLORDERED    0x1000     /* Set to 1 if driver wants AutoShade to */
                                   /* send scan-line data in order from top */
                                   /* of image to bottom of image, such as  */
                                   /* a raster priinter-plotter with little */
                                   /* or no buffer memory.  Warning: this */
                                   /* may cause AutoShade to pass in the */
                                   /* data very slowly if it is reading from */
                                   /* a file/device where the data is not */
                                   /* ordered, so do not use if your device */
                                   /* can handle the data in random order. */

/* rd_start is passed to the driver everytime we start a new
   rendering. */

struct rd_start {                  /* Start rendering request */
        ushort flags;
};

/* Bits in flags field of rd_start packet. */

/* Set if this is a viewing request rather than a rendering request.
   I.e. the user did a FLIPSCREEN, and the rd_start will not be
   followed by any rendering commands. */
#define RF_VIEW       0x1          /* View request only */              

/* The structure RD_POLY is used to pass a polygon to a colour-mapped
   device. */

struct rd_poly {                   /* Polygon */
        ushort flags;              /* flags */
        short colour;              /* fill colour */
        short ecolour;             /* edge colour */
        short nvert;               /* number of vertices total */
        scrcoord vx[10];           /* next 10 vertices */
        scrcoord vy[10];
};

/* The structure RD_CPOLY is used to pass a polygon to a continuous
   colour device. */

struct rd_cpoly {                  /* Polygon in continuous colour */
        ushort flags;              /* flags */
        struct rd_rgb colour;      /* fill colour */
        struct rd_rgb ecolour;     /* edge colour */
        real shadef;               /* shading factor */
        short nvert;               /* number of vertices total */
        scrcoord vx[10];           /* next 10 vertices */
        scrcoord vy[10];
        real sf[10];               /* shade factor at each vertex */
};

/* Values in flags of rd_poly/rd_cpoly packets */
#define RF_MORE    0x1             /* this packet not complete */
#define RF_CONT    0x2             /* this packet is continuation of prev */
#define RF_LEFT    0x4             /* image intended for left eye only */
#define RF_RIGHT   0x8             /* image intended for right eye only */
#define RF_SF      0x10            /* shade factors included (rd_cpoly only) */
/* top 10 bits reserved for invisible edges */

/* The structure RD_SLINE is used to pass a scan line to the 
   rendering driver. */

struct rd_sline {                  /* Scan line output */
        ushort flags;              /* flags */
        scrcoord x;                /* start x */
        scrcoord y;                /* start y */
        ushort xrpt;               /* number of times to repeat data */
        ushort sdlen;              /* number of bytes of data */
#ifdef PASS_DATA
        unsigned char sdata[1536]; /* scan line data */
#else
        unsigned char *sdata;      /* scan line data */
#endif
};

/* Bits in rd_sline flags field */
#define  RF_SLREADFAIL  0x1         /* Set by driver if a RDRSLINE (read */
                                    /* scan-line from driver) request failed. */
                                    /* Otherwise, data should be in packet */
                                    /* upon return from call. */

                                    /* All the other bits in the flags field */
                                    /* are reserved for Future Use. */

struct rd_cmap {                   /* Colour map */
        short code;                /* index */
        ushort red;                /* red intensity */
        ushort green;              /* green intensity */
        ushort blue;               /* blue intensity */
};

struct rd_crange {                 /* Colour range for continuous tones */
        real minshade;             /* Minimum shade multiplier */
        real maxshade;             /* Maximum shade multiplier */
        short rstretch;            /* Contrast stretch requested ? */
        struct rd_rgb bcolour;     /* Background colour request */
        real ambient;              /* Ambient contribution */
};

struct rd_fname {                  /* Filename */
        ushort flags;              /* flags - see below */
#ifdef uadi
        char fname[MAXFNAME + 4];  /* name entered by user */
        char errormsg[80];         /* error message for AutoShade to put up */
        char ftitle[MAXFNAME + 4]; /* title for another file request */
#else
#ifdef LARGEDATA
        char *fname;               /* name entered by user */
        char *errormsg;            /* error message for AutoShade to put up */
        char *ftitle;              /* title for another file request */
#else
        long  fname;               /* offset:segment of name */
        long  errormsg;            /* offset:segment of error message */
        long  ftitle;              /* offset:segment of file request title */
#endif /* LARGEDATA */
#endif /* uadi */
};

#ifdef P386
struct rd_pfname {                 /* Filename */
        ushort flags;              /* flags - see below */
        char fname[MAXFNAME + 4];  /* name entered by user */
        int errmsg_offset;         /* error message for AutoShade to put up */
        char ftitle[MAXFNAME + 4]; /* title for another file request */
};
#endif /* P386 */

#ifdef UNIX
/*  Unix ADI rendering display request packet, where packets are passed
    thru pipes rather than by address.
    NOTE: This structure MUST match up with the rd_fname definition
          in UADI.H */
struct rd_ufname {                 /* Filename */
        ushort flags;              /* flags - see below */
        short fname_len;           /* length of name entered by user */
        short errmsg_len;          /* length of error message */
        short ftitle_len;          /* length of title for file request */
};

#ifdef UNIX
/* Define an optimal batched packet buffer size based on the maximum
   amount of data that can be written to a pipe before causing the
   writing process to be blocked (in this case 2048 bytes). */
#define RD_BATCH_SIZE 2040
#else
/* Haven't given much thought to non-SUN implementations. */
#define RD_BATCH_SIZE 512
#endif

struct rd_ubatch {
        short nbr_packets; 
        char  buf[RD_BATCH_SIZE];         
};
#endif

/* Values in rd_fname flags */
#define RF_TITLE     0x1            /* Shade -> give me title */
#define RF_CANCEL    0x2            /* Shade -> cancelled by user */
#define RF_RECORDING 0x4            /* Shade -> recording file acquired */
#define RF_GETFNAME  0x8            /* Driver -> get another name */
#define RF_ERROR     0x10           /* Driver -> Error message supplied */

/*  Master rendering display driver request packet union  */

union rd_mstr {
        struct rd_init  rinit;     /* Initialise */
        struct rd_start rstart;    /* Start rendering */
        struct rd_poly  rpoly;     /* polygon vertices */
        struct rd_cmap  rcmap;     /* colour map entry */
        struct rd_fname rfname;    /* filename */
        struct rd_crange rcrange;  /* shading range */
        struct rd_cpoly rcpoly;    /* continuous tone polygon */
        struct rd_sline rsline;    /* scan line output */
#ifdef UNIX
        struct rd_uinit ruinit;    /* Initialize Unix */
        struct rd_ufname rufname;  /* Unix filename record */
        struct rd_ubatch rubatch;  /* polygon batch */
#endif
#ifdef P386
        struct pkconfig pkconfig;  /* 386 Protected mode configuration */
        struct pkcfgrec pkcfgrec;  /* Configuration record */
        struct rhcudetail rhcudetail;  /* 386 Protected mode configuration */
        struct rd_pinit rpinit;    /* Initialise */
        struct rd_pfname rpfname;   /* filename */
#endif
};

/*  Universal rendering display request / reply packet structure  */

struct rendreq {
        short rfunc;               /* Function / status */
        union rd_mstr rpkt;
};


#ifdef UNIX
/*  Unix ADI rendering display request packet, where packets are passed
    thru pipes rather than by address.
    NOTE: This structure MUST match up with the rdpkt definition
          in UADI.H */
struct rendureq {
        short rfunc;               /* Function / status */
        short byte_cnt;            /* Byte count of packet data in rpkt */
        union rd_mstr rpkt;
};
#define RDPKTHDRSIZE (2*sizeof(short)/* rfunc and byte_cnt */)
#endif

/* Render slide header structure */

#define PRSLEN 40

struct rndhdr {
        char prs[PRSLEN];          /* primate readable string */
        char type;                 /* machine type */
        char level;                /* render slide level */
        scrcoord xdots, ydots;     /* total screen x and y size */
        short ncolour;             /* number of rgb colour values */
        ushort maxintens;          /* maximum intensity */
        ushort nshades;            /* number of shades per colour */
        ushort pixwid, pixhgt;     /* pixel width and height */
        short btest;               /* test for byte reversal */
};

                                   /* default rendering resolution      */
/* On Unix's hardcopy device for rendering file max is 8192 * 4096      */
/* i.e. it is 5092 * 5092 for Phar Lap the resolution can be 6000 * 6000*/
#define DEF_RES_X       1024
#define DEF_RES_Y       1024
