/*

        Read a rendering replay file.

*/

#include <stdio.h>
#include <ctype.h>
#include "render.h"

#define TRUE  1
#define FALSE 0
#define EOS   0
#define MAXLENGTH 4000

extern void strcpy(), strcat();           
extern int strncmp();
extern void exit();
unsigned char dslinebuf[MAXLENGTH];  /* Rendering scan line data buffer */

static int ioerror;
static char pkt_buff[9], *pkt_ptr;


/*  Byte order conversion routines.  Generated only if the target
    machine requires reordering of bytes.  */

#ifdef mc68000

/*  CVSHORT  --  Reorder bytes of a short  */

void cvshort(cp, u)
char *cp;
unsigned short u;
{
        *cp++ = u & 0xFF;
        *cp = u >> 8;
}

/*  CVLONG  --  Reorder bytes of a long  */

void cvlong(cp, l)
char *cp;
unsigned long l;
{
        *cp++ = l & 0xFFl;
        *cp++ = (l >> 8) & 0xFFl;
        *cp++ = (l >> 16) & 0xFFl;
        *cp = l >> 24;
}

/*  CVREAL  --  Reorder bytes of an IEEE 64 bit real  */

void cvreal(cp, r)
char *cp;
real r;
{
        char *rp;

        rp = (char *) &r;
        cp[0] = rp[7];
        cp[1] = rp[6];
        cp[2] = rp[5];
        cp[3] = rp[4];
        cp[4] = rp[3];
        cp[5] = rp[2];
        cp[6] = rp[1];
        cp[7] = rp[0];

}
#endif /* mc68000 */


main(argc, argv)
  int argc;
  char *argv[];
{
        int i;
        char *op, opt;
        char *rndf;

	if (argc < 2) {
	  printf(" Must include rnd file as argument \n");
	  return 0;
	}

        for (i = 1; i < argc; i++) {
           op = argv[i];
           if (*op == '-') {          /* look for options */
              opt = *(++op);
              if (islower(opt))
                 opt = toupper(opt);
              switch (opt) { 

                 case '?':
        fprintf(stderr,"\nUsage: readrnd <render-filename>\n");
                    exit(0);
              }
           } else {
              rndf = op;              /* get filename, no extension */
           }
        }

        if (!replay(rndf))            /* replay it */
           exit(1);                   /* error */

        return 0;                     /* normal exit */
}

int replay(filename)
  char *filename;
{
        int rtnstat;
        char prs[PRSLEN];
        FILE *rndfile;             /* Input file pointer */
        char tbfr[100];

        ioerror = FALSE;
        strcpy(tbfr, filename);
        strcat(tbfr, ".rnd");
#ifdef unix
        if ((rndfile = fopen(tbfr, "r")) == NULL) {
#else
        if ((rndfile = fopen(tbfr, "rb")) == NULL) {
#endif  
           fprintf(stderr, "Cannot open rendering replay file:\n%s", filename);
           return FALSE;
        }

        /* Read header */

        if (fread(prs, PRSLEN, 1, rndfile) != 1) {
           fclose(rndfile);
           fprintf(stderr, "Error reading replay file header.");
           return FALSE;
        } 

        /* Is it new format or old format? */

        if (strncmp(prs, "AutoShade Rendering Slide\r\n", 27) != 0) {
           fprintf(stderr, "Not a rendering file, or old incompatible format.");
           rtnstat = FALSE;
        } else {
           rtnstat = play_new_rnd(rndfile, prs);
           if (ioerror == TRUE)
              fprintf(stderr, "Error reading rendering replay file.\n");
        }
          
        fclose(rndfile);
        return rtnstat;
}

static int play_new_rnd(rndfile, prs)
  FILE *rndfile;
  char *prs;
{
        char c;
        register int i;
        short code;
        short color, r, g, b;
        real amb, qsmin, qsmax, qr, qg, qb;
        short stretchf;
        struct rndhdr rndhdr;
        struct rd_poly poly;
        struct rd_cpoly cpoly;
        struct rd_sline sline;
        char name[70];
        short maxx = 0, maxy = 0;

        /* If a "Written by"  name is included, read it now. */
        if (prs[27] == 'W') {
           if (fread(name, 70, 1, rndfile) != 1) {
              ioerror = TRUE;
              return FALSE;
           } else
              printf("Written by:\n%s\n", name);
        } else {
           /* This kind of file is nolonger generated! */
           fseek(rndfile, 28L, 0);    /* seek back for old format files */
           name[0] = EOS;
        }

        if (fread(&rndhdr.type, 1, 1, rndfile) != 1 ||
            fread(&rndhdr.level, 1, 1, rndfile) != 1 ||
            fread(&rndhdr.xdots, 2, 1, rndfile) != 1 ||
            fread(&rndhdr.ydots, 2, 1, rndfile) != 1 ||
            fread(&rndhdr.ncolour, 2, 1, rndfile) != 1 ||
            fread(&rndhdr.maxintens, 2, 1, rndfile) != 1 ||
            fread(&rndhdr.nshades, 2, 1, rndfile) != 1 ||
            fread(&rndhdr.pixhgt, 2, 1, rndfile) != 1 ||
            fread(&rndhdr.pixwid, 2, 1, rndfile) != 1 ||
            fread(&rndhdr.btest, 2, 1, rndfile) != 1) {
           ioerror = TRUE;
           return FALSE;
        }
#ifdef mc68000
        cvshort(&rndhdr.xdots, rndhdr.xdots);
        cvshort(&rndhdr.ydots, rndhdr.ydots);
        cvshort(&rndhdr.ncolour, rndhdr.ncolour);
        cvshort(&rndhdr.maxintens, rndhdr.maxintens);
        cvshort(&rndhdr.nshades, rndhdr.nshades);
        cvshort(&rndhdr.pixhgt, rndhdr.pixhgt);
        cvshort(&rndhdr.pixwid, rndhdr.pixwid);
        cvshort(&rndhdr.btest, rndhdr.btest);
#endif

        printf("Type=%d File level=%d\n", rndhdr.type, rndhdr.level);
        printf("Device parameters:\nxdots,ydots=%d,%d number of colors=%d\n\
        maxintensity=%d number of shades=%d pixel width,height =%d,%d\n\n",\
        rndhdr.xdots,rndhdr.ydots,rndhdr.ncolour,rndhdr.maxintens,\
        rndhdr.nshades,rndhdr.pixwid,rndhdr.pixhgt);

        /* print out a SHADERDFILE line */
        printf("SHADERDFILE=%d,%d,%d,%d,%d,%d,%d\n\n", \
rndhdr.xdots,rndhdr.ydots,rndhdr.pixwid,rndhdr.pixhgt,\
rndhdr.ncolour,rndhdr.maxintens,rndhdr.nshades);

        /* Read rendering commands, then their arguments and print */

        while (fread(&c, 1, 1, rndfile) == 1) {
           code = (unsigned char)c + RDLINKUP;
           switch (code) {
           case RDCLEAR:
              printf("RDCLEAR: clear screen\n");
              break;

           case RDCMAPB:
              printf("RDCMAPB: begin color map\n");
              break;

           case RDCMAP:
              if (fread(&color, 2, 1, rndfile) != 1 ||
                  fread(&r, 2, 1, rndfile) != 1 ||
                  fread(&g, 2, 1, rndfile) != 1 ||
                  fread(&b, 2, 1, rndfile) != 1) {
                 ioerror = TRUE;
                 return FALSE;
              }
#ifdef mc68000
              cvshort(&color, color);
              cvshort(&r, r);
              cvshort(&g, g);
              cvshort(&b, b);
#endif
              printf("index=%d rgb=%d,%d,%d\n", color, r, g, b);
              break;

           case RDCMAPE:
              printf("RDCMAPE: End color map\n");
              break;

           case RDCRANGE:
              if (fread(&qsmin, sizeof(real), 1, rndfile) != 1 ||
                  fread(&qsmax, sizeof(real), 1, rndfile) != 1 ||
                  fread(&stretchf, sizeof(short), 1, rndfile) != 1 ||
                  fread(&qr, sizeof(real), 1, rndfile) != 1 ||
                  fread(&qg, sizeof(real), 1, rndfile) != 1 ||
                  fread(&qb, sizeof(real), 1, rndfile) != 1) { 
                 ioerror = TRUE;
                 return FALSE;
              }
#ifdef mc68000
              cvreal(&qsmin, qsmin);
              cvreal(&qsmax, qsmax);
              cvshort(&stretchf, stretchf);
              cvreal(&qr, qr);
              cvreal(&qg, qg);
              cvreal(&qb, qb);
#endif
              /* In file level 4 we added the ambient factor. */
              if (rndhdr.level >= 4) {
                 if (fread(&amb, sizeof(real), 1, rndfile) != 1) {
                    ioerror = TRUE;
                    return FALSE;
                 }
#ifdef mc68000
                 cvreal(&amb, amb);
#endif
              } else {
                 amb = 0.3;           /* use default */
              }

              printf("RDCRANGE: continuous color range\n\
amb=%.5g min,max=%.5g,%.5g, stretch=%d\n\
rgb=%.5g,%.5g,%.5g\n",\
amb, qsmin, qsmax, stretchf, qr, qg, qb);
              break;

           case RDPOLY:
              if (fread(&poly.flags, 2, 1, rndfile) != 1 ||
                  fread(&poly.colour, 2, 1, rndfile) != 1 ||
                  fread(&poly.ecolour, 2, 1, rndfile) != 1 ||
                  fread(&poly.nvert, 2, 1, rndfile) != 1) {
                 ioerror = TRUE;
                 return FALSE;
              }
#ifdef mc68000
              cvshort(&poly.flags, poly.flags);
              cvshort(&poly.colour, poly.colour);
              cvshort(&poly.ecolour, poly.ecolour);
              cvshort(&poly.nvert, poly.nvert);
#endif
           
              for (i = 0; i < poly.nvert; i++) {
                 if (fread(&poly.vx[i], 2, 1, rndfile) != 1 ||
                     fread(&poly.vy[i], 2, 1, rndfile) != 1) {
                    ioerror = TRUE;
                    return FALSE;
                  }
#ifdef mc68000
                  cvshort(&poly.vx[i], poly.vx[i]);
                  cvshort(&poly.vy[i], poly.vy[i]);
#endif
                  if (poly.vx[i] > maxx)
                     maxx = poly.vx[i];
                  if (poly.vy[i] > maxy)
                     maxy = poly.vy[i];
              }
              printf("RDPOLY: polygon\n flags=%u colour=%d ecolour=%d  \
number of vertices=%d\n", poly.flags, poly.colour, \
poly.ecolour, poly.nvert);
              for (i=0; i < poly.nvert; i++) 
                 printf("%d,%d ", poly.vx[i], poly.vy[i]);
              printf("\n");
              break;

           case RDCPOLY:
              if (fread(&cpoly.flags, 2, 1, rndfile) != 1 ||
                  fread(&cpoly.colour.r, sizeof(real), 1, rndfile) != 1 ||
                  fread(&cpoly.colour.g, sizeof(real), 1, rndfile) != 1 ||
                  fread(&cpoly.colour.b, sizeof(real), 1, rndfile) != 1 ||
                  fread(&cpoly.ecolour.r, sizeof(real), 1, rndfile) != 1 ||
                  fread(&cpoly.ecolour.g, sizeof(real), 1, rndfile) != 1 ||
                  fread(&cpoly.ecolour.b, sizeof(real), 1, rndfile) != 1 ||
                  fread(&cpoly.shadef, sizeof(real), 1, rndfile) != 1 ||
                  fread(&cpoly.nvert, 2, 1, rndfile) != 1) {
                 ioerror = TRUE;
                 return FALSE;
              }
#ifdef mc68000
              cvshort(&cpoly.flags, cpoly.flags);
              cvreal(&cpoly.colour.r, cpoly.colour.r);
              cvreal(&cpoly.colour.g, cpoly.colour.g);
              cvreal(&cpoly.colour.b, cpoly.colour.b);
              cvreal(&cpoly.ecolour.r, cpoly.ecolour.r);
              cvreal(&cpoly.ecolour.g, cpoly.ecolour.g);
              cvreal(&cpoly.ecolour.b, cpoly.ecolour.b);
              cvreal(&cpoly.shadef, cpoly.shadef);
              cvshort(&cpoly.nvert, cpoly.nvert);
#endif
           
              for (i = 0; i < cpoly.nvert; i++) {
                 if (fread(&cpoly.vx[i], 2, 1, rndfile) != 1 ||
                     fread(&cpoly.vy[i], 2, 1, rndfile) != 1) {
                    ioerror = TRUE;
                    return FALSE;
                  }
#ifdef mc68000
                  cvshort(&cpoly.vx[i], cpoly.vx[i]);
                  cvshort(&cpoly.vy[i], cpoly.vy[i]);
#endif
                  if (cpoly.vx[i] > maxx)
                     maxx = cpoly.vx[i];
                  if (cpoly.vy[i] > maxy)
                     maxy = cpoly.vy[i];

              }
           
              /* If supplied, read in shade factor for each vertex. */
              if (cpoly.flags & RF_SF) {
                 for (i = 0; i < cpoly.nvert; i++) {
                    if (fread(&cpoly.sf[i], sizeof(real), 1, rndfile) != 1) {
                       ioerror = TRUE;
                       return FALSE;
                     }
#ifdef mc68000
                     cvreal(&cpoly.sf[i], cpoly.sf[i]);
#endif
                 }
              }

              printf("RDCPOLY: continuous colour polygon\n\
flags=%u colour rgb=%.5g,%.5g,%.5g ecolour rgb=%.5g,%.5g,%.5g\n\
shade factor=%.5g number of vertices=%d\n",\
cpoly.flags, cpoly.colour.r, cpoly.colour.g, cpoly.colour.b,\
cpoly.ecolour.r, cpoly.ecolour.g, cpoly.ecolour.b, \
cpoly.shadef, cpoly.nvert);
              for (i=0; i < cpoly.nvert; i++) 
                 if (cpoly.flags & RF_SF)
                   printf("%d,%d,%.5g ", cpoly.vx[i], cpoly.vy[i], cpoly.sf[i]);
                 else
                   printf("%d,%d ", cpoly.vx[i], cpoly.vy[i]);
              printf("\n");
              break;
           

           case RDWSLINE:
              /* Scanline packet information  */
              if (fread(pkt_buff, 8, 1, rndfile) != 1 )
               {
                 ioerror = TRUE;
                 return FALSE;
              }

              pkt_ptr = pkt_buff;
              sline.x = *(scrcoord *)pkt_ptr; pkt_ptr += 2;
              sline.y = *(scrcoord *)pkt_ptr; pkt_ptr += 2;
              sline.xrpt = *(ushort *)pkt_ptr; pkt_ptr += 2;
              sline.sdlen = *(ushort *)pkt_ptr; 

#ifdef mc68000
              cvshort(&sline.x, sline.x);
              cvshort(&sline.y, sline.y);
              cvshort(&sline.xrpt, sline.xrpt);
              cvshort(&sline.sdlen, sline.sdlen);
#endif
              
              if (fread(dslinebuf, sline.sdlen, 1, rndfile) != 1) {
                 ioerror = TRUE;
                 return FALSE;
              }

              printf("Packets: At\tx=%d,\ty=%d\tpixel data %d bytes \
is repeated %d times\n",(int)sline.x,(int)sline.y, \
(int)sline.sdlen,(int)sline.xrpt); 

              /* Rendering scanline */

              break;

           default:
              fprintf(stderr, "Unknown record code %d\n", code);
              break;
           }
        }     
        printf("\nMax X,Y = %d,%d\n", maxx, maxy);
        return TRUE;
}

