//
// MODULE NAME:  SAMPLE.C.
//
// FUNCTIONAL DESCRIPTION.
//	This module handles packet summary and protocol decoding for GREEN,
//	the basis for the mythical GREEN family of protocols.
//
//	There are two main entrypoints to this module.	PacketSummaryGreen
//	returns a pointer to an ASCIIZ string allocated with malloc that
//	best describes the packet. PacketDetailGreen returns a pointer to
//	a list of detail records (PDETREC) that describes the frame in detail.
//	If either function returns NULL, then no decoding is possible.
//
// MODIFICATION HISTORY.
//	S. E. Jones	92/04/03.	Original.
//	Your Name Here	Date		What you did.
//
// NOTICE:  Copyright (C) 1992-1993 General Software, Inc.  All rights reserved.
// NOTICE:  Protocol interpretation (C) date by you.
//

#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <dos.h>
#include "..\inc\system.h"		// DOS operating system defns.
#include "..\cow\cow.h"                 // character-oriented windows.
#include "..\inc\ktypes.h"		// commonly-used types.
#include "analyzer.h"			// common stuff for all modules.

//
// A mythical packet header for the "GREEN" protocol.
//

typedef struct _GREEN {
    USHORT Command;

#define GREEN_COMMAND_WORK	0	// this is a work packet.
#define GREEN_COMMAND_REST	1	// this is a resting packet.
#define GREEN_COMMAND_PLAY	2	// this is a playtime packet.
#define GREEN_COMMAND_CONTAINS_SMB 3	// contains encapsulated SMBs.

    UCHAR Counter;			// some bizarre counter.
    USHORT Fribble;			// an extra data item.
    UCHAR Frabble;			// another data item.
    UCHAR Buffer [1];			// start of any encapsulated data.
} GREEN, *PGREEN;

PUCHAR PacketSummaryGreen (PGREEN Buffer, USHORT BufferLength)
{
    UCHAR *p, *t;

    if (!(DisplayFilter & FILTER_GREEN)) {
	return NULL;			// we aren't decoding GREEN.
    }

    p = malloc (80);			// 80 chars is long enough.
    if (p == NULL) {
	return NULL;
    }

    //
    // Try to decode the higher-layer protocols.
    //

    switch (Buffer->Command) {
	case GREEN_COMMAND_WORK:
	    strcpy (p, "GREEN Work");
	    break;
	case GREEN_COMMAND_REST:
	    strcpy (p, "GREEN Rest");
	    break;
	case GREEN_COMMAND_PLAY:
	    strcpy (p, "GREEN Play");
	    break;
	case GREEN_COMMAND_CONTAINS_SMB:
	    t = PacketSummarySmb (Buffer->Buffer, BufferLength-(sizeof (SMB)-1));
	    if (t != NULL) {
		free (p);
		return t;		// if the SMB interpreter did the work.
	    }
	    strcpy (p, "GREEN SMB");	// otherwise, we have to print this.
	    break;
	default:
	    sprintf (p, "GREEN Undecoded,  Command=0x%04x", Buffer->Command);
    }
    return p;
} // PacketSummaryGreen

PDETREC PacketDetailGreen (PGREEN Buffer, USHORT BufferLength)
{
    PDETREC r=NULL, q;

    if (!(DisplayFilter & FILTER_GREEN)) {
	return NULL;			// we aren't decoding GREEN.
    }

    AppendHeader (&r, "GREEN:  ----- Green Protocol header -----");
    sprintf (ScratchBuf, "GREEN:  Command = 0x%04x", Buffer->Command);
    AppendDetRec (&r, ScratchBuf);
    sprintf (ScratchBuf, "GREEN:  Counter = %u", Buffer->Counter);
    AppendDetRec (&r, ScratchBuf);
    sprintf (ScratchBuf, "GREEN:  Fribble = 0x%04x", Buffer->Fribble);
    AppendDetRec (&r, ScratchBuf);
    sprintf (ScratchBuf, "GREEN:  Frabble = 0x%02x", Buffer->Frabble);
    AppendDetRec (&r, ScratchBuf);

    //
    // If this protocol has a frame that encapsulates other
    // protocols, here is the spot to call the nested protocol
    // interpreter, passing it the address of Buffer->Buffer.
    // Note:  This can be done later after the above is working.
    // For now, let's pretend that the GREEN_COMMAND_CONTAINS_SMB
    // command is the type of packet that carries an SMB protocol.
    //

    if (Buffer->Command == GREEN_COMMAND_CONTAINS_SMB) {
	AppendDetRec ("GREEN:");
	q = PacketDetailSmb (Buffer->Buffer, BufferLength-(sizeof (GREEN)-1));
	if (q != NULL) {
	    JoinDetRec (&r, q);
	}
    }

    //
    // The most important statement in this module.  This returns
    // a pointer to a linked list of DETRECs that defines your
    // detailed protocol lines.
    //

    return r;
} // PacketDetailGreen
