//
// MODULE NAME:  DECNET.C.
//
// FUNCTIONAL DESCRIPTION.
//	This module handles packet summary and protocol decoding for DECNET
//	protocols associated with the following Ethertypes:
//
//	6001: DEC MOPDL
//	6002: DEC MOPRC
//	6003: DEC DRP
//	6004: DEC LAT
//
//	There are two main entrypoints to this module.	PacketSummaryDecnet
//	returns a pointer to an ASCIIZ string allocated with malloc that
//	best describes the packet. PacketDetailDecnet returns a pointer to
//	a list of detail records (PDETREC) that describes the frame in detail.
//	If either function returns NULL, then no decoding is possible.
//
// MODIFICATION HISTORY.
//	S. E. Jones	92/03/19.	Original.
//
// NOTICE:  Copyright (C) 1992-1993 General Software, Inc.  All rights reserved.
//

#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <dos.h>
#include "..\inc\system.h"		// DOS operating system defns.
#include "..\cow\cow.h"                 // character-oriented windows.
#include "..\inc\ktypes.h"		// commonly-used types.
#include "analyzer.h"			// common stuff for all modules.

//
// Routines in other modules.
//

//
// Routines in this module.
//

BOOLEAN PacketFilterDecnet (PVOID Buffer, USHORT BufferLength)
{
    if (DisplayFilter & FILTER_DECNET) {
	return TRUE;
    }
    return FALSE;
} // PacketFilterDecnet

PUCHAR PacketSummaryDecnet (PVOID Buffer, USHORT BufferLength)
{
    UCHAR *p;

    if (!(DisplayFilter & FILTER_DECNET)) {
	return NULL;			// we aren't decoding LLC.
    }

    p = malloc (80);
    if (p == NULL) {
	return NULL;
    }
    sprintf (p, "DECNET (Undecoded), size=%u", BufferLength);
    return p;
} // PacketSummaryDecnet

VOID DecnetTrailer (PDETREC *Ptr)
{
    AppendDetRec (Ptr, "DECNET:");
} // DecnetTrailer

PDETREC PacketDetailDecnet (PVOID Buffer, USHORT BufferLength)
{
    PDETREC r=NULL, q;

    AppendHeader (&r, "DECNET:  ----- DECNET protocol header -----");
    sprintf (ScratchBuf, "DECNET:  Encapsulated data, size = %u (0x%04x hex) bytes.",
	     BufferLength, BufferLength);
    AppendDetRec (&r, ScratchBuf);
    DecnetTrailer (&r);
    return r;
} // PacketDetailDecnet
