/*
// PROGRAM NAME:  UTIL.C.
//
// FUNCTIONAL DESCRIPTION.
//	This module implements the UTIL object in COW.
//
// MODIFICATION HISTORY.
//	S. E. Jones	91/06/24.	Original.
//
// NOTICE:  Copyright (C) 1991-1993 General Software, Inc.
*/

#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <dos.h>
#include "cow.h"			// COW system include file.

PWINDOW UtilBackdrop;
PWINDOW UtilHeader;

VOID UtilStart (UtilName)
    UCHAR *UtilName;
{
    UCHAR *p;
    USHORT i;

    WinInit ();                         // initialize the window system.

    //
    // Make a backdrop window with a texture.
    //

    UtilBackdrop = WinCreate ("", 40, 12, 80, 25, WINDOW_BORDER_NONE, INIT_INV_PALETTE);
    if (UtilBackdrop == NULL) {
	return;
    }
    p = malloc (81);
    if (p == NULL) {
	return;
    }

    for (i=0; i<80; i++) {
	p [i] = 176;			// very light block texture.
    }
    p [80] = 0;                         // zero-byte terminator.

    for (i=0; i<25; i++) {
	WinWrite (UtilBackdrop, p, 0, i, 80);
    }

    //
    // Now initialize top-of-screen header.
    //

    UtilHeader = WinCreate ("", 40, 1, 80, 3, WINDOW_BORDER_SIMPLE_D, INIT_PALETTE);
    if (UtilHeader == NULL) {
	return;
    }
    WinUnHiliteBorder (UtilHeader);
    WinWrite (UtilHeader, UtilName, (80/2)-(strlen (UtilName)/2), 0, strlen (UtilName));
} // UtilStart

VOID UtilEnd ()
{
    WinDestroy (UtilHeader);
    WinDestroy (UtilBackdrop);
} // UtilEnd
