/*
// PROGRAM NAME:  TEST.C.
//
// FUNCTIONAL DESCRIPTION.
//	This program tests the Character-Oriented Window (COW) user interface
//	used by General Software in its utility products.
//
// MODIFICATION HISTORY.
//	S. E. Jones	91/05/10.	Original.
//
// INPUTS.
//	none.
//
// OUTPUTS.
//	none.
//
// COMMAND LINE SYNTAX.
//	test
//
// NOTICE:  Copyright (C) 1991-1993 General Software, Inc.
*/

#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <dos.h>
#include "cow.h"			// COW system include file.

UCHAR *TextLine [] = {
    "To: Joe\r\n",
    "From: Sam\r\n",
    "Subject: This is a test\r\n",
    "Date: 92/09/30 at 16:52:00\r\n",
    "------------------------------\r\n",
    "Joe, what do you think?\r\n",
    "            -- Sam",
    ""					// empty string terminator.
}; // TextLine

VOID ListSelectRoutine (Element)
    PLISTE Element;
{
    PWINDOW p;
    UCHAR ch;

    if (Element == NULL) {
	p = WinCreate ("No item selected", 40, 12, 60, 14,
		       WINDOW_BORDER_SINGLE, ERROR_PALETTE);
	ch = KeyRead ();
	WinDestroy (p);
    } else {
	p = WinCreate (Element->Title, 40, 12, 60, 14,
		       WINDOW_BORDER_SINGLE, NORMAL_PALETTE);
	ch = KeyRead ();
	WinDestroy (p);
    }
} // ListSelectRoutine

PLISTE ListInsertRoutine ()
{
    return NULL;			// don't insert anything for now.
} // ListInsertRoutine

BOOLEAN ListDeleteRoutine (Element)
    PLISTE Element;
{
    return FALSE;
} // ListDeleteRoutine

VOID CustomerForm ()
{
    PSCREEN Screen;
    PFIELD f;

    Screen = ScreenCreate ("Customer Data", 40, 12, 70, 9);
    if (Screen == NULL) {
	return;
    }
    f = FieldCreate ("Name:", FIELD_TYPE_STRING, 0, 0, 30, FIELD_FLAGS_EDITABLE);
    ScreenAddField (Screen, f);
    f = FieldCreate ("A1:", FIELD_TYPE_STRING, 0, 1, 30, FIELD_FLAGS_EDITABLE);
    ScreenAddField (Screen, f);
    f = FieldCreate ("A2:", FIELD_TYPE_STRING, 0, 2, 30, FIELD_FLAGS_EDITABLE);
    ScreenAddField (Screen, f);
    f = FieldCreate ("A3:", FIELD_TYPE_STRING, 0, 3, 30, FIELD_FLAGS_EDITABLE);
    ScreenAddField (Screen, f);
    f = FieldCreate ("A4:", FIELD_TYPE_STRING, 0, 4, 30, FIELD_FLAGS_EDITABLE);
    ScreenAddField (Screen, f);
    f = FieldCreate ("Tel:", FIELD_TYPE_STRING, 35, 0, 30, FIELD_FLAGS_EDITABLE);
    ScreenAddField (Screen, f);
    f = FieldCreate ("Fax:", FIELD_TYPE_STRING, 35, 1, 30, FIELD_FLAGS_EDITABLE);
    ScreenAddField (Screen, f);
    f = FieldCreate ("Charge:", FIELD_TYPE_STRING, 35, 2, 35, FIELD_FLAGS_EDITABLE);
    ScreenAddField (Screen, f);
    f = FieldCreate ("Balance:", FIELD_TYPE_CURRENCY, 35, 3, 20, FIELD_FLAGS_EDITABLE);
    ScreenAddField (Screen, f);
    f = FieldCreate ("Mail List:", FIELD_TYPE_BOOLEAN, 35, 4, 20, FIELD_FLAGS_EDITABLE);
    ScreenAddField (Screen, f);

    ScreenEdit (Screen);
    ScreenDestroy (Screen);
} // CustomerForm

main (argc, argv)
    USHORT argc;
    UCHAR *argv [];
{
    PWINDOW p;
    PLIST l;
    PLISTE le;
    USHORT i, width=30;
    UCHAR ch;
    PSTREAM s;
    ACTION a;

    UtilStart ("Test Utility Version 1.1           General Software, Inc.");

    while (TRUE) {
	p = WinCreate ("Main Menu", 40, 12, width, 8,
		       WINDOW_BORDER_DOUBLE, NORMAL_PALETTE);
	if (p == NULL) {
	    printf ("Oh god, we can't make a window.\n");
	    exit (1);
	}
	WinHiliteBorder (p);
	ch = KeyRead ();
	switch (ch) {
	    case I_F1:
		WinDestroy (p);
		l = ListCreate ("My List Box", 15, 15, 30, 8,
				LIST_FLAGS_INSERT | LIST_FLAGS_DELETE |
				LIST_FLAGS_SELECT);
		if (l == NULL) {
		    p = WinCreate ("Error Report", 40, 12, 60, 14,
				   WINDOW_BORDER_SINGLE, ERROR_PALETTE);
		    ch = KeyRead ();
		    WinDestroy (p);
		    break;
		}
		l->InsertRtn = ListInsertRoutine;
		l->DeleteRtn = ListDeleteRoutine;
		l->SelectRtn = ListSelectRoutine;

		ListInsert (l, "Disk Options", 12345L);
		ListInsert (l, "Volume Options", 23456L);
		ListInsert (l, "System Options", 34567L);
		ListInsert (l, "Product Options", 45678L);
		ListInsert (l, "Fortify Armies", 012345L);
		ListInsert (l, "Instant Cash", 99887L);
		ListSort (l);
		ListEdit (l);
		ListDestroy (l);
		break;

	    case I_F2:
		WinDestroy (p);
		p = WinCreate ("Error Report", 40, 12, 60, 14,
			       WINDOW_BORDER_SINGLE | WINDOW_BORDER_NOHILITE,
			       ERROR_PALETTE);
		ch = KeyRead ();
		WinDestroy (p);
		break;

	    case I_F3:
		WinDestroy (p);
		s = StreamCreate ("Text Editing Session", 4096, 40, 12, 50, 10);
		if (s == NULL) {
		    PopupFatal ("Oh god, we can't create a stream.");
		}
		for (i=0; i<100; i++) {
		    if (*(TextLine [i]) == 0) { // empty line terminates this.
			break;
		    }
		    if (!StreamInsert (s, TextLine [i], strlen (TextLine [i]))) {
			PopupFatal ("Oh god, we can't insert on a stream.");
		    }
		}
		a = StreamEdit (s);
		if (a == ACTION_ABORT) {
		    PopupStatus ("Text thrown away.");
		} else if (a == ACTION_SAVE) {
		    PopupStatus ("Text saved.");
		} else {
		    PopupStatus ("Unknown return.");
		}
		StreamDestroy (s);
		break;

	    case I_ENTER:
		WinDestroy (p);
		CustomerForm ();
		break;

	    case I_ESC:
		WinDestroy (p);
		UtilEnd ();
		exit (0);

	    default:
		WinDestroy (p);
	}
    }

    UtilEnd ();
    exit (0);
} /* test.c */
