/*
// PROGRAM NAME:  SCREEN.C.
//
// FUNCTIONAL DESCRIPTION.
//	This module implements the SCREEN object in COW.
//
// MODIFICATION HISTORY.
//	S. E. Jones	91/05/10.	Original.
//	S. E. Jones	92/12/28.	Added border highlighting.
//
// NOTICE:  Copyright (C) 1991-1993 General Software, Inc.
*/

#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <dos.h>
#include "cow.h"			// COW system include file.

VOID DisplayScreen (Screen)
    PSCREEN Screen;
{
    PFIELD p;

    for (p=Screen->FieldList; p!=NULL; p=p->Fwdlink) {
	FieldDisplay (p);
    }
} // DisplayScreen

PSCREEN ScreenCreate (Title, CenterX, CenterY, Width, Height)
    UCHAR *Title;
    USHORT CenterX;
    USHORT CenterY;
    USHORT Width;
    USHORT Height;
{
    PSCREEN p;

    if (Height <= 4) {                  // we have 4 lines of overhead.
	return NULL;
    }

    p = (PSCREEN)malloc (sizeof (SCREEN));
    if (p == NULL) {			// if we couldn't get the memory.
	return NULL;
    }

    p->Window = WinCreate (Title, CenterX, CenterY, Width, Height,
			   WINDOW_BORDER_SINGLE, NORMAL_PALETTE);
    if (p->Window == NULL) {		// if we couldn't allocate a window.
	free (p);
	return NULL;
    }

    p->FieldList = NULL;		// no fields yet.
    return p;				// return it to the caller.
} // ScreenCreate

VOID ScreenDestroy (Screen)
    PSCREEN Screen;
{
    PFIELD f;

    WinDestroy (Screen->Window);	// destroy the window for this screen.

    while (Screen->FieldList != NULL) { // remove the fields from the screen.
	f = Screen->FieldList;
	Screen->FieldList = f->Fwdlink;
	FieldDestroy (f);		// delete the field.
    }
    free (Screen);			// free this block of storage.
} // ScreenDestroy

VOID ScreenAddField (Screen, Field)
    PSCREEN Screen;
    PFIELD Field;
{
    PFIELD p;

    Field->Screen = Screen;

    Field->Fwdlink = NULL;
    Field->Baklink = NULL;

    if (Screen->FieldList == NULL) {
	Screen->FieldList = Field;
	return;
    }

    for (p=Screen->FieldList; p->Fwdlink!=NULL; p=p->Fwdlink) ;
    p->Fwdlink = Field;
    Field->Baklink = p;
} // ScreenAddField

ACTION ScreenEdit (Screen)
    PSCREEN Screen;
{
    PWINDOW w;
    BOOLEAN reprocess=FALSE;
    PFIELD p;				// pointer to current field.
    UCHAR ch;

    DisplayScreen (Screen);		// refresh the screen's fields.
    w = Screen->Window;                 // for shortcut references.
    p = Screen->FieldList;		// start at first field in list.
    if (p == NULL) {
	return ACTION_RESTORE;		// didn't do diddly.
    }

    while (TRUE) {
	WinHilite (w, p->VirtualX+strlen (p->Name),
		   p->VirtualY, p->Width-strlen (p->Name));

	if (p->Flags & FIELD_FLAGS_EDITABLE) {
	    ch = FieldEdit (p);         // edit the field.
	} else if (p->Flags & FIELD_FLAGS_SELECTABLE) {
	    ch = KeyRead ();		// press ENTER to select a field.
	    if (ch == I_ENTER) {
		WinUnHiliteBorder (w);
		(*(p->SelectRtn))(p);	// select the field.
		WinHiliteBorder (w);
		ch = I_INVALID;
	    }
	} else {			// we are resting on an untouchable field.
	    ch = I_DOWN;		// execute a DOWN command.
	}
	switch (ch) {
	    case I_F1:			// save this data.
		return ACTION_SAVE;

	    case I_ESC:                 // abort this edit.
		return ACTION_ABORT;

	    case I_ENTER:		// next field.
	    case I_DOWN:		// next field.
	    case I_RIGHT:		// next field.
	    case I_TAB:                 // next field.
		if ((p == NULL) || (p->Fwdlink == NULL)) {
		    break;		// if empty fieldlist, do nothing.
		}
		while (TRUE) {
		    WinUnHilite (w, p->VirtualX+strlen (p->Name),
				 p->VirtualY,
				 p->Width-strlen (p->Name));
		    if (p->Fwdlink != NULL) {
			p = p->Fwdlink;     // p = FWA, next FIELD.
		    } else {
			p = Screen->FieldList; // p = FWA, 1st FIELD in list.
		    }
		    if (p->Flags & (FIELD_FLAGS_SELECTABLE | FIELD_FLAGS_EDITABLE)) {
			break;		// found a field we can rest on.
		    }
		}
		break;

	    case I_UP:			// previous field.
	    case I_LEFT:		// previous field.
	    case I_BACKTAB:		// previous field.
		if ((p == NULL) || (p->Baklink == NULL)) {
		    break;		// if empty fieldlist, do nothing.
		}
		while (TRUE) {
		    WinUnHilite (w, p->VirtualX+strlen (p->Name),
				 p->VirtualY,
				 p->Width-strlen (p->Name));
		    if (p->Baklink != NULL) {
			p = p->Baklink;     // p = FWA, previous FIELD.
		    } else {		    // set p to last element in list.
			for (p=Screen->FieldList; p->Fwdlink!=NULL; p=p->Fwdlink);
		    }
		    if (p->Flags & (FIELD_FLAGS_SELECTABLE | FIELD_FLAGS_EDITABLE)) {
			break;		// found a field we can rest on.
		    }
		}
		break;

	    case I_HOME:
		if (p == NULL) {
		    break;
		}
		WinUnHilite (w, p->VirtualX+strlen (p->Name),
			     p->VirtualY,
			     p->Width-strlen (p->Name));
		p = Screen->FieldList;
		break;

	    case I_END:
		if (p == NULL) {
		    break;
		}
		WinUnHilite (w, p->VirtualX+strlen (p->Name),
			     p->VirtualY,
			     p->Width-strlen (p->Name));
		for (p=Screen->FieldList; p->Fwdlink!=NULL; p=p->Fwdlink) ;
	}
    }
} // ScreenEdit
