/*
// PROGRAM NAME:  POPUP.C.
//
// FUNCTIONAL DESCRIPTION.
//	This module implements the POPUP object in COW.
//
// MODIFICATION HISTORY.
//	S. E. Jones	91/05/14.	Original.
//
// NOTICE:  Copyright (C) 1991-1993 General Software, Inc.
*/

#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <dos.h>
#include "cow.h"			// COW system include file.

VOID PopupStatus (Msg)
    UCHAR *Msg;
{
    PWINDOW w;
    USHORT len;
    UCHAR ch;

    len = strlen (Msg) + 4;
    if (len < 44) {
	len = 44;
    }

    w = WinCreate ("Status Report (press ESC to continue)", 40, 12, len, 5,
		   WINDOW_BORDER_SINGLE | WINDOW_BORDER_NOHILITE, HELP_PALETTE);
    if (w == NULL) {			// if we couldn't allocate a window.
	return;
    }
    WinWrite (w, Msg, (w->Width/2)-(strlen (Msg)/2), 0, 999);

    ch = KeyRead ();			// wait for a keypress.
    WinDestroy (w);
} // PopupStatus

VOID PopupWarning (Msg)
    UCHAR *Msg;
{
    PWINDOW w;
    USHORT len;
    UCHAR ch;

    len = strlen (Msg) + 4;
    if (len < 44) {
	len = 44;
    }

    w = WinCreate ("Warning (press ESC to continue)", 40, 12, len, 5,
		   WINDOW_BORDER_SINGLE | WINDOW_BORDER_NOHILITE, WARNING_PALETTE);
    if (w == NULL) {			// if we couldn't allocate a window.
	return;
    }
    WinWrite (w, Msg, (w->Width/2)-(strlen (Msg)/2), 0, 999);

    ch = KeyRead ();			// wait for a keypress.
    WinDestroy (w);
} // PopupWarning

VOID PopupFatal (Msg)
    UCHAR *Msg;
{
    PWINDOW w;
    USHORT len;
    UCHAR ch;

    len = strlen (Msg) + 4;
    if (len < 44) {
	len = 44;
    }

    w = WinCreate ("Fatal System Error (ESC returns to DOS)", 40, 12, len, 5,
		   WINDOW_BORDER_SINGLE | WINDOW_BORDER_NOHILITE, ERROR_PALETTE);
    if (w == NULL) {			// if we couldn't allocate a window.
	return;
    }
    WinWrite (w, Msg, (w->Width/2)-(strlen (Msg)/2), 0, 999);

    ch = KeyRead ();			// wait for a keypress.
    WinDestroy (w);
    exit (999);                         // exit the whole program!
} // PopupFatal

BOOLEAN PopupYesOrNo (Msg, Question)
    UCHAR *Msg;
    UCHAR *Question;
{
    PWINDOW w;
    USHORT len;
    UCHAR ch;

    len = strlen (Msg) + 4;
    if (strlen (Question)+4 > len) {
	len = strlen (Question) + 4;
    }
    if (len < 40) {
	len = 40;
    }

    w = WinCreate (Msg, 40, 12, len, 5,
		   WINDOW_BORDER_SINGLE | WINDOW_BORDER_NOHILITE,
		   WARNING_PALETTE);
    if (w == NULL) {			// if we couldn't allocate a window.
	return FALSE;
    }
    WinWrite (w, Question, (w->Width/2)-(strlen (Question)/2), 0, 999);

    while (TRUE) {
	ch = KeyRead ();		// wait for a keypress.
	switch (ch) {
	    case 'Y':
	    case 'y':
		WinDestroy (w);
		return TRUE;
	    case 'N':
	    case 'n':
	    case I_ESC:
		WinDestroy (w);
		return FALSE;
	}
    }
} // PopupFatal

VOID PopupHelp (Text)
    UCHAR *Text [];
{
    BOOLEAN InSection=FALSE, Done=FALSE;
    USHORT i, StrLimit=0, lineno, maxlines=13;
    UCHAR *p, *momentstr="ONE MOMENT PLEASE . . .";
    PWINDOW Win, Prompt;
    KEY_CODE k;

    Prompt = WinCreate ("Browser Keyboard Functions", 58, 21, 40, 5,
			WINDOW_BORDER_SINGLE, NORMAL_PALETTE);
    if (Prompt != NULL) {
	WinWrite (Prompt, "   <PgUp> <PgDn> <Home> <End> <ESC>", 0, 0, 999);
    }

    Win = WinCreate ("On-Line Help Browser", 40, 11, 76, 4+maxlines,
		     WINDOW_BORDER_DOUBLE, NORMAL_PALETTE);
    if (Win == NULL) {
	WinDestroy (Prompt);
	return;
    }
    WinWrite (Win, momentstr, (76/2)-(strlen (momentstr)/2), maxlines/2, 999);

    for (StrLimit=0; StrLimit<999; StrLimit++) {
	if (Text [StrLimit] == NULL) {
	    break;
	}
    }

    lineno = 0;                         // start refreshing from line 0.
    while (!Done) {
	for (i=0; i<maxlines; i++) {
	    if (lineno+i >= StrLimit) {
		WinWrite (Win, " ", 1, i, 999); // blank filler line.
	    } else {
		WinWrite (Win, Text [lineno+i], 1, i, 999);
	    }
	}

	k = KeyRead ();
	switch (k) {
	    case I_ESC:
		Done = TRUE;
		break;
	    case I_UP:
		if (lineno > 0) {
		    lineno--;
		}
		break;
	    case I_DOWN:
		if (lineno+1 < StrLimit) {
		    lineno++;
		}
		break;
	    case I_HOME:
		lineno = 0;
		break;
	    case I_END:
		lineno = (StrLimit > maxlines) ? (StrLimit-maxlines) : 0;
		break;
	    case I_PGUP:
		if (lineno < maxlines) {
		    lineno = 0;
		} else {
		    lineno -= maxlines;
		}
		break;
	    case I_PGDN:
		if (lineno + maxlines < StrLimit) {
		    lineno += maxlines;
		}
	}
    }

    WinDestroy (Win);
    if (Prompt != NULL) {
	WinDestroy (Prompt);
    }
} // PopupHelp
