/*
// PROGRAM NAME:  MENU.C.
//
// FUNCTIONAL DESCRIPTION.
//	This module implements the MENU object in COW.
//
// MODIFICATION HISTORY.
//	S. E. Jones	91/05/14.	Original.
//
// NOTICE:  Copyright (C) 1991-1993 General Software, Inc.
*/

#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <dos.h>
#include "cow.h"			// COW system include file.

static PLISTE ListElement;

VOID MenuSelectRtn (Element)
    PLISTE Element;
{
    ListElement = Element;
} // MenuSelectRtn

PMENU MenuCreate (Title, CenterX, CenterY, Width, Height)
    UCHAR *Title;
    USHORT CenterX;
    USHORT CenterY;
    USHORT Width;
    USHORT Height;
{
    PLIST l;

    l = ListCreate (Title, CenterX, CenterY, Width, Height,
		    LIST_FLAGS_SELECT | LIST_FLAGS_MENU);
    if (l == NULL) {			// if we couldn't allocate a list box.
	return NULL;
    }
    l->SelectRtn = MenuSelectRtn;
    return (PMENU)l;			// return the menu box.
} // MenuCreate

VOID MenuDestroy (Menu)
    PMENU Menu;
{
    ListDestroy ((PLIST)Menu);
} // MenuDestroy

VOID MenuItem (Menu, ItemName, ItemValue)
    PMENU Menu;
    UCHAR *ItemName;
    ULONG ItemValue;
{
    ListInsert ((PLIST)Menu, ItemName, ItemValue);
} // MenuItem

VOID MenuSort (Menu)
    PMENU Menu;
{
    ListSort ((PLIST)Menu);
} // MenuSort

PLISTE MenuSelect (Menu)
    PMENU Menu;
{
    PLISTE p;

    ListElement = NULL;
    ListEdit ((PLIST)Menu);
    if (ListElement == NULL) {
	return NULL;
    }

    //
    // We make a COPY of this list element because when the original
    // list is destroyed, the copy will not go with it.
    //

    p = ListElementCreate (ListElement->Title, ListElement->Value);
    return p;				// return the COPY.
} // MenuSelect
