//***	COW.H -- Character Oriented Window User Interface Definitions.
//
//1.	Functional Description.
//	This include file contains macro definitions for the General
//	Software COW package.
//
//2.	Modification History.
//	S. E. Jones	91/05/10.	Original.
//	S. E. Jones	91/05/14.	Added standard types.
//	S. E. Jones	91/05/14.	Added popup API.
//	S. E. Jones	91/06/24.	Added UTIL functions.
//	S. E. Jones	91/08/01.	Added palette function.
//	S. E. Jones	92/04/03.	Added simple window borders.
//	S. E. Jones	92/11/12.	Added character xlation list box callouts.
//	S. E. Jones	92/12/29.	Added help, dropshadows, & attr's for write.
//
// NOTICE:  Copyright (C) 1991-1993 General Software, Inc.

#ifndef _COW
#define _COW

#include "..\inc\ktypes.h"		// standard definitions.

//
// Palette definitions.
//

#define NORMAL_PALETTE	0		// default window palette.
#define INIT_PALETTE	1		// initialization box.
#define HELP_PALETTE	2		// help screen.
#define ERROR_PALETTE	3		// error message.
#define WARNING_PALETTE 4		// caution message.
#define INIT_INV_PALETTE 5		// init background.
#define MAX_PALETTE	6		// number of palettes.

//
// The following definitions are values returned by the input functions
// when a key code is to be returned in a USHORT.
//

#define KEY_CODE USHORT

#define I_BACKSPACE	8
#define I_TAB		9
#define I_ENTER         13
#define I_ESC		27
#define I_UP		128
#define I_DOWN		129
#define I_LEFT		130
#define I_RIGHT         131
#define I_INSERT	132
#define I_DELETE	133
#define I_HOME		134
#define I_END		135
#define I_PGUP		136
#define I_PGDN		137
#define I_F1		138
#define I_F2		139
#define I_F3		140
#define I_F4		141
#define I_F5		142
#define I_F6		143
#define I_F7		144
#define I_F8		145
#define I_F9		146
#define I_F10		147
#define I_BACKTAB	148
#define I_INVALID	255

typedef (COW_IDLE_ROUTINE)();
typedef (*PCOW_IDLE_ROUTINE)();

extern VOID KeyRegisterIdleRoutine (PCOW_IDLE_ROUTINE UserRoutine);
extern KEY_CODE KeyRead ();		// returns one of the above or ASCII.
extern BOOLEAN KeyReady ();		// TRUE if keystroke ready, else FALSE.

//
// The following codes define the ACTION type, returned from the COW
// modules that edit or select windows, fields, and lists.
//

#define ACTION USHORT
#define PACTION ACTION *

#define ACTION_SAVE		0	// save value(s).
#define ACTION_RESTORE		1	// restore old value(s).
#define ACTION_ABORT		2	// abort activity.

//
// The following structure defines a window.
//

#define WINDOW_BORDER_KIND	0x00ff	// border type, enumerated below.

#define WINDOW_BORDER_NONE	0	// no border.
#define WINDOW_BORDER_SINGLE	1	// single line.
#define WINDOW_BORDER_DOUBLE	2	// double line.
#define WINDOW_BORDER_SIMPLE_S	3	// title line on top, no middle bar.
#define WINDOW_BORDER_SIMPLE_D	4	// same as SIMPLE_S, with double line.
#define WINDOW_BORDER_NOCHANGE	5	// don't do anything, just redisplay.

#define WINDOW_BORDER_NOSHADOW	0x0100	// bitflag indicating no drop shadow.
#define WINDOW_BORDER_NOHILITE	0x0200	// bitflag meaning no yellow on foreground.

typedef struct _WINDOW {
    UCHAR Attr;                         // attribute byte for text in window.
    USHORT BorderType;			// type of border from WinCreate.
    USHORT CenterX;			// center X coordinate.
    USHORT CenterY;			// center Y coordinate.
    USHORT Width;			// number of screen columns.
    USHORT Height;			// number of screen rows.
    USHORT HeaderRows;			// number of overhead header rows.

    UCHAR *BorderTable;                 // border table, set by WinCreate.
    UCHAR *Title;			// displayable title of this window.

    struct _WINDOW *Fwdlink;		// next window in system.
    USHORT *SavedScreen;		// save area for screen underneath.
} WINDOW, *PWINDOW;

extern VOID WinInit ();                 // must be called to initialize window pkg.
extern VOID WinPalette (USHORT Palette, UCHAR ForeGround, UCHAR BackGround);
extern VOID WinChangeBorderType (PWINDOW Window, UCHAR BorderType);
extern PWINDOW WinCreate (UCHAR *Title, USHORT CenterX, USHORT CenterY,
			  USHORT Width, USHORT Height, USHORT BorderType,
			  UCHAR Palette);
extern VOID WinDestroy (PWINDOW Window);
extern VOID WinWrite (PWINDOW Window, UCHAR *Text, USHORT x, USHORT y, USHORT Width);
extern VOID WinWriteAttr (PWINDOW Window, UCHAR *Text, USHORT x, USHORT y, USHORT Width, UCHAR Attr);
extern VOID WinHilite (PWINDOW Window, USHORT x, USHORT y, USHORT Width);
extern VOID WinUnHilite (PWINDOW Window, USHORT x, USHORT y, USHORT Width);
extern VOID WinHiliteBorder (PWINDOW Window);
extern VOID WinUnHiliteBorder (PWINDOW Window);

//
// The following structure defines a text stream object.
//

typedef struct _STREAM {
    PWINDOW Window;			// window to display things in.
    USHORT ViewCols;			// # text cols inside window.
    USHORT ViewRows;			// # text rows inside window.
    USHORT LeftEdge;			// # text cols hidden by left margin.
    USHORT BufLen;			// bytes available in buffer.
    USHORT BytesUsed;			// bytes currently used in buffer.
    USHORT Cursor;			// offset of cursor loctn in buffer.
    USHORT Line1;			// offset of 1st line in display buffer.
    UCHAR *Buffer;			// the top of the buffer.
    UCHAR CurRow;			// cursor row.
} STREAM, *PSTREAM;

extern PSTREAM StreamCreate (UCHAR *Title, USHORT BufLen,
			     USHORT CenterX, USHORT CenterY,
			     USHORT Width, USHORT Height);
extern BOOLEAN StreamInsert (PSTREAM StreamPtr, UCHAR *Buffer, USHORT BufLen);
extern ACTION StreamEdit (PSTREAM StreamPtr);
extern USHORT StreamCopy (PSTREAM StreamPtr, UCHAR *Buffer, USHORT BufLen);
extern UCHAR *StreamBuffer (PSTREAM StreamPtr);
extern USHORT StreamLength (PSTREAM StreamPtr);
extern VOID StreamDestroy (PSTREAM StreamPtr);

//
// The following structure defines a list element object.
//

typedef struct _LISTE {
    UCHAR *Title;			// displayable title of the element.
    ULONG Value;			// value associated with the element.
    struct _LISTE *Fwdlink;		// next list element in list.
    struct _LISTE *Baklink;		// previous element in list.
} LISTE, *PLISTE;

//
// The following structure defines a list object.
//

typedef struct _LIST {
    PWINDOW Window;			// window to display things in.
    USHORT Flags;			// flags for this object.

#define LIST_FLAGS_INSERT	0x0001	// ListSelect can INSERT into this list.
#define LIST_FLAGS_DELETE	0x0002	// ListSelect can DELETE from this list.
#define LIST_FLAGS_SELECT	0x0004	// ListSelect can SELECT from this list.
#define LIST_FLAGS_MENU         0x0008	// ListSelect returns on ENTER.
#define LIST_FLAGS_REVERSE_SORT 0x0010	// ListSort sorts in descending order.
#define LIST_FLAGS_CALLOUT	0x0020	// ListSelect calls XlateRtn on each char.

    USHORT ViewSize;			// # elements in view.
    PLISTE List;			// the list head.
    PLISTE TopElement;			// the 1st displayed LISTE in the view.

    UCHAR (*XlateRtn)(UCHAR ch, struct _LISTE *ListElement);
    PLISTE (*InsertRtn)();
    BOOLEAN (*DeleteRtn)(struct _LISTE *ListElement);
    VOID (*SelectRtn)(struct _LISTE *ListElement);
    VOID (*HelpRtn)(struct _LIST *ListHead);
} LIST, *PLIST;

extern PLIST ListCreate (UCHAR *Title, USHORT CenterX, USHORT CenterY,
			 USHORT Width, USHORT Height, USHORT Flags);
extern VOID ListDestroy (PLIST ListHead);
extern PLISTE ListInsert (PLIST ListHead, UCHAR *Title, ULONG Value);
extern VOID ListDelete (PLIST ListHead, PLISTE Element);
extern VOID ListSort (PLIST ListHead);
extern ACTION ListEdit (PLIST ListHead);
extern PLISTE ListSelect (PLIST ListHead);
extern PLISTE ListElementCreate (UCHAR *Title, ULONG Value);
extern VOID ListElementDestroy (PLISTE Element);

//
// The following structure defines an editable screen.
//

typedef struct _SCREEN {
    PWINDOW Window;			// window this screen is displayed in.
    struct _FIELD *FieldList;		// list of fields in the screen.
} SCREEN, *PSCREEN;

extern PSCREEN ScreenCreate (UCHAR *Title, USHORT CenterX, USHORT CenterY,
			 USHORT Width, USHORT Height);
extern VOID ScreenDestroy (PSCREEN Screen);
extern ACTION ScreenEdit (PSCREEN Screen);

//
// The following structure defines a displayable/editable FIELD in a SCREEN.
//

typedef struct _FIELD {
    PSCREEN Screen;			// pointer to owning SCREEN object.
    USHORT Flags;			// options, as follows.

#define FIELD_FLAGS_EDITABLE	0x0001	// this field can be edited.
#define FIELD_FLAGS_SELECTABLE	0x0002	// this field can be selected with RETURN.

    UCHAR *Name;			// ASCIIZ name of this field.
    UCHAR Type;                         // data type of field, as follows:

#define FIELD_TYPE_ULONG	0	// unsigned long.
#define FIELD_TYPE_LONG         1	// signed long.
#define FIELD_TYPE_STRING	2	// ASCIIZ string.
#define FIELD_TYPE_CURRENCY	3	// dollars/cents, with decimal or comma.
#define FIELD_TYPE_BOOLEAN	4	// TRUE (non-zero) or FALSE (zero).
#define FIELD_TYPE_HEXSTRING	5	// ASCIIZ string, but with hex filtering.
#define FIELD_TYPE_NOPRINT_STRING 6	// ASCIIZ string (private).

    union {
	ULONG UnsignedLong;		// 32-bit unsigned quantity.
	LONG SignedLong;		// 32-bit signed quantity.
	UCHAR *String;			// pointer to 81-byte buffer.
	ULONG Currency;                 // recorded in integer cents.
	BOOLEAN Boolean;		// boolean value ("YES" or "NO").
    } Data;

    VOID (*SelectRtn)(struct _FIELD *Field); // user's selection routine.
    VOID (*HelpRtn)(struct _FIELD *Field); // user's help routine.

    USHORT VirtualX;			// virtual left-most X coordinate.
    USHORT VirtualY;			// virtual upper-most Y coordinate.
    USHORT Width;			// displayable bytes/this field.
    USHORT Cursor;			// cursor position within field.

    struct _FIELD *Fwdlink;		// next field in list.
    struct _FIELD *Baklink;		// previous field in list.

} FIELD, *PFIELD;

extern PFIELD FieldCreate (UCHAR *Title, UCHAR Type, USHORT x, USHORT y,
			   USHORT Width, USHORT Flags);
extern VOID FieldDestroy (PFIELD Field);
extern VOID FieldDisplay (PFIELD Field);
extern KEY_CODE FieldEdit (PFIELD Field);
extern VOID ScreenAddField (PSCREEN Screen, PFIELD Field);

//
// The following structure defines the MENU API.
//

typedef LIST MENU, *PMENU;		// a MENU is really just a LIST.

extern PMENU MenuCreate (UCHAR *Title, USHORT CenterX, USHORT CenterY,
			 USHORT Width, USHORT Height);
extern VOID MenuDestroy (PMENU Menu);
extern VOID MenuItem (PMENU Menu, UCHAR *ItemName, ULONG ItemValue);
extern VOID MenuSort (PMENU);
extern PLISTE MenuSelect (PMENU);

//
// The following routines comprise the POPUP API.  There is no software
// object or data structure associated with a popup.
//

extern VOID PopupHelp (UCHAR *HelpText []);
extern VOID PopupStatus (UCHAR *Msg);
extern VOID PopupWarning (UCHAR *Msg);
extern VOID PopupFatal (UCHAR *Msg);
extern BOOLEAN PopupYesOrNo (UCHAR *Msg, UCHAR *Question);

//
// The following routines comprise the UTIL API.  There is no software
// object or data structure associated with a utility.
//

extern VOID UtilStart (UCHAR *Title);
extern VOID UtilEnd ();

#endif // not defined, _COW
