package global is
				-- Need to suppress package
				--  elaboration checks in interrupt
				--  handler support subprograms
  pragma suppress(elaboration_check);

				-- Need to suppress stack checking
				--  in interrupt handler support
				--  subprograms
  pragma suppress(storage_check);

  count : integer := 0;

  procedure critical_error_handler;
end;

with rtkernel;
package body global is

  procedure critical_error_handler is
  begin
    rtkernel.rtk_save_regs_and_restore_context;

    count := count + 1;

    rtkernel.rtk_restore_regs_and_iret;
  end critical_error_handler;

end global;

with global;
with rtkernel;
with system;
with text_io;  use text_io;
procedure critical is
  old_handler : system.address;
  tt          : file_type;
begin
  old_handler := rtkernel.rtk_get_interrupt_vector(16#24#);
  rtkernel.rtk_set_interrupt_vector(16#24#, global.critical_error_handler'address);

  for i in 1 .. 5 loop
    begin
      open(tt, name => "a:\junk", mode => in_file);
	  -- Critical error occurs here if no diskette in a: drive
      put_line("NO exception raised on open");
    exception
      when others =>
	put_line("exception raised on open");
    end;

    put_line("continuing ..." & integer'image(global.count));
  end loop;

  rtkernel.rtk_set_interrupt_vector(16#24#, old_handler);
end critical;
