package com_port is

  ---------------------------------------------------------------
  --  Hardware definitions for the IBM PC communication ports  --
  ---------------------------------------------------------------

  -- Base I/O addresses for IBM PC communication ports

  COM1                : constant := 16#3F8#;
  COM2                : constant := 16#2F8#;

  -- 8250 Register offset from base address

  RDR_register        : constant := 16#00#;  -- Receiver Buffer Register
					     --  (read only)
  THR_register        : constant := 16#00#;  -- Transmitter Holding Register
					     --  (write only)
  IER_register        : constant := 16#01#;  -- Interrupt Enable Register
  IIR_register        : constant := 16#02#;  -- Interrupt Ident. Register
					     --  (read only)
  LCR_register        : constant := 16#03#;  -- Line Control Register
  MCR_register        : constant := 16#04#;  -- Modem Control Register
  LSR_register        : constant := 16#05#;  -- Line Status Register
  MSR_register        : constant := 16#06#;  -- Modem Status Register

  COM1_RDR            : constant := COM1 + RDR_register;
  COM1_THR            : constant := COM1 + THR_register;
  COM1_IER            : constant := COM1 + IER_register;
  COM1_IIR            : constant := COM1 + IIR_register;
  COM1_LCR            : constant := COM1 + LCR_register;
  COM1_MCR            : constant := COM1 + MCR_register;
  COM1_LSR            : constant := COM1 + LSR_register;
  COM1_MSR            : constant := COM1 + MSR_register;

  -- Interrupt Enable Register values

  IER_disable_all     : constant := 16#00#;  -- Disable all interruptss
  IER_receive_data    : constant := 16#01#;  -- Data available interrupt enabled
  IER_transmit_data   : constant := 16#02#;  -- THR reg. empty interrupt enabled
  IER_line_status     : constant := 16#04#;  -- Receive line status interrupt
					     --  enabled
  IER_modem_status    : constant := 16#08#;  -- Modem status interrupt enabled

  -- Interrupt Identification Register values (read only)
  --  All other values mean no interrupt is pending

  IIR_modem_status    : constant := 16#00#;  -- Modem status interrupt pending
  IIR_transmit_data   : constant := 16#02#;  -- THR reg. empty interrupt pending
  IIR_receive_data    : constant := 16#04#;  -- Recieved data available
					     --  interrupt pending
  IIR_line_status     : constant := 16#06#;  -- Receiver line status interrupt
					     --  pending
  IIR_interrupt_mask  : constant := 16#07#;  -- To extract interrupt id only

  -- Line Control Register values

  LCR_5_bits          : constant := 16#00#;  -- Char. length is 5 bits
  LCR_6_bits          : constant := 16#01#;  -- Char. length is 6 bits
  LCR_7_bits          : constant := 16#02#;  -- Char. length is 7 bits
  LCR_8_bits          : constant := 16#03#;  -- Char. length is 8 bits (mask)
  LCR_1_stop_bit      : constant := 16#00#;  -- Number of stop bits is 1
  LCR_2_stop_bits     : constant := 16#04#;  -- Number of stop bits is 2 (mask)
  LCR_no_parity       : constant := 16#00#;  -- Parity generat./checking is off
  LCR_odd_parity      : constant := 16#08#;  -- Parity is odd
  LCR_even_parity     : constant := 16#18#;  -- Parity is even
  LCR_one_parity      : constant := 16#28#;  -- Parity is always 1
  LCR_zero_parith     : constant := 16#38#;  -- Parity is always 0 (mask)
  LCR_break           : constant := 16#40#;  -- Generate break signal
  LCR_DLAB            : constant := 16#80#;  -- Divisor latch access bit

  -- Modem Control Register values

  MCR_set_DTR         : constant := 16#01#;  -- Set data terminal ready line
  MCR_set_RTS         : constant := 16#02#;  -- Set request to send line
  MCR_set_out1        : constant := 16#04#;  -- Set user-defined output 1 line
  MCR_set_out2        : constant := 16#08#;  -- Set user-defined output 2 line
  MCR_set_loop        : constant := 16#10#;  -- Set UART loopback feature

  -- Line Status Register values

  LSR_data_ready      : constant := 16#01#;  -- Receiver data is ready in RDR
  LSR_overrun_error   : constant := 16#02#;  -- Receiver buffer reg overflowed
  LSR_parity_error    : constant := 16#04#;  -- Received char has bad parity
  LSR_framing_error   : constant := 16#08#;  -- Received char has bad stop bit
  LSR_break_interrupt : constant := 16#10#;  -- Receiver detected a break signal
  LSR_THR_empty       : constant := 16#20#;  -- THR register is empty
  LSR_TSR_empty       : constant := 16#40#;  -- Transmitter Shift Register is
					     --  empty
  LSR_time_out_error  : constant := 16#80#;  -- Time out error occurred

  -- Modem Status Register values

  MSR_CTS_changed     : constant := 16#01#;  -- Clear To Send bit changed state
  MSR_DSR_changed     : constant := 16#02#;  -- Data Set Ready bit changed state
  MSR_RI_changed      : constant := 16#04#;  -- Ring Indicator changed state
  MSR_DCD_changed     : constant := 16#08#;  -- Data Carrier Detect changed state
  MSR_CTS             : constant := 16#10#;  -- Clear To Send state
  MSR_DSR             : constant := 16#20#;  -- Data Set Ready state
  MSR_RI              : constant := 16#40#;  -- Ring Indicator state
  MSR_DCD             : constant := 16#80#;  -- Data Carrier Detect state

end com_port;
