--
-- Will display various evironment information.
--
with File_Io, Errors, Tty, Disk, Time,
     Disk_Types, Directory, Program_Control;

procedure Envdisp is

   Max_Files : constant := 200;

   type Files_Array is Array (1 .. Max_Files) of File_Io.File_Data;

   File_Names           : Files_Array;
   Number_Of_File_Names : Integer;

   Template : String (1 .. 80);
   Last     : Natural;

   procedure Get_Files (Template    : String;
			Names       : out Files_Array;
			Total_Files : out Integer) is

      use Errors, File_Io;

      Search_Data      : Transfer_Data;
      File_Information : File_Data;
      Find_Error       : Errors.Extended_Errors;
      File_Index       : Integer := 1;

   begin
      Find_First (
	  Name_Template => Template,
	  Transfer_Area => Search_Data,
	  File_Info     => File_Information,
	  Error         => Find_Error);


      if Find_Error = Ok then
	 Names (File_Index) := (File_Information);
	 loop
	    File_Index := File_Index + 1;
	    exit when File_Index > Max_Files;

	    Find_Next (Transfer_Area => Search_Data,
		       File_Info     => File_Information,
		       Error         => Find_Error);

	    if Find_Error = Ok then
	       Names (File_Index) := File_Information;
	    else
	       exit;
	    end if;

	 end loop;

	 Total_Files := File_Index - 1;
      else
	 Total_Files := 0;
      end if;
   end;

   procedure Display_Info (Names        : Files_Array;
			   Total_Files : Integer) is

      use Disk_Types;

      My_Drive        : Disk_Types.Drive_Id;
      My_Directory    : Directory.Pathname;
      Last_Valid_Char : Natural;
      Name_Error      : Errors.Extended_Errors;

      Total_Free      : Long_Integer;
      Total_Available : Long_Integer;
      Space_Error     : Boolean;

      Env_Path        : String (1 .. 255);
      Last_Path_Char  : Natural;
      Prompt_value    : String (1 .. 255);
      Last_Prompt_Char  : Natural;

   begin
      My_Drive := Disk.Get_Default;
      Directory.Current_Name (For_Drive => My_Drive,
			      Name      => My_Directory,
			      Last      => Last_Valid_Char,
			      Error     => Name_Error);

      Disk.Get_Free_Space (For_Drive   => My_Drive,
			   Free_Bytes  => Total_Free,
			   Total_Space => Total_Available,
			   Error       => Space_Error);

      Program_Control.Get_Environment_Variable
			(Variable_Name => "PATH",
			 Value         => Env_Path,
			 Last          => Last_Path_Char);

      Program_Control.Get_Environment_Variable
			(Variable_Name => "PROMPT",
			 Value         => Prompt_Value,
			 Last          => Last_Prompt_Char);

      Tty.Put_Line ("");
      Tty.Put_Line ("");
      Tty.Put_Line ("Current Directory: " & Drive_Id'Image (My_Drive) & ':' &
		     My_Directory (1 .. Last_Valid_Char));
      Tty.Put_Line ("Disk Space       : " & Long_Integer'Image (Total_Free) &
		     " bytes free;  " & Long_Integer'Image (Total_Available) &
		     " bytes total");
      Tty.Put_Line ("");
      if Last_Path_Char /= 0 then
	 Tty.Put_Line ("DOS PATH set to  : " & Env_Path (1..Last_Path_Char));
      end if;
      if Last_Prompt_Char /= 0 then
	 Tty.Put_Line ("DOS PROMPT set to: " & Prompt_Value (1..Last_Prompt_Char));
      end if;
      Tty.Put_Line ("");

      for I in 1 .. Total_Files loop
	 if I mod 3 = 0 then
	    Tty.Put_Line (Names (I).Name & " " &
			    Time.Image (Names (I).Timestamp,
				      Date_Notation => Time.Month_Day_Year,
				      Time_Notation => Time.None));
	 else
	    Tty.Put (Names (I).Name & " " &
			    Time.Image (Names (I).Timestamp,
				      Date_Notation => Time.Month_Day_Year,
				      Time_Notation => Time.None) & "   ");
	 end if;
      end loop;

      Tty.Put_Line ("");
      Tty.Put_Line (Integer'Image (Total_Files) & " File(s) Match Template");

   end Display_Info;


begin
   Tty.Put ("Enter the File Template (ex. *.ADA) : ");
   Tty.Get (Template, Last);
   if Last /= 0 then
      Get_Files (Template    => Template (1 .. Last),
		 Names       => File_Names,
		 Total_Files => Number_Of_File_Names);
   else
      Get_Files (Template    => "*.*",
		 Names       => File_Names,
		 Total_Files => Number_Of_File_Names);
   end if;

   Display_Info (Names       => File_Names,
		 Total_Files => Number_Of_File_Names);

end;
