--
--
-- Boxdemo
--
-- Sample program to draw various size boxes.
--
with Box,
     Tty,
     Cursor,
     Common_Display_Types, 
     Video;

procedure Boxdemo is

   use Common_Display_Types,
       Video;

   Current_Mode  : Video_Mode;
   Current_Width : Byte;
   Current_Page  : Display_Page;

   Attribute_1 : Display_Attribute;
   Attribute_2 : Display_Attribute;

   task Boxer is
      entry Start;
      entry Stop;
   end Boxer;

   task body Boxer is

      Ulr : Row_Range;
      Ulc : Column_Range;
      Lrr : Row_Range;
      Lrc : Column_Range;

      Box_Value1 : Display_Attribute;
      Box_Value2 : Display_Attribute;
      Toggle     : Boolean := True;

   begin
      
      accept Start;
      
      loop
	 Ulr := 11;
	 Ulc := 38;
	 Lrr := 13;
	 Lrc := 42;

	 if Toggle then
	    Box_Value1 := Attribute_1;
	    Box_Value2 := Attribute_2;
	    Toggle := False;
	 else
	    Box_Value2 := Attribute_1;
	    Box_Value1 := Attribute_2;
	    Toggle := True;
	 end if;

         for I in 1 .. 5 loop

            Box.Draw (Upper_Left_Row     => Ulr,
		      Upper_Left_Column  => Ulc,
		      Lower_Right_Row    => Lrr,
		      Lower_Right_Column => Lrc,
		      Attribute		 => Box_Value1,
		      Page		 => Current_Page);

            Box.Draw (Upper_Left_Row     => Ulr - 1,
		      Upper_Left_Column  => Ulc - 2,
		      Lower_Right_Row    => Lrr + 1,
		      Lower_Right_Column => Lrc + 2,
		      Attribute		 => Box_Value2,
		      Page		 => Current_Page);

	    Ulr := Ulr - 2;
	    Ulc := Ulc - 4;
	    Lrr := Lrr + 2;
	    Lrc := Lrc + 4;

         end loop;


	 select
	    accept Stop;
	    exit;
	 else
	    null;
	 end select;

      end loop;


   end Boxer;

begin  -- Boxdemo 

   Video.Get_Mode (Width => Current_Width,
	           Mode  => Current_Mode,
		   Page  => Current_Page);
      
   if Current_Width = 80 then

      if Current_Mode = Text80_Co then

	 Attribute_1 := (Foreground => Red,
			 Background => Black, 
			 Blink      => False); 

         Attribute_2 := (Foreground => Blue,
			 Background => Black, 
			 Blink      => False);
      else
	 Attribute_1 := (Foreground => White,
			 Background => Black, 
			 Blink      => False); 

         Attribute_2 := (Foreground => Bright_White,
			 Background => Black, 
			 Blink      => False);
      end if;

      Cursor.Inhibit;
      Video.Clear_Screen;

      Boxer.Start;
      delay 10.0;

      Cursor.Set_Size (Start_Line => 6, End_Line => 7);

   else

      Tty.Put_Line ("Incorrect Screen Width to run");
   end if;

   Boxer.Stop;

end Boxdemo;
