--        ͻ
--        ۺ
--                                                                   ۺ
--                         Meridian Software Systems                 ۺ
--                                                                   ۺ
--                            Copyright (C)  1990                    ۺ
--                                                                   ۺ
--                            ALL RIGHTS RESERVED                    ۺ
--                                                                   ۺ
--        ۺ
--        ͼ

------------------------------------------------------------------------------
--
--   Unit Name: Window            - package specification
--
--   Purpose of unit:   This package is called to define, select, reset window
--                      and world coordinates.  The application programmer may
--                      also use this package to save and load windows to and
--                      from disk.
--
------------------------------------------------------------------------------

with COMMON_GRAPHIC_TYPES, COMMON_DISPLAY_TYPES;

package WINDOW is 

  -- *************************************************************
  --                                                             *
  --   Procedure DEFINE_WINDOW is called to store a specified    *
  --   window index and coordinates in a record.  This record    *
  --   is then added to a link list of WDW_RECORD's.  If the     *
  --   record already exists in the linked list it will be       *
  --   overwritten.                                              *
  --                                                             *
  -- *************************************************************
  procedure DEFINE_WINDOW (WINDOW_INDEX : in COMMON_GRAPHIC_TYPES.INDEX_NUMBER;
			   WDWUPX, WDWUPY, WDWLWRX, WDWLWRY : in integer);

  -- *************************************************************    
  --                                                             *
  --  Procedure SELECT_WINDOW is called to set the window index- *
  --  ed by WDW_INDEX as the ACTIVE_WINDOW.  This procedure will *
  --  also ensure that the window will fit in the current world  *
  --  coordinates and if so draw it using the specified border   *
  --  color and filling it in with the specified background      *
  --  color and then setting the Foreground to the user spec-    *
  --  ified color.  The global CLIP_ENABLE will be set to the    *
  --  boolean value passed in ENABLE_CLIP.                       *
  --                                                             *
  -- *************************************************************
  procedure SELECT_WINDOW (WINDOW_INDEX : in COMMON_GRAPHIC_TYPES.INDEX_NUMBER;
                           BORDER_COLOR, 
                           WINDOW_FORE_COLOR,  
                           WINDOW_BACK_COLOR : in COMMON_DISPLAY_TYPES.COLOR;
			   ENABLE_CLIP : in boolean);

  -- *************************************************************
  --                                                             *
  --  Procedure RESET_WINDOW is called to dispose of the current *
  --  linked list of WDW_RECORDS and initialize the current win- *
  --  dow index to a 0. The coordinates will be set equal to the *
  --  screen coordinates.  The above values initialize the data  *
  --  contained in the COMMON_GRAPHIC_TYPES package.             *
  --                                                             *
  -- *************************************************************
  procedure RESET_WINDOW;

  -- *************************************************************
  --                                                             *
  --  Procedure SAVE_WINDOW creates a file containing the value  *
  --  of the pixels defined by the coordinates of a specified    *
  --  window. The record containing the coordinates of the spec- *
  --  ified window is passed to this procedure. The coordinates  *
  --  of the pixels are calculated along with the offsets on     *
  --  both the right and left sides of the window.  A mask is    *
  --  defined to ensure only the window pixels are copied into   *
  --  the file. If a specified file already exixts it will be    *
  --  overwritten with the new file.                             *
  --                                                             *
  -- *************************************************************
  procedure SAVE_WINDOW (WINDOW_INDEX : in COMMON_GRAPHIC_TYPES.INDEX_NUMBER;
			 FILENAME     : in string);

  -- *************************************************************
  --                                                             *
  --  Procedure LOAD_WINDOW is called to load a specified window *
  --  indicated by WINDOW_INDEX to user specified position. If   *
  --  either of the coordinates are out of bounds of the ACTIVE_ *
  --  SCREEN then the default coordinates contained in the       *
  --  window record will be used.  The ACTIVE_WINDOW will be     *
  --  assigned the indexed value of the window being loaded. If  *
  --  the file doesn't exist an error message will be displayed. *
  --                                                             *
  -- *************************************************************
  procedure LOAD_WINDOW (WINDOW_INDEX : in COMMON_GRAPHIC_TYPES.INDEX_NUMBER;
			 FILENAME     : in string;
			 NEWX, NEWY   : in integer);

  -- *************************************************************
  --                                                             *
  --   Procedure WORLD_COORDINATE is called to store a specified *
  --   world index and coordinates in a record.  This record     *
  --   is then added to a link list of WLD_RECORD's.  If the     *
  --   record already exists in the linked list it will be       *
  --   overwritten.  Otherwise, the record will be added to the  *
  --   linked list in it's numerical order.                      *
  --                                                             *
  -- *************************************************************
  procedure WORLD_COORDINATES (WORLD_INDEX : in COMMON_GRAPHIC_TYPES.INDEX_NUMBER; 
			       WLDLWRX, WLDLWRY : in integer);

  -- *************************************************************    
  --                                                             *
  --  Procedure SELECT_WORLD is called to set the world indexed  *
  --  by WORLD_INDEX as the ACTIVE_WORLD.                        *
  --                                                             *
  -- *************************************************************
  procedure WORLD_SELECT (WORLD_INDEX : in COMMON_GRAPHIC_TYPES.INDEX_NUMBER);


  -- *************************************************************
  --                                                             *
  --  Procedure RESET_WORLD is called to dispose of the current  *
  --  linked list of WLD_RECORDS and set the ACTIVE_WORLD to 0.  *
  --  The world coordinates are set equal to the screen coordin- *
  --  ates.  This procedure will also set the global world data  * 
  --  values to the values mentioned above.                      *
  --                                                             *
  -- *************************************************************
  procedure WORLD_RESET;

end WINDOW;
