--        ͻ
--        ۺ
--                                                                   ۺ
--                         Meridian Software Systems                 ۺ
--                                                                   ۺ
--                            Copyright (C)  1990                    ۺ
--                                                                   ۺ
--                            ALL RIGHTS RESERVED                    ۺ
--                                                                   ۺ
--        ۺ
--        ͼ

------------------------------------------------------------------------------
--
--  Unit Name:  Screen - package specification
--
--  Purpose of unit :  Package Screen performs selection of the active graphics
--                     page, swapping of graphics pages, and copying of one
--                     graphics page to another graphics page.  Package Screen
--                     also performs the save and load operations of graphics
--                     screens to and from disk files.
--
------------------------------------------------------------------------------

with INTERRUPT, MOVEASM, PORT, WINDOW_IO, SPY, SYSTEM, VIDEO;
with BIT_OPS, COMMON_GRAPHIC_TYPES;
use  BIT_OPS, COMMON_GRAPHIC_TYPES;

package body SCREEN is

  BYTE_RECORD : WINDOW_IO.BYTE_REC;
  INT_NUMBER  : INTERRUPT.INTERRUPT_RANGE;
  REGISTER    : INTERRUPT.REGISTERS;
  INDEX       : integer;

  --ͻ

  procedure SELECT_SCREEN ( New_page : DISPLAY_PAGE ) is
  begin
    if SCREEN_FLAG then
      ACTIVE_PAGE := New_page;
      CURRENT_VIDEO_PAGE := New_page;
    end if;
  end SELECT_SCREEN;

  --ͼ

  --ͻ

  procedure COPY_SCREEN is
  begin
    if ACTIVE_PAGE = 0 then
      MOVEASM.COPY_SCREEN(0);
    else
      MOVEASM.COPY_SCREEN(1);
    end if;
  end COPY_SCREEN;

  --ͼ

  --ͻ

  procedure SWAP_SCREEN is
  begin
    if SCREEN_FLAG then
      if CURRENT_PAGE = 0 then
        CURRENT_PAGE := 1;

        -- change video page to 1
        REGISTER.AX := 16#0501#;
        REGISTER.BX := 16#0000#;
        REGISTER.CX := 16#0000#;
        REGISTER.DX := 16#0000#;

        -- Call interrupt 10h
	INTERRUPT.VECTOR (ON             => 16#0010#,
			  REGISTER_BLOCK => REGISTER);
      else
        CURRENT_PAGE := 0;

        -- change video page to 0
        REGISTER.AX := 16#0500#;
        REGISTER.BX := 16#0000#;
        REGISTER.CX := 16#0000#;
        REGISTER.DX := 16#0000#;

        -- Call interrupt 10h
	INTERRUPT.VECTOR (ON             => 16#0010#,
			  REGISTER_BLOCK => REGISTER);
      end if;
    end if;
  end SWAP_SCREEN;

  --ͼ

  --ͻ

  procedure SAVE_SCREEN ( FILENAME : string ) is
    BYTES_PER_ROW,
    NUMBER_OF_BYTES,
    SYSTEM_ADDRESS   : long_integer;
    COUNT            : integer := 1;
    INDEX            : integer := 0;
  begin
    if GRAPH_SCREEN = 14 then
      BYTES_PER_ROW := 40;
    else
      BYTES_PER_ROW := 80;
    end if;

    NUMBER_OF_BYTES := BYTES_PER_ROW;

    if not WINDOW_IO.CREATE( FILE_NAME => FILENAME ) then
      return;
    end if;

    if GRAPH_SCREEN >= 4 and GRAPH_SCREEN <= 6 then
      SYSTEM_ADDRESS := PAGE1_MEMORY_START;

      for I in 0 .. ( integer(SCREEN_DIMENSION_LOWER_RIGHT_Y / 2) + 1) loop
        INDEX := 1;
        for J in 1 .. (2 * NUMBER_OF_BYTES) loop
	  BYTE_RECORD.BYTE_ARRAY(INDEX) :=
	      SPY.PEEK(SYSTEM.ADDRESS(SYSTEM_ADDRESS));
          BYTE_RECORD.BYTE_ARRAY(INDEX) :=
	      SHL(BYTE_RECORD.BYTE_ARRAY(INDEX), 8);
          SYSTEM_ADDRESS := SYSTEM_ADDRESS + 1;
	  BYTE_RECORD.BYTE_ARRAY(INDEX) :=
	      BYTE_RECORD.BYTE_ARRAY(INDEX) +
	      SPY.PEEK(SYSTEM.ADDRESS(SYSTEM_ADDRESS));
          SYSTEM_ADDRESS := SYSTEM_ADDRESS + 1;
          INDEX := INDEX + 1;
        end loop;
	if not WINDOW_IO.WRITE( REC => BYTE_RECORD ) then
	  return;
	end if;
        INDEX := 1;
      end loop;
      if not WINDOW_IO.WRITE( REC => BYTE_RECORD ) then
	return;
      end if;
    else
      if ACTIVE_PAGE = 0 then
	SYSTEM_ADDRESS := PAGE1_MEMORY_START;
      else
	SYSTEM_ADDRESS := PAGE2_MEMORY_START;
      end if;

      for I in 0 .. SCREEN_DIMENSION_LOWER_RIGHT_Y loop
        for J in 1 .. 80 loop
          INDEX := INDEX + 1;
          PORT.OUT_WORD(16#03CE#, 16#0004#);
	  BYTE_RECORD.BYTE_ARRAY(INDEX) :=
	      SPY.PEEK(SYSTEM.ADDRESS(SYSTEM_ADDRESS));
          PORT.OUT_WORD(16#03CE#, 16#0104#);
          INDEX := INDEX + 1;
	  BYTE_RECORD.BYTE_ARRAY(INDEX) :=
	      SPY.PEEK(SYSTEM.ADDRESS(SYSTEM_ADDRESS));
          PORT.OUT_WORD(16#03CE#, 16#0204#);
          INDEX := INDEX + 1;
	  BYTE_RECORD.BYTE_ARRAY(INDEX) :=
	      SPY.PEEK(SYSTEM.ADDRESS(SYSTEM_ADDRESS));
          PORT.OUT_WORD(16#03CE#, 16#0304#);
          INDEX := INDEX + 1;
	  BYTE_RECORD.BYTE_ARRAY(INDEX) :=
	      SPY.PEEK(SYSTEM.ADDRESS(SYSTEM_ADDRESS));
          SYSTEM_ADDRESS := SYSTEM_ADDRESS + 1;
        end loop;
        INDEX := 0;
	if not WINDOW_IO.WRITE( REC => BYTE_RECORD ) then
	  return;
	end if;
      end loop;
      if not WINDOW_IO.CLOSE then
	null;
      end if;
    end if;
  end SAVE_SCREEN;

  --ͼ


  --ͻ

  procedure LOAD_SCREEN ( FILENAME : string ) is
    BYTES_PER_ROW,
    NUMBER_OF_BYTES,
    SYSTEM_ADDRESS   : long_integer;
    COUNT            : integer := 1;
    INDEX            : integer := 0;
    TEMP_BYTE        : SPY.byte;
    GOOD             : boolean;

  begin
    -- Check to see if file exists
    if GRAPH_SCREEN = 14 then
      BYTES_PER_ROW := 40;
    else
      BYTES_PER_ROW := 80;
    end if;

    NUMBER_OF_BYTES := BYTES_PER_ROW;

    if not WINDOW_IO.OPEN( FILE_NAME => FILENAME ) then
      return;
    end if;

    if GRAPH_SCREEN >= 4 and GRAPH_SCREEN <= 6 then
      SYSTEM_ADDRESS := PAGE1_MEMORY_START;

      while not WINDOW_IO.END_OF_FILE loop
	WINDOW_IO.READ( REC => BYTE_RECORD, OK => GOOD );
	if not GOOD then
	  return;
	end if;
        INDEX := 1;
        for J in 1 .. NUMBER_OF_BYTES loop
	  SPY.POKE(BYTE_RECORD.BYTE_ARRAY(INDEX),
		   SYSTEM.ADDRESS(SYSTEM_ADDRESS));
          SYSTEM_ADDRESS := SYSTEM_ADDRESS + 1;
          INDEX := INDEX + 1;
        end loop;
      end loop;
    else
      if ACTIVE_PAGE = 0 then
	SYSTEM_ADDRESS := PAGE1_MEMORY_START;
      else
	SYSTEM_ADDRESS := PAGE2_MEMORY_START;
      end if;

      while not WINDOW_IO.END_OF_FILE loop
	WINDOW_IO.READ( REC => BYTE_RECORD, OK => GOOD );
	if not GOOD then
	  return;
	end if;
        for J in 1 .. 80 loop
          PORT.OUT_WORD(16#03CE#, 16#0008#);
          PORT.OUT_WORD(16#03CF#, 16#00FF#);
          TEMP_BYTE := SPY.PEEK(SYSTEM.ADDRESS(SYSTEM_ADDRESS));
          SPY.POKE(16#00#, SYSTEM.ADDRESS(SYSTEM_ADDRESS));
          PORT.OUT_WORD(16#03C4#, 16#0002#);
          PORT.OUT_WORD(16#03C5#, 16#0001#);
          INDEX := INDEX + 1;
          TEMP_BYTE := BYTE_RECORD.BYTE_ARRAY(INDEX);
          SPY.POKE(TEMP_BYTE, SYSTEM.ADDRESS(SYSTEM_ADDRESS));
          PORT.OUT_WORD(16#03C5#, 16#0002#);
          INDEX := INDEX + 1;
          TEMP_BYTE := BYTE_RECORD.BYTE_ARRAY(INDEX);
          SPY.POKE(TEMP_BYTE, SYSTEM.ADDRESS(SYSTEM_ADDRESS));
          PORT.OUT_WORD(16#03C5#, 16#0004#);
          INDEX := INDEX + 1;
          TEMP_BYTE := BYTE_RECORD.BYTE_ARRAY(INDEX);
          SPY.POKE(TEMP_BYTE, SYSTEM.ADDRESS(SYSTEM_ADDRESS));
          PORT.OUT_WORD(16#03C5#, 16#0008#);
          INDEX := INDEX + 1;
          TEMP_BYTE := BYTE_RECORD.BYTE_ARRAY(INDEX);
          SPY.POKE(TEMP_BYTE, SYSTEM.ADDRESS(SYSTEM_ADDRESS));
          SYSTEM_ADDRESS := SYSTEM_ADDRESS + 1;
        end loop;
        INDEX := 0;
      end loop;
    end if;
    if not WINDOW_IO.CLOSE then
      null;
    end if;
  end LOAD_SCREEN;

  --ͼ

end SCREEN;
