--        ͻ
--        ۺ
--                                                                   ۺ
--                         Meridian Software Systems                 ۺ
--                                                                   ۺ
--                            Copyright (C)  1990                    ۺ
--                                                                   ۺ
--                            ALL RIGHTS RESERVED                    ۺ
--                                                                   ۺ
--        ۺ
--        ͼ

------------------------------------------------------------------------------
--
--  Unit Name:  TestInit - package specification
--
--  Purpose of unit:  This package initializes and closes the Ada Graphics
--                    Utility Library.  It must be called before any other
--                    graphics procedure or function, but may only be called
--                    once within an application program.  Initiate_Graph
--                    procedure selects the video page 1 as the active screen
--                    and erases it.  All windows and worlds are initialized
--                    to the graphic screen coordinates.  This procedure will
--                    also turn the graphics mode off and return the system 
--                    to the text mode which was active before Initiate_Graph
--                    was called.
--
------------------------------------------------------------------------------

with COMMON_GRAPHIC_TYPES;

package GRAPH_INIT  is

  procedure CLOSE_GRAPH;
  procedure DETECT_GRAPHIC_CARD;
  procedure INITIATE_GRAPH (DESIRED_VIDEO: COMMON_GRAPHIC_TYPES.VIDEO_SYSTEM);

end GRAPH_INIT;
