--        ͻ
--        ۺ
--                                                                   ۺ
--                         Meridian Software Systems                 ۺ
--                                                                   ۺ
--                            Copyright (C)  1990                    ۺ
--                                                                   ۺ
--                            ALL RIGHTS RESERVED                    ۺ
--                                                                   ۺ
--        ۺ
--        ͼ

------------------------------------------------------------------------------
--
--   Unit Name:   ASMPAK      - package specification
--
--   Purpose of unit:         This package specification contains the
--                            necessary assembly language interface
--                            declarations to allow low level video
--                            routines to be called from ADA subprograms.
--
------------------------------------------------------------------------------


package ASMPAK is

     procedure SET_VIDEO_MODE (MODE: NATURAL);
       pragma interface (ASSEMBLY, SET_VIDEO_MODE, "VIDEO_MODE");

     procedure DRAW_BASIC_LINE (X1, Y1, X2, Y2:     INTEGER;
				COLOR:              NATURAL;
				DUX, DUY, DLX, DLY: NATURAL;
				CLP, VIDEO_PAGE:    NATURAL);
       pragma interface (ASSEMBLY, DRAW_BASIC_LINE, "DRAW");

     procedure PLOTXY (X, Y, COLOR, VIDEO_PAGE: NATURAL);
       pragma interface (ASSEMBLY, PLOTXY, "PLOT");

     procedure BEEP;
       pragma interface (ASSEMBLY, BEEP, "BEEP");

     function READ_PIXEL_ATTR (X, Y: INTEGER) return integer;
       pragma interface (ASSEMBLY, READ_PIXEL_ATTR, "READPIX");

     procedure CLEAR_SCREEN;
       pragma interface (ASSEMBLY, CLEAR_SCREEN, "CLRSCR");

end ASMPAK;
